/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.listbucketingpruner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.PrunerOperatorFactory;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.LBOpPartitionWalkerCtx;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class LBPartitionProcFactory
extends PrunerOperatorFactory {
    static final Log LOG = LogFactory.getLog((String)ListBucketingPruner.class.getName());

    public static NodeProcessor getFilterProc() {
        return new LBPRPartitionFilterPruner();
    }

    private LBPartitionProcFactory() {
    }

    public static class LBPRPartitionFilterPruner
    extends PrunerOperatorFactory.FilterPruner {
        @Override
        protected void generatePredicate(NodeProcessorCtx procCtx, FilterOperator fop, TableScanOperator top) throws SemanticException, UDFArgumentException {
            ExprNodeDesc ppr_pred;
            LBOpPartitionWalkerCtx owc = (LBOpPartitionWalkerCtx)procCtx;
            ParseContext parseCtx = owc.getParseContext();
            PrunedPartitionList prunedPartList = parseCtx.getOpToPartList().get(top);
            if (prunedPartList == null && (ppr_pred = parseCtx.getOpToPartPruner().get(top)) != null) {
                try {
                    prunedPartList = PartitionPruner.prune(parseCtx.getTopToTable().get(top), ppr_pred, parseCtx.getConf(), (String)parseCtx.getTopOps().keySet().toArray()[0], parseCtx.getPrunedPartitions());
                    if (prunedPartList != null) {
                        owc.getParseContext().getOpToPartList().put(top, prunedPartList);
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage(), e);
                }
            }
            if (prunedPartList != null) {
                owc.setPartitions(prunedPartList);
            }
        }
    }
}

