/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeConstantDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object value;

    public ExprNodeConstantDesc() {
    }

    public ExprNodeConstantDesc(TypeInfo typeInfo, Object value) {
        super(typeInfo);
        this.value = value;
    }

    public ExprNodeConstantDesc(Object value) {
        this(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(value.getClass()), value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public ConstantObjectInspector getWritableObjectInspector() {
        PrimitiveObjectInspector.PrimitiveCategory pc = ((PrimitiveTypeInfo)this.getTypeInfo()).getPrimitiveCategory();
        Object writableValue = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(pc).getPrimitiveWritableObject(this.getValue());
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector(pc, writableValue);
    }

    public String toString() {
        return "Const " + this.typeInfo.toString() + " " + this.value;
    }

    @Override
    @Explain(displayName="expr")
    public String getExprString() {
        if (this.value == null) {
            return "null";
        }
        if (this.typeInfo.getTypeName().equals("string")) {
            return "'" + this.value.toString() + "'";
        }
        return this.value.toString();
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeConstantDesc(this.typeInfo, this.value);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeConstantDesc)) {
            return false;
        }
        ExprNodeConstantDesc dest = (ExprNodeConstantDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo())) {
            return false;
        }
        return this.value.equals(dest.getValue());
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append(this.value);
        return builder.toHashCode();
    }
}

