/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.math.BigDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.BigDecimalWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="floor", value="_FUNC_(x) - Find the largest integer not greater than x", extended="Example:\n  > SELECT _FUNC_(-0.1) FROM src LIMIT 1;\n  -1\n  > SELECT _FUNC_(5) FROM src LIMIT 1;\n  5")
public class UDFFloor
extends UDF {
    private final LongWritable result = new LongWritable();
    private final BigDecimalWritable bdResult = new BigDecimalWritable();

    public LongWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.result.set((long)Math.floor(i.get()));
        return this.result;
    }

    public BigDecimalWritable evaluate(BigDecimalWritable i) {
        if (i == null) {
            return null;
        }
        BigDecimal bd = i.getBigDecimal();
        int origScale = bd.scale();
        this.bdResult.set(bd.setScale(0, 3).setScale(origScale));
        return this.bdResult;
    }
}

