/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.BigDecimalWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="/", value="a _FUNC_ b - Divide a by b", extended="Example:\n  > SELECT 3 _FUNC_ 2 FROM src LIMIT 1;\n  1.5")
public class UDFOPDivide
extends UDF {
    private final DoubleWritable doubleWritable = new DoubleWritable();
    private final BigDecimalWritable bigDecimalWritable = new BigDecimalWritable();
    private final int MAX_SCALE = 65;

    public DoubleWritable evaluate(DoubleWritable a, DoubleWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.doubleWritable.set(a.get() / b.get());
        return this.doubleWritable;
    }

    public BigDecimalWritable evaluate(BigDecimalWritable a, BigDecimalWritable b) {
        if (a == null || b == null) {
            return null;
        }
        if (b.getBigDecimal().compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        this.bigDecimalWritable.set(a.getBigDecimal().divide(b.getBigDecimal(), 65, RoundingMode.HALF_UP));
        return this.bigDecimalWritable;
    }
}

