/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.avro.AvroDeserializer;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.AvroSerializer;
import org.apache.hadoop.hive.serde2.avro.BadSchemaException;
import org.apache.hadoop.hive.serde2.avro.SchemaResolutionProblem;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Writable;

public class AvroSerDe
implements SerDe {
    private static final Log LOG = LogFactory.getLog(AvroSerDe.class);
    private ObjectInspector oi;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private Schema schema;
    private AvroDeserializer avroDeserializer = null;
    private AvroSerializer avroSerializer = null;
    private boolean badSchema = false;

    @Override
    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        if (this.schema != null) {
            LOG.info((Object)"Resetting already initialized AvroSerDe");
        }
        this.schema = null;
        this.oi = null;
        this.columnNames = null;
        this.columnTypes = null;
        this.schema = AvroSerdeUtils.determineSchemaOrReturnErrorSchema(properties);
        if (configuration == null) {
            LOG.info((Object)"Configuration null, not inserting schema");
        } else {
            configuration.set("avro.serde.schema", this.schema.toString(false));
        }
        this.badSchema = this.schema.equals((Object)SchemaResolutionProblem.SIGNAL_BAD_SCHEMA);
        AvroObjectInspectorGenerator aoig = new AvroObjectInspectorGenerator(this.schema);
        this.columnNames = aoig.getColumnNames();
        this.columnTypes = aoig.getColumnTypes();
        this.oi = aoig.getObjectInspector();
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return AvroGenericRecordWritable.class;
    }

    @Override
    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.getSerializer().serialize(o, objectInspector, this.columnNames, this.columnTypes, this.schema);
    }

    @Override
    public Object deserialize(Writable writable) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.getDeserializer().deserialize(this.columnNames, this.columnTypes, writable, this.schema);
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.oi;
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    private AvroDeserializer getDeserializer() {
        if (this.avroDeserializer == null) {
            this.avroDeserializer = new AvroDeserializer();
        }
        return this.avroDeserializer;
    }

    private AvroSerializer getSerializer() {
        if (this.avroSerializer == null) {
            this.avroSerializer = new AvroSerializer();
        }
        return this.avroSerializer;
    }
}

