/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.hive.serde2.io.BigDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBigDecimalObjectInspector;

public class JavaBigDecimalObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBigDecimalObjectInspector {
    protected JavaBigDecimalObjectInspector() {
        super(PrimitiveObjectInspectorUtils.decimalTypeEntry);
    }

    @Override
    public BigDecimalWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BigDecimalWritable((BigDecimal)o);
    }

    @Override
    public BigDecimal getPrimitiveJavaObject(Object o) {
        return o == null ? null : (BigDecimal)o;
    }

    @Override
    public Object set(Object o, byte[] bytes, int scale) {
        return new BigDecimal(new BigInteger(bytes), scale);
    }

    @Override
    public Object set(Object o, BigDecimal t) {
        return t;
    }

    @Override
    public Object set(Object o, BigDecimalWritable t) {
        return t == null ? null : t.getBigDecimal();
    }

    @Override
    public Object create(byte[] bytes, int scale) {
        return new BigDecimal(new BigInteger(bytes), scale);
    }

    @Override
    public Object create(BigDecimal t) {
        return t == null ? null : new BigDecimal(t.unscaledValue(), t.scale());
    }
}

