/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.util.HashMap;
import org.apache.hadoop.hive.serde2.io.BigDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaBigDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaVoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBigDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBigDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableVoidObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public final class PrimitiveObjectInspectorFactory {
    public static final JavaBooleanObjectInspector javaBooleanObjectInspector = new JavaBooleanObjectInspector();
    public static final JavaByteObjectInspector javaByteObjectInspector = new JavaByteObjectInspector();
    public static final JavaShortObjectInspector javaShortObjectInspector = new JavaShortObjectInspector();
    public static final JavaIntObjectInspector javaIntObjectInspector = new JavaIntObjectInspector();
    public static final JavaLongObjectInspector javaLongObjectInspector = new JavaLongObjectInspector();
    public static final JavaFloatObjectInspector javaFloatObjectInspector = new JavaFloatObjectInspector();
    public static final JavaDoubleObjectInspector javaDoubleObjectInspector = new JavaDoubleObjectInspector();
    public static final JavaStringObjectInspector javaStringObjectInspector = new JavaStringObjectInspector();
    public static final JavaVoidObjectInspector javaVoidObjectInspector = new JavaVoidObjectInspector();
    public static final JavaTimestampObjectInspector javaTimestampObjectInspector = new JavaTimestampObjectInspector();
    public static final JavaBinaryObjectInspector javaByteArrayObjectInspector = new JavaBinaryObjectInspector();
    public static final JavaBigDecimalObjectInspector javaBigDecimalObjectInspector = new JavaBigDecimalObjectInspector();
    public static final WritableBooleanObjectInspector writableBooleanObjectInspector = new WritableBooleanObjectInspector();
    public static final WritableByteObjectInspector writableByteObjectInspector = new WritableByteObjectInspector();
    public static final WritableShortObjectInspector writableShortObjectInspector = new WritableShortObjectInspector();
    public static final WritableIntObjectInspector writableIntObjectInspector = new WritableIntObjectInspector();
    public static final WritableLongObjectInspector writableLongObjectInspector = new WritableLongObjectInspector();
    public static final WritableFloatObjectInspector writableFloatObjectInspector = new WritableFloatObjectInspector();
    public static final WritableDoubleObjectInspector writableDoubleObjectInspector = new WritableDoubleObjectInspector();
    public static final WritableStringObjectInspector writableStringObjectInspector = new WritableStringObjectInspector();
    public static final WritableVoidObjectInspector writableVoidObjectInspector = new WritableVoidObjectInspector();
    public static final WritableTimestampObjectInspector writableTimestampObjectInspector = new WritableTimestampObjectInspector();
    public static final WritableBinaryObjectInspector writableBinaryObjectInspector = new WritableBinaryObjectInspector();
    public static final WritableBigDecimalObjectInspector writableBigDecimalObjectInspector = new WritableBigDecimalObjectInspector();
    private static HashMap<PrimitiveObjectInspector.PrimitiveCategory, AbstractPrimitiveWritableObjectInspector> cachedPrimitiveWritableInspectorCache = new HashMap();
    private static HashMap<PrimitiveObjectInspector.PrimitiveCategory, AbstractPrimitiveJavaObjectInspector> cachedPrimitiveJavaInspectorCache;

    public static AbstractPrimitiveWritableObjectInspector getPrimitiveWritableObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        AbstractPrimitiveWritableObjectInspector result = cachedPrimitiveWritableInspectorCache.get((Object)primitiveCategory);
        if (result == null) {
            throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
        }
        return result;
    }

    public static ConstantObjectInspector getPrimitiveWritableConstantObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, Object value) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return new WritableConstantBooleanObjectInspector((BooleanWritable)value);
            }
            case BYTE: {
                return new WritableConstantByteObjectInspector((ByteWritable)value);
            }
            case SHORT: {
                return new WritableConstantShortObjectInspector((ShortWritable)value);
            }
            case INT: {
                return new WritableConstantIntObjectInspector((IntWritable)value);
            }
            case LONG: {
                return new WritableConstantLongObjectInspector((LongWritable)value);
            }
            case FLOAT: {
                return new WritableConstantFloatObjectInspector((FloatWritable)value);
            }
            case DOUBLE: {
                return new WritableConstantDoubleObjectInspector((DoubleWritable)value);
            }
            case STRING: {
                return new WritableConstantStringObjectInspector((Text)value);
            }
            case TIMESTAMP: {
                return new WritableConstantTimestampObjectInspector((TimestampWritable)value);
            }
            case DECIMAL: {
                return new WritableConstantBigDecimalObjectInspector((BigDecimalWritable)value);
            }
            case BINARY: {
                return new WritableConstantBinaryObjectInspector((BytesWritable)value);
            }
            case VOID: {
                return new WritableVoidObjectInspector();
            }
        }
        throw new RuntimeException("Internal error: Cannot find ConstantObjectInspector for " + (Object)((Object)primitiveCategory));
    }

    public static AbstractPrimitiveJavaObjectInspector getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        AbstractPrimitiveJavaObjectInspector result = cachedPrimitiveJavaInspectorCache.get((Object)primitiveCategory);
        if (result == null) {
            throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
        }
        return result;
    }

    public static PrimitiveObjectInspector getPrimitiveObjectInspectorFromClass(Class<?> c) {
        if (Writable.class.isAssignableFrom(c)) {
            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry te = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveWritableClass(c);
            if (te == null) {
                throw new RuntimeException("Internal error: Cannot recognize " + c);
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(te.primitiveCategory);
        }
        PrimitiveObjectInspectorUtils.PrimitiveTypeEntry te = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaClass(c);
        if (te == null) {
            throw new RuntimeException("Internal error: Cannot recognize " + c);
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(te.primitiveCategory);
    }

    private PrimitiveObjectInspectorFactory() {
    }

    static {
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, writableBooleanObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BYTE, writableByteObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, writableShortObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.INT, writableIntObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.LONG, writableLongObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, writableFloatObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, writableDoubleObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.STRING, writableStringObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.VOID, writableVoidObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, writableTimestampObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BINARY, writableBinaryObjectInspector);
        cachedPrimitiveWritableInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.DECIMAL, writableBigDecimalObjectInspector);
        cachedPrimitiveJavaInspectorCache = new HashMap();
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, javaBooleanObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BYTE, javaByteObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, javaShortObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.INT, javaIntObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.LONG, javaLongObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, javaFloatObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, javaDoubleObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.STRING, javaStringObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.VOID, javaVoidObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, javaTimestampObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.BINARY, javaByteArrayObjectInspector);
        cachedPrimitiveJavaInspectorCache.put(PrimitiveObjectInspector.PrimitiveCategory.DECIMAL, javaBigDecimalObjectInspector);
    }
}

