/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.JobCloseFeedBack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePartitioner;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SkewedColumnPositionPair;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SubStructObjectInspector;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class FileSinkOperator
extends TerminalOperator<FileSinkDesc>
implements Serializable {
    protected transient HashMap<String, FSPaths> valToPaths;
    protected transient int numDynParts;
    protected transient List<String> dpColNames;
    protected transient DynamicPartitionCtx dpCtx;
    protected transient boolean isCompressed;
    protected transient Path parent;
    protected transient HiveOutputFormat<?, ?> hiveOutputFormat;
    protected transient Path specPath;
    protected transient String childSpecPathDynLinkedPartitions;
    protected transient int dpStartCol;
    protected transient List<String> dpVals;
    protected transient List<Object> dpWritables;
    protected transient RecordWriter[] rowOutWriters;
    protected transient int maxPartitions;
    protected transient ListBucketingCtx lbCtx;
    protected transient boolean isSkewedStoredAsSubDirectories;
    private transient boolean statsCollectRawDataSize;
    protected transient Progressable progresser;
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Number of dynamic partitions exceeded hive.exec.max.dynamic.partitions.pernode."};
    private static final long serialVersionUID = 1L;
    protected transient FileSystem fs;
    protected transient Serializer serializer;
    protected transient BytesWritable commonKey = new BytesWritable();
    protected transient TableIdEnum tabIdEnum = null;
    private transient LongWritable row_count;
    private transient boolean isNativeTable = true;
    private transient ExprNodeEvaluator[] partitionEval;
    private transient int totalFiles;
    private transient int numFiles;
    private transient boolean multiFileSpray;
    private final transient Map<Integer, Integer> bucketMap = new HashMap<Integer, Integer>();
    private transient ObjectInspector[] partitionObjectInspectors;
    private transient HivePartitioner<HiveKey, Object> prtner;
    private final transient HiveKey key = new HiveKey();
    private transient Configuration hconf;
    private transient FSPaths fsp;
    private transient boolean bDynParts;
    private transient SubStructObjectInspector subSetOI;
    private transient int timeOut;
    private transient long lastProgressReport = System.currentTimeMillis();
    protected transient boolean autoDelete = false;
    protected transient JobConf jc;
    Class<? extends Writable> outputClass;
    String taskId;
    private boolean filesCreated = false;
    Writable recordValue;

    private void initializeSpecPath() {
        if (!((FileSinkDesc)this.conf).isLinkedFileSink() || this.dpCtx == null) {
            this.specPath = new Path(((FileSinkDesc)this.conf).getDirName());
            this.childSpecPathDynLinkedPartitions = null;
            return;
        }
        this.specPath = new Path(((FileSinkDesc)this.conf).getParentDir());
        this.childSpecPathDynLinkedPartitions = Utilities.getFileNameFromDirName(((FileSinkDesc)this.conf).getDirName());
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            int id;
            this.hconf = hconf;
            this.filesCreated = false;
            this.isNativeTable = !((FileSinkDesc)this.conf).getTableInfo().isNonNative();
            this.multiFileSpray = ((FileSinkDesc)this.conf).isMultiFileSpray();
            this.totalFiles = ((FileSinkDesc)this.conf).getTotalFiles();
            this.numFiles = ((FileSinkDesc)this.conf).getNumFiles();
            this.dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
            this.lbCtx = ((FileSinkDesc)this.conf).getLbCtx();
            this.valToPaths = new HashMap();
            this.taskId = Utilities.getTaskId(hconf);
            this.initializeSpecPath();
            this.fs = this.specPath.getFileSystem(hconf);
            this.hiveOutputFormat = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
            this.isCompressed = ((FileSinkDesc)this.conf).getCompressed();
            this.parent = Utilities.toTempPath(((FileSinkDesc)this.conf).getDirName());
            this.statsCollectRawDataSize = ((FileSinkDesc)this.conf).isStatsCollectRawDataSize();
            this.serializer = (Serializer)((Object)((FileSinkDesc)this.conf).getTableInfo().getDeserializerClass().newInstance());
            this.serializer.initialize(null, ((FileSinkDesc)this.conf).getTableInfo().getProperties());
            this.outputClass = this.serializer.getSerializedClass();
            this.timeOut = hconf.getInt("mapred.healthChecker.script.timeout", 600000) / 2;
            this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf, ExecDriver.class);
            if (this.multiFileSpray) {
                this.partitionEval = new ExprNodeEvaluator[((FileSinkDesc)this.conf).getPartitionCols().size()];
                int i = 0;
                for (ExprNodeDesc e : ((FileSinkDesc)this.conf).getPartitionCols()) {
                    this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
                }
                this.partitionObjectInspectors = FileSinkOperator.initEvaluators(this.partitionEval, this.outputObjInspector);
                this.prtner = (HivePartitioner)ReflectionUtils.newInstance((Class)this.jc.getPartitionerClass(), null);
            }
            if ((id = ((FileSinkDesc)this.conf).getDestTableId()) != 0 && id <= TableIdEnum.values().length) {
                String enumName = "TABLE_ID_" + String.valueOf(id) + "_ROWCOUNT";
                this.tabIdEnum = TableIdEnum.valueOf(enumName);
                this.row_count = new LongWritable();
                this.statsMap.put(this.tabIdEnum, this.row_count);
            }
            if (this.dpCtx != null) {
                this.dpSetup();
            }
            if (this.lbCtx != null) {
                this.lbSetup();
            }
            if (!this.bDynParts) {
                this.fsp = new FSPaths(this.specPath);
                if (!this.isSkewedStoredAsSubDirectories) {
                    this.valToPaths.put("", this.fsp);
                }
            }
            this.initializeChildren(hconf);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    private void lbSetup() {
        this.isSkewedStoredAsSubDirectories = this.lbCtx == null ? false : this.lbCtx.isSkewedStoredAsDir();
    }

    private void dpSetup() {
        this.bDynParts = false;
        this.numDynParts = this.dpCtx.getNumDPCols();
        this.dpColNames = this.dpCtx.getDPColNames();
        this.maxPartitions = this.dpCtx.getMaxPartitionsPerNode();
        assert (this.numDynParts == this.dpColNames.size()) : "number of dynamic paritions should be the same as the size of DP mapping";
        if (this.dpColNames != null && this.dpColNames.size() > 0) {
            this.bDynParts = true;
            assert (this.inputObjInspectors.length == 1) : "FileSinkOperator should have 1 parent, but it has " + this.inputObjInspectors.length;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            List<? extends StructField> fieldOI = soi.getAllStructFieldRefs();
            ArrayList<ObjectInspector> newFieldsOI = new ArrayList<ObjectInspector>();
            ArrayList<String> newFieldsName = new ArrayList<String>();
            this.dpStartCol = 0;
            for (StructField structField : fieldOI) {
                String fn = structField.getFieldName();
                if (this.dpCtx.getInputToDPCols().containsKey(fn)) continue;
                newFieldsOI.add(structField.getFieldObjectInspector());
                newFieldsName.add(structField.getFieldName());
                ++this.dpStartCol;
            }
            assert (newFieldsOI.size() > 0) : "new Fields ObjectInspector is empty";
            this.subSetOI = new SubStructObjectInspector(soi, 0, this.dpStartCol);
            this.dpVals = new ArrayList<String>(this.numDynParts);
            this.dpWritables = new ArrayList<Object>(this.numDynParts);
        }
    }

    private void createBucketFiles(FSPaths fsp, Progressable progressable) throws HiveException {
        try {
            int filesIdx = 0;
            HashSet<Integer> seenBuckets = new HashSet<Integer>();
            for (int idx = 0; idx < this.totalFiles; ++idx) {
                String extension;
                if (this.getExecContext() != null && this.getExecContext().getFileId() != null) {
                    this.LOG.info((Object)"replace taskId from execContext ");
                    this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, this.getExecContext().getFileId());
                    this.LOG.info((Object)("new taskId: FS " + this.taskId));
                    assert (!this.multiFileSpray);
                    assert (this.totalFiles == 1);
                }
                if (this.multiFileSpray) {
                    int bucketNum;
                    int reducerIdx;
                    int currReducer;
                    this.key.setHashCode(idx);
                    int numReducers = this.totalFiles / this.numFiles;
                    if (numReducers > 1 && (currReducer = Integer.valueOf(Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf))).intValue()) != (reducerIdx = this.prtner.getPartition((Object)this.key, null, numReducers)) || seenBuckets.contains(bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles))) continue;
                    seenBuckets.add(bucketNum);
                    this.bucketMap.put(bucketNum, filesIdx);
                    this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), bucketNum);
                }
                if (this.isNativeTable && this.fsSupportsMove()) {
                    fsp.finalPaths[filesIdx] = fsp.getFinalPath(this.taskId);
                    this.LOG.info((Object)("Final Path: FS " + fsp.finalPaths[filesIdx]));
                    fsp.outPaths[filesIdx] = fsp.getTaskOutPath(this.taskId);
                    this.LOG.info((Object)("Writing to temp file: FS " + fsp.outPaths[filesIdx]));
                    this.autoDelete = ShimLoader.getHadoopShims().fileSystemDeleteOnExit(this.fs, fsp.outPaths[filesIdx]);
                } else {
                    fsp.finalPaths[filesIdx] = fsp.outPaths[filesIdx] = this.specPath;
                }
                try {
                    extension = Utilities.getFileExtension(this.jc, this.isCompressed, this.hiveOutputFormat);
                    if (!this.bDynParts && !this.isSkewedStoredAsSubDirectories) {
                        fsp.finalPaths[filesIdx] = fsp.getFinalPath(this.taskId, this.parent, extension);
                    } else {
                        fsp.finalPaths[filesIdx] = fsp.getFinalPath(this.taskId, fsp.tmpPath, extension);
                        this.LOG.info((Object)("Final dp path: " + fsp.finalPaths[filesIdx] + " for filesIdx " + filesIdx));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HiveException(e);
                }
                if (!this.fsSupportsMove()) {
                    Path outPath;
                    extension = Utilities.getFileExtension(this.jc, this.isCompressed, this.hiveOutputFormat);
                    String fileName = Utilities.getS3FileName(this.taskId, ((FileSinkDesc)this.conf).getQueryId());
                    fsp.finalPaths[filesIdx] = outPath = fsp.getFinalPath(fileName, fsp.tmpPath, extension);
                    fsp.outPaths[filesIdx] = outPath;
                }
                this.LOG.info((Object)("New Final Path: FS " + fsp.finalPaths[filesIdx]));
                Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), this.jc);
                fsp.outWriters[filesIdx] = HiveFileFormatUtils.getHiveRecordWriter(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), this.outputClass, (FileSinkDesc)this.conf, fsp.outPaths[filesIdx], (Progressable)this.reporter);
                if (this.reporter != null) {
                    this.reporter.incrCounter((Enum)Operator.ProgressCounter.CREATED_FILES, 1L);
                }
                ++filesIdx;
            }
            assert (filesIdx == this.numFiles);
            if (!this.fsSupportsMove()) {
                FileSystem fs = this.specPath.getFileSystem(this.hconf);
                Utilities.delTmpFileAtSpecPathS3(fs, this.specPath.getName(), this.specPath.getParent());
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
        this.filesCreated = true;
    }

    private boolean updateProgress() {
        if (this.reporter != null && System.currentTimeMillis() - this.lastProgressReport > (long)this.timeOut) {
            this.reporter.progress();
            this.lastProgressReport = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    private Progressable getProgressable() {
        if (this.progresser == null) {
            this.progresser = new Progressable(){

                public void progress() {
                    if (FileSinkOperator.this.reporter != null) {
                        FileSinkOperator.this.reporter.progress();
                    } else {
                        FileSinkOperator.this.LOG.warn((Object)"CallbackProgressable: cannot report progress because reporter is null");
                    }
                }

                public String toString() {
                    return "CallbackProgresable(" + FileSinkOperator.this.reporter + ")";
                }
            };
        }
        return this.progresser;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        String lbDirName = null;
        String string = lbDirName = this.lbCtx == null ? null : this.generateListBucketingDirName(row);
        if (!this.bDynParts && !this.filesCreated) {
            if (lbDirName != null) {
                FSPaths fsp2 = this.lookupListBucketingPaths(lbDirName);
            } else {
                this.createBucketFiles(this.fsp, this.getProgressable());
            }
        }
        if (this.counterNameToEnum != null) {
            ++this.outputRows;
            if (this.outputRows % 1000L == 0L) {
                this.incrCounter(numOutputRowsCntr, this.outputRows);
                this.outputRows = 0L;
            }
        }
        try {
            FSPaths fpaths;
            this.updateProgress();
            assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
            if (this.bDynParts) {
                this.dpVals.clear();
                this.dpWritables.clear();
                ObjectInspectorUtils.partialCopyToStandardObject(this.dpWritables, row, this.dpStartCol, this.numDynParts, (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                for (Object o : this.dpWritables) {
                    if (o == null || o.toString().length() == 0) {
                        this.dpVals.add(this.dpCtx.getDefaultPartitionName());
                        continue;
                    }
                    this.dpVals.add(o.toString());
                }
                this.recordValue = this.serializer.serialize(row, this.subSetOI);
                fpaths = this.getDynOutPaths(this.dpVals, lbDirName, this.getProgressable());
            } else {
                fpaths = lbDirName != null ? this.lookupListBucketingPaths(lbDirName) : this.fsp;
                this.recordValue = this.serializer.serialize(row, this.inputObjInspectors[0]);
            }
            this.rowOutWriters = fpaths.outWriters;
            if (((FileSinkDesc)this.conf).isGatherStats()) {
                SerDeStats stats;
                if (this.statsCollectRawDataSize && (stats = this.serializer.getSerDeStats()) != null) {
                    fpaths.stat.addToStat("rawDataSize", stats.getRawDataSize());
                }
                fpaths.stat.addToStat("numRows", 1L);
            }
            if (this.row_count != null) {
                this.row_count.set(this.row_count.get() + 1L);
            }
            if (!this.multiFileSpray) {
                this.rowOutWriters[0].write(this.recordValue);
            } else {
                int keyHashCode = 0;
                for (int i = 0; i < this.partitionEval.length; ++i) {
                    Object o = this.partitionEval[i].evaluate(row);
                    keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode(o, this.partitionObjectInspectors[i]);
                }
                this.key.setHashCode(keyHashCode);
                int bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles);
                int idx = this.bucketMap.get(bucketNum);
                this.rowOutWriters[idx].write(this.recordValue);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    private FSPaths lookupListBucketingPaths(String lbDirName) throws HiveException {
        FSPaths fsp2 = this.valToPaths.get(lbDirName);
        if (fsp2 == null) {
            fsp2 = this.createNewPaths(lbDirName, this.getProgressable());
        }
        return fsp2;
    }

    private FSPaths createNewPaths(String dirName, Progressable callbackProgressable) throws HiveException {
        FSPaths fsp2 = new FSPaths(this.specPath);
        if (this.childSpecPathDynLinkedPartitions != null) {
            fsp2.tmpPath = new Path(fsp2.tmpPath, dirName + "/" + this.childSpecPathDynLinkedPartitions);
            fsp2.taskOutputTempPath = new Path(fsp2.taskOutputTempPath, dirName + "/" + this.childSpecPathDynLinkedPartitions);
        } else {
            fsp2.tmpPath = new Path(fsp2.tmpPath, dirName);
            fsp2.taskOutputTempPath = new Path(fsp2.taskOutputTempPath, dirName);
        }
        if (!this.fsSupportsMove() && ((FileSinkDesc)this.conf).getDeleteS3Path()) {
            try {
                Utilities.cleanS3DynDirectory(fsp2.tmpPath, fsp2.tmpPath.getFileSystem(this.hconf), ((FileSinkDesc)this.conf).getQueryId());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.createBucketFiles(fsp2, callbackProgressable);
        this.valToPaths.put(dirName, fsp2);
        return fsp2;
    }

    private String generateListBucketingDirName(Object row) {
        if (!this.isSkewedStoredAsSubDirectories) {
            return null;
        }
        String lbDirName = null;
        ArrayList<Object> standObjs = new ArrayList<Object>();
        List<String> skewedCols = this.lbCtx.getSkewedColNames();
        List<List<String>> allSkewedVals = this.lbCtx.getSkewedColValues();
        ArrayList<String> skewedValsCandidate = null;
        Map<List<String>, String> locationMap = this.lbCtx.getLbLocationMap();
        ObjectInspectorUtils.copyToStandardObject(standObjs, row, (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        assert (standObjs.size() >= skewedCols.size()) : "The row has less number of columns than no. of skewed column.";
        skewedValsCandidate = new ArrayList<String>(skewedCols.size());
        for (SkewedColumnPositionPair posPair : this.lbCtx.getRowSkewedIndex()) {
            skewedValsCandidate.add(posPair.getSkewColPosition(), standObjs.get(posPair.getTblColPosition()).toString());
        }
        if (allSkewedVals.contains(skewedValsCandidate)) {
            lbDirName = FileUtils.makeListBucketingDirName(skewedCols, skewedValsCandidate);
            locationMap.put(skewedValsCandidate, lbDirName);
        } else {
            lbDirName = FileUtils.makeDefaultListBucketingDirName(skewedCols, this.lbCtx.getDefaultDirName());
            List<String> defaultKey = Arrays.asList(this.lbCtx.getDefaultKey());
            if (!locationMap.containsKey(defaultKey)) {
                locationMap.put(defaultKey, lbDirName);
            }
        }
        return lbDirName;
    }

    private FSPaths getDynOutPaths(List<String> row, String lbDirName, Progressable callbackProgressable) throws HiveException {
        FSPaths fp;
        String dpDir = this.getDynPartDirectory(row, this.dpColNames, this.numDynParts);
        if (dpDir != null) {
            FSPaths fsp2 = this.valToPaths.get(dpDir = this.appendListBucketingDirName(lbDirName, dpDir));
            if (fsp2 == null) {
                if (this.valToPaths.size() > this.maxPartitions) {
                    if (this.counterNameToEnum != null) {
                        this.incrCounter(fatalErrorCntr, 1L);
                    }
                    fatalError = true;
                    this.LOG.error((Object)"Fatal error was thrown due to exceeding number of dynamic partitions");
                }
                fsp2 = this.createNewPaths(dpDir, callbackProgressable);
            }
            fp = fsp2;
        } else {
            fp = this.fsp;
        }
        return fp;
    }

    private String appendListBucketingDirName(String lbDirName, String dpDir) {
        StringBuilder builder = new StringBuilder(dpDir);
        dpDir = lbDirName == null ? dpDir : builder.append("/").append(lbDirName).toString();
        return dpDir;
    }

    private String getDynPartDirectory(List<String> row, List<String> dpColNames, int numDynParts) {
        assert (row.size() == numDynParts && numDynParts == dpColNames.size()) : "data length is different from num of DP columns";
        return FileUtils.makePartName(dpColNames, row);
    }

    @Override
    protected void fatalErrorMessage(StringBuilder errMsg, long counterCode) {
        errMsg.append("Operator ").append(this.getOperatorId()).append(" (id=").append(this.id).append("): ");
        errMsg.append(counterCode > (long)(FATAL_ERR_MSG.length - 1) ? "fatal error." : FATAL_ERR_MSG[(int)counterCode]);
        if (counterCode > 0L) {
            errMsg.append(this.lsDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lsDir() {
        String specPath = ((FileSinkDesc)this.conf).getDirName();
        JobConf jobConf = new JobConf(ExecDriver.class);
        Path tmpPath = Utilities.toTempPath(specPath);
        StringBuilder sb = new StringBuilder("\n");
        try {
            DynamicPartitionCtx dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
            int numDP = dpCtx.getNumDPCols();
            FileSystem fs = tmpPath.getFileSystem((Configuration)jobConf);
            int level = numDP;
            if (((FileSinkDesc)this.conf).isLinkedFileSink()) {
                ++level;
            }
            FileStatus[] status = Utilities.getFileStatusRecurse(tmpPath, level, fs);
            sb.append("Sample of ").append(Math.min(status.length, 100)).append(" partitions created under ").append(tmpPath.toString()).append(":\n");
            for (int i = 0; i < status.length; ++i) {
                sb.append("\t.../");
                sb.append(this.getPartitionSpec(status[i].getPath(), numDP)).append("\n");
            }
            sb.append("...\n");
        }
        catch (Exception e) {
            sb.append(tmpPath).append("...\n").append(e.getMessage());
            e.printStackTrace();
        }
        finally {
            return sb.toString();
        }
    }

    private String getPartitionSpec(Path path, int level) {
        Stack<String> st = new Stack<String>();
        Path p = path;
        for (int i = 0; i < level; ++i) {
            st.push(p.getName());
            p = p.getParent();
        }
        StringBuilder sb = new StringBuilder();
        while (!st.empty()) {
            sb.append((String)st.pop());
        }
        return sb.toString();
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!this.bDynParts && !this.filesCreated) {
            this.createBucketFiles(this.fsp, this.getProgressable());
        }
        this.lastProgressReport = System.currentTimeMillis();
        if (!abort) {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.closeWriters(abort);
                if (!this.isNativeTable || !this.fsSupportsMove()) continue;
                fsp.commit(this.fs);
            }
            if (((FileSinkDesc)this.conf).isGatherStats()) {
                this.publishStats();
            }
        } else {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.abortWriters(this.fs, abort, !this.autoDelete && this.isNativeTable && this.fsSupportsMove());
            }
        }
    }

    @Override
    public String getName() {
        return FileSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "FS";
    }

    public boolean fsSupportsMove() {
        return !Utilities.isS3Path(new Path(((FileSinkDesc)this.conf).getDirName()));
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success, JobCloseFeedBack feedBack) throws HiveException {
        try {
            if (this.conf != null && this.isNativeTable) {
                String specPath = ((FileSinkDesc)this.conf).getDirName();
                DynamicPartitionCtx dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
                if (((FileSinkDesc)this.conf).isLinkedFileSink() && dpCtx != null) {
                    specPath = ((FileSinkDesc)this.conf).getParentDir();
                }
                if (this.fsSupportsMove()) {
                    Utilities.mvFileToFinalPath(specPath, hconf, success, this.LOG, dpCtx, (FileSinkDesc)this.conf, this.getProgressable());
                } else {
                    Utilities.ensureBucketingOnS3Path(hconf, specPath, dpCtx, ((FileSinkDesc)this.conf).getQueryId(), (FileSinkDesc)this.conf, this.getProgressable());
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        super.jobCloseOp(hconf, success, feedBack);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }

    @Override
    public void augmentPlan() {
        PlanUtils.configureOutputJobPropertiesForStorageHandler(((FileSinkDesc)this.getConf()).getTableInfo());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (this.hiveOutputFormat == null) {
            try {
                this.hiveOutputFormat = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), job);
        if (((FileSinkDesc)this.conf).getTableInfo().isNonNative()) {
            try {
                this.hiveOutputFormat.checkOutputSpecs(ignored, job);
            }
            catch (NoSuchMethodError e) {
                this.LOG.warn((Object)"HiveOutputFormat should implement checkOutputSpecs() method`");
            }
        }
    }

    private void publishStats() throws HiveException {
        boolean isStatsReliable = ((FileSinkDesc)this.conf).isStatsReliable();
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (statsPublisher == null) {
            this.LOG.error((Object)"StatsPublishing error: StatsPublisher is not initialized.");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
            }
            return;
        }
        if (!statsPublisher.connect(this.hconf)) {
            this.LOG.error((Object)"StatsPublishing error: cannot connect to database");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
            }
            return;
        }
        String taskID = Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf));
        String spSpec = ((FileSinkDesc)this.conf).getStaticSpec() != null ? ((FileSinkDesc)this.conf).getStaticSpec() : "";
        for (String fspKey : this.valToPaths.keySet()) {
            String key;
            FSPaths fspValue = this.valToPaths.get(fspKey);
            if (fspKey == "") {
                String keyPrefix = Utilities.getHashedStatsPrefix(((FileSinkDesc)this.conf).getStatsAggPrefix() + spSpec, ((FileSinkDesc)this.conf).getMaxStatsKeyPrefixLength());
                key = keyPrefix + taskID;
            } else {
                key = this.createKeyForStatsPublisher(taskID, spSpec, fspKey);
            }
            HashMap<String, String> statsToPublish = new HashMap<String, String>();
            for (String statType : fspValue.stat.getStoredStats()) {
                statsToPublish.put(statType, Long.toString(fspValue.stat.getStat(statType)));
            }
            if (statsPublisher.publishStat(key, statsToPublish) || !isStatsReliable) continue;
            throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
        }
        if (!statsPublisher.closeConnection() && isStatsReliable) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
        }
    }

    private String createKeyForStatsPublisher(String taskID, String spSpec, String fspKey) {
        String newFspKey = fspKey;
        String storedAsDirPostFix = "";
        if (this.isSkewedStoredAsSubDirectories) {
            List<String> skewedValueDirList = this.lbCtx.getSkewedValuesDirNames();
            for (String dir : skewedValueDirList) {
                if ((newFspKey = newFspKey.replace(dir, "")).equals(fspKey)) continue;
                storedAsDirPostFix = dir;
                break;
            }
        }
        String keyPrefix = Utilities.getHashedStatsPrefix(((FileSinkDesc)this.conf).getStatsAggPrefix() + spSpec + newFspKey + "/", ((FileSinkDesc)this.conf).getMaxStatsKeyPrefixLength());
        String key = keyPrefix + storedAsDirPostFix + taskID;
        return key;
    }

    public static enum TableIdEnum {
        TABLE_ID_1_ROWCOUNT,
        TABLE_ID_2_ROWCOUNT,
        TABLE_ID_3_ROWCOUNT,
        TABLE_ID_4_ROWCOUNT,
        TABLE_ID_5_ROWCOUNT,
        TABLE_ID_6_ROWCOUNT,
        TABLE_ID_7_ROWCOUNT,
        TABLE_ID_8_ROWCOUNT,
        TABLE_ID_9_ROWCOUNT,
        TABLE_ID_10_ROWCOUNT,
        TABLE_ID_11_ROWCOUNT,
        TABLE_ID_12_ROWCOUNT,
        TABLE_ID_13_ROWCOUNT,
        TABLE_ID_14_ROWCOUNT,
        TABLE_ID_15_ROWCOUNT;

    }

    public class FSPaths
    implements Cloneable {
        Path tmpPath;
        Path taskOutputTempPath;
        Path[] outPaths;
        Path[] finalPaths;
        RecordWriter[] outWriters;
        Stat stat;

        public FSPaths() {
        }

        public FSPaths(Path specPath) {
            this.tmpPath = !FileSinkOperator.this.fsSupportsMove() ? specPath : Utilities.toTempPath(specPath);
            this.taskOutputTempPath = Utilities.toTaskTempPath(specPath);
            this.outPaths = new Path[FileSinkOperator.this.numFiles];
            this.finalPaths = new Path[FileSinkOperator.this.numFiles];
            this.outWriters = new RecordWriter[FileSinkOperator.this.numFiles];
            this.stat = new Stat();
        }

        public Path getTaskOutPath(String taskId) {
            return this.getOutPath(taskId, this.taskOutputTempPath);
        }

        public Path getOutPath(String taskId) {
            return this.getOutPath(taskId, this.tmpPath);
        }

        public Path getOutPath(String taskId, Path tmp) {
            return new Path(tmp, Utilities.toTempPath(taskId));
        }

        public Path getFinalPath(String taskId) {
            return this.getFinalPath(taskId, this.tmpPath, null);
        }

        public Path getFinalPath(String taskId, Path tmpPath, String extension) {
            if (extension != null) {
                return new Path(tmpPath, taskId + extension);
            }
            return new Path(tmpPath, taskId);
        }

        public void setOutWriters(RecordWriter[] out) {
            this.outWriters = out;
        }

        public RecordWriter[] getOutWriters() {
            return this.outWriters;
        }

        public void closeWriters(boolean abort) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }

        private void commit(FileSystem fs) throws HiveException {
            for (int idx = 0; idx < this.outPaths.length; ++idx) {
                if (this.outPaths[idx].makeQualified(fs).equals((Object)this.finalPaths[idx].makeQualified(fs))) {
                    FileSinkOperator.this.LOG.info((Object)("skipping rename since src=dest:" + this.outPaths[idx] + "=" + this.finalPaths[idx]));
                    return;
                }
                try {
                    if ((FileSinkOperator.this.bDynParts || FileSinkOperator.this.isSkewedStoredAsSubDirectories) && !fs.exists(this.finalPaths[idx].getParent())) {
                        fs.mkdirs(this.finalPaths[idx].getParent());
                    }
                    if (!fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                        throw new HiveException("Unable to rename output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx]);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException("Unable to rename output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx], e);
                }
            }
        }

        private void abortWriters(FileSystem fs, boolean abort, boolean delete) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    FileSinkOperator.this.LOG.info((Object)("Aborting writer for path " + this.outPaths[idx]));
                    this.outWriters[idx].close(abort);
                    if (delete) {
                        FileSinkOperator.this.LOG.info((Object)("Deleting output path " + this.outPaths[idx]));
                        fs.delete(this.outPaths[idx], true);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }
    }

    public static interface RecordWriter {
        public void write(Writable var1) throws IOException;

        public void close(boolean var1) throws IOException;
    }
}

