/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.rcfile.merge.BlockMergeTask;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;

public class MoveTask
extends Task<MoveWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(MoveTask.class);

    private void moveFile(Path sourcePath, Path targetPath, boolean isDfsDir) throws Exception {
        FileSystem fs = sourcePath.getFileSystem((Configuration)this.conf);
        if (isDfsDir) {
            if (sourcePath.makeQualified(fs).equals((Object)targetPath.makeQualified(fs))) {
                LOG.debug((Object)("skipping copy since src=dest:" + sourcePath + "=" + targetPath));
                return;
            }
            String mesg = "Moving data to: " + targetPath.toString();
            String mesg_detail = " from " + sourcePath.toString();
            this.console.printInfo(mesg, mesg_detail);
            fs.delete(targetPath, true);
            if (fs.exists(sourcePath)) {
                Path deletePath = null;
                if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_INSERT_INTO_MULTILEVEL_DIRS)) {
                    deletePath = this.createTargetPath(targetPath, fs);
                }
                if (!fs.rename(sourcePath, targetPath)) {
                    try {
                        if (deletePath != null) {
                            fs.delete(deletePath, true);
                        }
                    }
                    catch (IOException e) {
                        LOG.info((Object)("Unable to delete the path created for facilitating rename" + deletePath));
                    }
                    throw new HiveException("Unable to rename: " + sourcePath + " to: " + targetPath);
                }
            } else if (!fs.mkdirs(targetPath)) {
                throw new HiveException("Unable to make directory: " + targetPath);
            }
        } else {
            String mesg = "Copying data to local directory " + targetPath.toString();
            String mesg_detail = " from " + sourcePath.toString();
            this.console.printInfo(mesg, mesg_detail);
            LocalFileSystem dstFs = FileSystem.getLocal((Configuration)this.conf);
            if (dstFs.delete(targetPath, true) || !dstFs.exists(targetPath)) {
                this.console.printInfo(mesg, mesg_detail);
                if (fs.exists(sourcePath)) {
                    fs.copyToLocalFile(sourcePath, targetPath);
                } else if (!dstFs.mkdirs(targetPath)) {
                    throw new HiveException("Unable to make local directory: " + targetPath);
                }
            } else {
                throw new AccessControlException("Unable to delete the existing destination directory: " + targetPath);
            }
        }
    }

    private Path createTargetPath(Path targetPath, FileSystem fs) throws IOException {
        Path deletePath = null;
        Path mkDirPath = targetPath.getParent();
        if (mkDirPath != null & !fs.exists(mkDirPath)) {
            for (Path actualPath = mkDirPath; actualPath != null && !fs.exists(actualPath); actualPath = actualPath.getParent()) {
                deletePath = actualPath;
            }
            fs.mkdirs(mkDirPath);
        }
        return deletePath;
    }

    private void releaseLocks(LoadTableDesc ltd) throws HiveException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            return;
        }
        Context ctx = this.driverContext.getCtx();
        HiveLockManager lockMgr = ctx.getHiveLockMgr();
        WriteEntity output = ctx.getLoadTableOutputMap().get(ltd);
        List<HiveLockObj> lockObjects = ctx.getOutputLockObjects().get(output);
        if (lockObjects == null) {
            return;
        }
        for (HiveLockObj lockObj : lockObjects) {
            List<HiveLock> locks = lockMgr.getLocks(lockObj.getObj(), false, true);
            for (HiveLock lock : locks) {
                if (lock.getHiveLockMode() != lockObj.getMode()) continue;
                LOG.info((Object)("about to release lock for output: " + output.toString() + " lock: " + lock.getHiveLockObject().getName()));
                lockMgr.unlock(lock);
                ctx.getHiveLocks().remove(lock);
            }
        }
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            LoadTableDesc tbd;
            LoadMultiFilesDesc lmfd;
            LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
            if (lfd != null) {
                Path targetPath = new Path(lfd.getTargetDir());
                Path sourcePath = new Path(lfd.getSourceDir());
                this.moveFile(sourcePath, targetPath, lfd.getIsDfsDir());
            }
            if ((lmfd = ((MoveWork)this.work).getLoadMultiFilesWork()) != null) {
                boolean isDfsDir = lmfd.getIsDfsDir();
                for (int i = 0; i < lmfd.getSourceDirs().size(); ++i) {
                    Path srcPath = new Path(lmfd.getSourceDirs().get(i));
                    Path destPath = new Path(lmfd.getTargetDirs().get(i));
                    FileSystem fs = destPath.getFileSystem((Configuration)this.conf);
                    if (!fs.exists(destPath.getParent())) {
                        fs.mkdirs(destPath.getParent());
                    }
                    this.moveFile(srcPath, destPath, isDfsDir);
                }
            }
            if ((tbd = ((MoveWork)this.work).getLoadTableWork()) != null) {
                StringBuilder mesg = new StringBuilder("Loading data to table ").append(tbd.getTable().getTableName());
                if (tbd.getPartitionSpec().size() > 0) {
                    mesg.append(" partition (");
                    Map<String, String> partSpec = tbd.getPartitionSpec();
                    for (String key : partSpec.keySet()) {
                        mesg.append(key).append('=').append(partSpec.get(key)).append(", ");
                    }
                    mesg.setLength(mesg.length() - 2);
                    mesg.append(')');
                }
                String mesg_detail = " from " + tbd.getSourceDir();
                this.console.printInfo(mesg.toString(), mesg_detail);
                Table table = this.db.getTable(tbd.getTable().getTableName());
                if (((MoveWork)this.work).getCheckFileFormat()) {
                    boolean flag;
                    ArrayList<FileStatus> files;
                    FileSystem fs;
                    try {
                        fs = FileSystem.get((URI)table.getDataLocation(), (Configuration)this.conf);
                        FileStatus[] dirs = fs.globStatus(new Path(tbd.getSourceDir()));
                        files = new ArrayList<FileStatus>();
                        for (int i = 0; dirs != null && i < dirs.length; ++i) {
                            files.addAll(Arrays.asList(fs.listStatus(dirs[i].getPath())));
                            if (files.size() <= 0) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw new HiveException("addFiles: filesystem error in check phase", e);
                    }
                    if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVECHECKFILEFORMAT) && !(flag = HiveFileFormatUtils.checkInputFormat(fs, this.conf, tbd.getTable().getInputFileFormatClass(), files))) {
                        throw new HiveException("Wrong file format. Please check the file's format.");
                    }
                }
                LineageInfo.DataContainer dc = null;
                if (tbd.getPartitionSpec().size() == 0) {
                    dc = new LineageInfo.DataContainer(table.getTTable());
                    this.db.loadTable(new Path(tbd.getSourceDir()), tbd.getTable().getTableName(), tbd.getReplace(), tbd.getHoldDDLTime());
                    if (((MoveWork)this.work).getOutputs() != null) {
                        ((MoveWork)this.work).getOutputs().add(new WriteEntity(table, true));
                    }
                } else {
                    DynamicPartitionCtx dpCtx;
                    LOG.info((Object)("Partition is: " + tbd.getPartitionSpec().toString()));
                    List<BucketingSortingCtx.BucketCol> bucketCols = null;
                    List<BucketingSortingCtx.SortCol> sortCols = null;
                    int numBuckets = -1;
                    Task task = this;
                    String path = tbd.getSourceDir();
                    while (task.getParentTasks() != null && task.getParentTasks().size() == 1 && !((task = task.getParentTasks().get(0)) instanceof BlockMergeTask) && !(task instanceof MapredLocalTask)) {
                        if (task instanceof MapRedTask) {
                            MapredWork work = (MapredWork)task.getWork();
                            bucketCols = work.getBucketedColsByDirectory().get(path);
                            sortCols = work.getSortedColsByDirectory().get(path);
                            numBuckets = work.getNumReduceTasks();
                            if (bucketCols != null || sortCols != null) assert (work.isFinalMapRed());
                            break;
                        }
                        if (!(task instanceof MoveTask) || ((MoveWork)((MoveTask)task).getWork()).getLoadFileWork() == null) continue;
                        path = ((MoveWork)((MoveTask)task).getWork()).getLoadFileWork().getSourceDir();
                    }
                    if ((dpCtx = tbd.getDPCtx()) != null && dpCtx.getNumDPCols() > 0) {
                        ArrayList<LinkedHashMap<String, String>> dp;
                        List<LinkedHashMap<String, String>> dps = Utilities.getFullDPSpecs(this.conf, dpCtx);
                        if (dps != null && dps.size() > 0) {
                            this.pushFeed(Task.FeedType.DYNAMIC_PARTITIONS, dps);
                        }
                        if ((dp = this.db.loadDynamicPartitions(new Path(tbd.getSourceDir()), tbd.getTable().getTableName(), tbd.getPartitionSpec(), tbd.getReplace(), dpCtx.getNumDPCols(), tbd.getHoldDDLTime(), this.isSkewedStoredAsDirs(tbd))).size() == 0 && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ERROR_ON_EMPTY_PARTITION)) {
                            throw new HiveException("This query creates no partitions. To turn off this error, set hive.error.on.empty.partition=false.");
                        }
                        for (LinkedHashMap<String, String> partSpec : dp) {
                            Partition partn = this.db.getPartition(table, partSpec, false);
                            if (bucketCols != null || sortCols != null) {
                                this.updatePartitionBucketSortColumns(table, partn, bucketCols, numBuckets, sortCols);
                            }
                            WriteEntity enty = new WriteEntity(partn, true);
                            if (((MoveWork)this.work).getOutputs() != null) {
                                ((MoveWork)this.work).getOutputs().add(enty);
                            }
                            if (this.queryPlan.getOutputs() == null) {
                                this.queryPlan.setOutputs(new HashSet<WriteEntity>());
                            }
                            this.queryPlan.getOutputs().add(enty);
                            dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
                            if (SessionState.get() != null) {
                                SessionState.get().getLineageState().setLineage(tbd.getSourceDir(), dc, table.getCols());
                            }
                            this.console.printInfo("\tLoading partition " + partSpec);
                        }
                        dc = null;
                    } else {
                        List<String> partVals = Hive.getPvals(table.getPartCols(), tbd.getPartitionSpec());
                        this.db.validatePartitionNameCharacters(partVals);
                        this.db.loadPartition(new Path(tbd.getSourceDir()), tbd.getTable().getTableName(), tbd.getPartitionSpec(), tbd.getReplace(), tbd.getHoldDDLTime(), tbd.getInheritTableSpecs(), this.isSkewedStoredAsDirs(tbd));
                        Partition partn = this.db.getPartition(table, tbd.getPartitionSpec(), false);
                        if (bucketCols != null || sortCols != null) {
                            this.updatePartitionBucketSortColumns(table, partn, bucketCols, numBuckets, sortCols);
                        }
                        dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
                        if (((MoveWork)this.work).getOutputs() != null) {
                            ((MoveWork)this.work).getOutputs().add(new WriteEntity(partn, true));
                        }
                    }
                }
                if (SessionState.get() != null && dc != null) {
                    SessionState.get().getLineageState().setLineage(tbd.getSourceDir(), dc, table.getCols());
                }
                this.releaseLocks(tbd);
            }
            return 0;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private boolean isSkewedStoredAsDirs(LoadTableDesc tbd) {
        return tbd.getLbCtx() == null ? false : tbd.getLbCtx().isSkewedStoredAsDir();
    }

    private void updatePartitionBucketSortColumns(Table table, Partition partn, List<BucketingSortingCtx.BucketCol> bucketCols, int numBuckets, List<BucketingSortingCtx.SortCol> sortCols) throws IOException, InvalidOperationException, HiveException {
        boolean updateBucketCols = false;
        if (bucketCols != null) {
            FileSystem fileSys = partn.getPartitionPath().getFileSystem((Configuration)this.conf);
            FileStatus[] fileStatus = Utilities.getFileStatusRecurse(partn.getPartitionPath(), 1, fileSys);
            if (fileStatus.length == numBuckets) {
                ArrayList<String> newBucketCols = new ArrayList<String>();
                updateBucketCols = true;
                for (BucketingSortingCtx.BucketCol bucketCol : bucketCols) {
                    if (bucketCol.getIndexes().get(0) < partn.getCols().size()) {
                        newBucketCols.add(partn.getCols().get(bucketCol.getIndexes().get(0)).getName());
                        continue;
                    }
                    updateBucketCols = false;
                    break;
                }
                if (updateBucketCols) {
                    partn.getBucketCols().clear();
                    partn.getBucketCols().addAll(newBucketCols);
                    partn.getTPartition().getSd().setNumBuckets(numBuckets);
                }
            }
        }
        boolean updateSortCols = false;
        if (sortCols != null) {
            ArrayList<Order> newSortCols = new ArrayList<Order>();
            updateSortCols = true;
            for (BucketingSortingCtx.SortCol sortCol : sortCols) {
                if (sortCol.getIndexes().get(0) < partn.getCols().size()) {
                    newSortCols.add(new Order(partn.getCols().get(sortCol.getIndexes().get(0)).getName(), sortCol.getSortOrder() == '+' ? BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_ASC : BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_DESC));
                    continue;
                }
                updateSortCols = false;
                break;
            }
            if (updateSortCols) {
                partn.getSortCols().clear();
                partn.getSortCols().addAll(newSortCols);
            }
        }
        if (updateBucketCols || updateSortCols) {
            this.db.alterPartition(table.getDbName(), table.getTableName(), partn);
        }
    }

    public boolean isLocal() {
        LoadTableDesc tbd = ((MoveWork)this.work).getLoadTableWork();
        if (tbd != null) {
            return false;
        }
        LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
        if (lfd != null) {
            return !lfd.getIsDfsDir();
        }
        return false;
    }

    @Override
    public StageType getType() {
        return StageType.MOVE;
    }

    @Override
    public String getName() {
        return "MOVE";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
    }
}

