/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class IndexPredicateAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)IndexPredicateAnalyzer.class.getName());
    private Set<String> udfNames = new HashSet<String>();
    private Set<String> allowedColumnNames;

    public void addComparisonOp(String udfName) {
        this.udfNames.add(udfName);
    }

    public void clearAllowedColumnNames() {
        this.allowedColumnNames = new HashSet<String>();
    }

    public void allowColumnName(String columnName) {
        if (this.allowedColumnNames == null) {
            this.clearAllowedColumnNames();
        }
        this.allowedColumnNames.add(columnName);
    }

    public ExprNodeDesc analyzePredicate(ExprNodeDesc predicate, final List<IndexSearchCondition> searchConditions) {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        NodeProcessor nodeProcessor = new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                Node ancestor;
                Iterator i$ = stack.iterator();
                while (i$.hasNext() && nd != (ancestor = (Node)i$.next())) {
                    if (FunctionRegistry.isOpAnd((ExprNodeDesc)ancestor)) continue;
                    return nd;
                }
                return IndexPredicateAnalyzer.this.analyzeExpr((ExprNodeDesc)nd, searchConditions, nodeOutputs);
            }
        };
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(nodeProcessor, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(predicate);
        HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        ExprNodeDesc residualPredicate = (ExprNodeDesc)nodeOutput.get(predicate);
        return residualPredicate;
    }

    private ExprNodeDesc analyzeExpr(ExprNodeDesc expr, List<IndexSearchCondition> searchConditions, Object ... nodeOutputs) {
        String udfName;
        if (!(expr instanceof ExprNodeGenericFuncDesc)) {
            return expr;
        }
        if (FunctionRegistry.isOpAnd(expr)) {
            assert (nodeOutputs.length == 2);
            ExprNodeDesc residual1 = (ExprNodeDesc)nodeOutputs[0];
            ExprNodeDesc residual2 = (ExprNodeDesc)nodeOutputs[1];
            if (residual1 == null) {
                return residual2;
            }
            if (residual2 == null) {
                return residual1;
            }
            ArrayList<ExprNodeDesc> residuals = new ArrayList<ExprNodeDesc>();
            residuals.add(residual1);
            residuals.add(residual2);
            return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), residuals);
        }
        ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)expr;
        if (funcDesc.getGenericUDF() instanceof GenericUDFBridge) {
            GenericUDFBridge func = (GenericUDFBridge)funcDesc.getGenericUDF();
            udfName = func.getUdfName();
        } else {
            udfName = funcDesc.getGenericUDF().getClass().getName();
        }
        if (!this.udfNames.contains(udfName)) {
            return expr;
        }
        ExprNodeColumnDesc columnDesc = null;
        ExprNodeConstantDesc constantDesc = null;
        if (nodeOutputs.length > 1) {
            ExprNodeDesc child1 = (ExprNodeDesc)nodeOutputs[0];
            ExprNodeDesc child2 = (ExprNodeDesc)nodeOutputs[1];
            if (child1 instanceof ExprNodeColumnDesc && child2 instanceof ExprNodeConstantDesc) {
                columnDesc = (ExprNodeColumnDesc)child1;
                constantDesc = (ExprNodeConstantDesc)child2;
            } else if (child2 instanceof ExprNodeColumnDesc && child1 instanceof ExprNodeConstantDesc) {
                columnDesc = (ExprNodeColumnDesc)child2;
                constantDesc = (ExprNodeConstantDesc)child1;
            }
        } else {
            ExprNodeDesc child1 = (ExprNodeDesc)nodeOutputs[0];
            columnDesc = (ExprNodeColumnDesc)child1;
        }
        if (columnDesc == null) {
            return expr;
        }
        if (this.allowedColumnNames != null && !this.allowedColumnNames.contains(columnDesc.getColumn())) {
            return expr;
        }
        searchConditions.add(new IndexSearchCondition(columnDesc, udfName, constantDesc, expr));
        return null;
    }

    private ExprNodeDesc extractConstant(ExprNodeDesc expr) {
        if (!(expr instanceof ExprNodeGenericFuncDesc)) {
            return expr;
        }
        ExprNodeConstantDesc folded = this.foldConstant((ExprNodeGenericFuncDesc)expr);
        return folded == null ? expr : folded;
    }

    private ExprNodeConstantDesc foldConstant(ExprNodeGenericFuncDesc func) {
        GenericUDF udf = func.getGenericUDF();
        if (!FunctionRegistry.isDeterministic(udf) || FunctionRegistry.isStateful(udf)) {
            return null;
        }
        try {
            UDF internal;
            if (udf instanceof GenericUDFBridge ? (internal = (UDF)ReflectionUtils.newInstance(((GenericUDFBridge)udf).getUdfClass(), null)).getRequiredFiles() != null || internal.getRequiredJars() != null : udf.getRequiredFiles() != null || udf.getRequiredJars() != null) {
                return null;
            }
            for (ExprNodeDesc child : func.getChildExprs()) {
                if (child instanceof ExprNodeConstantDesc || child instanceof ExprNodeGenericFuncDesc && this.foldConstant((ExprNodeGenericFuncDesc)child) != null) continue;
                return null;
            }
            ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(func);
            ObjectInspector output = evaluator.initialize(null);
            Object constant = evaluator.evaluate(null);
            Object java = ObjectInspectorUtils.copyToStandardJavaObject(constant, output);
            return new ExprNodeConstantDesc(java);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ExprNodeDesc translateSearchConditions(List<IndexSearchCondition> searchConditions) {
        ExprNodeDesc expr = null;
        for (IndexSearchCondition searchCondition : searchConditions) {
            if (expr == null) {
                expr = searchCondition.getComparisonExpr();
                continue;
            }
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(expr);
            children.add(searchCondition.getComparisonExpr());
            expr = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
        }
        return expr;
    }
}

