/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Progressable;

public class HiveBinaryOutputFormat<K extends WritableComparable, V extends Writable>
extends TextOutputFormat<K, V>
implements HiveOutputFormat<K, V> {
    static Log LOG = LogFactory.getLog(HiveBinaryOutputFormat.class);

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path outPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        FileSystem fs = outPath.getFileSystem((Configuration)jc);
        LOG.info((Object)("HiveBinaryOutputFormat progressor=" + progress));
        FSDataOutputStream outStream = fs.create(outPath, progress);
        return new FileSinkOperator.RecordWriter((OutputStream)outStream){
            final /* synthetic */ OutputStream val$outStream;
            {
                this.val$outStream = outputStream;
            }

            @Override
            public void write(Writable r) throws IOException {
                if (r instanceof Text) {
                    Text tr = (Text)r;
                    this.val$outStream.write(tr.getBytes(), 0, tr.getLength());
                } else {
                    BytesWritable bw = (BytesWritable)r;
                    this.val$outStream.write(bw.get(), 0, bw.getSize());
                }
            }

            @Override
            public void close(boolean abort) throws IOException {
                if (abort && this.val$outStream instanceof Abortable) {
                    ((Abortable)this.val$outStream).abort();
                }
                this.val$outStream.close();
            }
        };
    }
}

