/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class HiveCombineSplit
extends HiveInputFormat.HiveInputSplit {
    protected InputSplit[] inputSplits;
    protected String inputFormatClassName;

    public String getInputFormatClassName() {
        return this.inputFormatClassName;
    }

    public void setInputFormatClassName(String inputFormatClassName) {
        this.inputFormatClassName = inputFormatClassName;
    }

    public HiveCombineSplit() {
    }

    public HiveCombineSplit(InputSplit[] inputSplits, String inputFormatClassName) {
        assert (inputSplits != null && inputSplits.length > 0);
        this.inputSplits = inputSplits;
        this.inputFormatClassName = inputFormatClassName;
    }

    public int getNumSplits() {
        return this.inputSplits.length;
    }

    public InputSplit getSplit(int idx) {
        assert (idx >= 0 && idx < this.inputSplits.length);
        return this.inputSplits[idx];
    }

    @Override
    public String inputFormatClassName() {
        return this.inputFormatClassName;
    }

    @Override
    public Path getPath() {
        if (this.inputSplits != null && this.inputSplits.length > 0 && this.inputSplits[0] instanceof FileSplit) {
            return ((FileSplit)this.inputSplits[0]).getPath();
        }
        return new Path("");
    }

    @Override
    public long getStart() {
        if (this.inputSplits != null && this.inputSplits.length > 0 && this.inputSplits[0] instanceof FileSplit) {
            return ((FileSplit)this.inputSplits[0]).getStart();
        }
        return 0L;
    }

    @Override
    public String toString() {
        if (this.inputSplits != null && this.inputSplits.length > 0) {
            return this.inputFormatClassName + ":" + this.inputSplits[0].toString();
        }
        return this.inputFormatClassName + ":null";
    }

    @Override
    public long getLength() {
        long r = 0L;
        if (this.inputSplits != null) {
            try {
                for (InputSplit inputSplit : this.inputSplits) {
                    r += inputSplit.getLength();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return r;
    }

    public long getLength(int idx) {
        if (this.inputSplits != null) {
            try {
                return this.inputSplits[idx].getLength();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return -1L;
    }

    @Override
    public String[] getLocations() throws IOException {
        assert (this.inputSplits != null && this.inputSplits.length > 0);
        return this.inputSplits[0].getLocations();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String inputSplitClassName = in.readUTF();
        int numSplits = in.readInt();
        this.inputSplits = new InputSplit[numSplits];
        for (int i = 0; i < numSplits; ++i) {
            try {
                this.inputSplits[i] = (InputSplit)ReflectionUtils.newInstance((Class)this.conf.getClassByName(inputSplitClassName), (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputSplit class = " + inputSplitClassName + ":" + e.getMessage());
            }
            this.inputSplits[i].readFields(in);
        }
        this.inputFormatClassName = in.readUTF();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        assert (this.inputSplits != null && this.inputSplits.length > 0);
        out.writeUTF(this.inputSplits[0].getClass().getName());
        out.writeInt(this.inputSplits.length);
        for (InputSplit inputSplit : this.inputSplits) {
            inputSplit.write(out);
        }
        out.writeUTF(this.inputFormatClassName);
    }
}

