/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Progressable;

public class HiveIgnoreKeyTextOutputFormat<K extends WritableComparable, V extends Writable>
extends TextOutputFormat<K, V>
implements HiveOutputFormat<K, V> {
    static Log LOG = LogFactory.getLog(HiveIgnoreKeyTextOutputFormat.class);

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path outPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        char rowSeparator = '\u0000';
        String rowSeparatorString = tableProperties.getProperty("line.delim", "\n");
        try {
            rowSeparator = Byte.parseByte(rowSeparatorString);
        }
        catch (NumberFormatException e) {
            rowSeparator = rowSeparatorString.charAt(0);
        }
        LOG.info((Object)("HiveIgnoreKeyTextOutputFormat progressor=" + progress));
        final char finalRowSeparator = rowSeparator;
        FileSystem fs = outPath.getFileSystem((Configuration)jc);
        final OutputStream outStream = Utilities.createCompressedStream(jc, (OutputStream)fs.create(outPath, progress), isCompressed);
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void write(Writable r) throws IOException {
                if (r instanceof Text) {
                    Text tr = (Text)r;
                    outStream.write(tr.getBytes(), 0, tr.getLength());
                    outStream.write(finalRowSeparator);
                } else {
                    BytesWritable bw = (BytesWritable)r;
                    outStream.write(bw.get(), 0, bw.getSize());
                    outStream.write(finalRowSeparator);
                }
            }

            @Override
            public void close(boolean abort) throws IOException {
                if (abort && outStream instanceof Abortable) {
                    ((Abortable)outStream).abort();
                }
                outStream.close();
            }
        };
    }

    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        return new IgnoreKeyWriter(super.getRecordWriter(ignored, job, name, progress));
    }

    protected static class IgnoreKeyWriter<K extends WritableComparable, V extends Writable>
    implements RecordWriter<K, V> {
        private final RecordWriter<K, V> mWriter;

        public IgnoreKeyWriter(RecordWriter<K, V> writer) {
            this.mWriter = writer;
        }

        public synchronized void write(K key, V value) throws IOException {
            this.mWriter.write(null, value);
        }

        public void close(Reporter reporter) throws IOException {
            this.mWriter.close(reporter);
        }
    }
}

