/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.merge;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeOutputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileKeyBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileValueBufferWrapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class RCFileMergeMapper
extends MapReduceBase
implements Mapper<Object, RCFileValueBufferWrapper, Object, Object> {
    private JobConf jc;
    Class<? extends Writable> outputClass;
    RCFile.Writer outWriter;
    Path finalPath;
    FileSystem fs;
    boolean exception = false;
    boolean autoDelete = false;
    Path outPath;
    CompressionCodec codec = null;
    int columnNumber = 0;
    boolean hasDynamicPartitions = false;
    boolean isListBucketingDML = false;
    boolean isListBucketingAlterTableConcatenate = false;
    int listBucketingDepth;
    boolean tmpPathFixedConcatenate = false;
    private boolean shouldDeleteS3Path = false;
    private static String queryId = null;
    boolean tmpPathFixed = false;
    Path tmpPath;
    Path taskTmpPath;
    Path dpPath;
    private String specPath = null;
    private static final Pattern pat = Pattern.compile("([^/]+)=([^/]+).*");
    public static final Log LOG = LogFactory.getLog((String)"RCFileMergeMapper");
    public static String BACKUP_PREFIX = "_backup.";

    public void configure(JobConf job) {
        this.jc = job;
        this.hasDynamicPartitions = HiveConf.getBoolVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBHASDYNAMICPARTITIONS);
        this.isListBucketingAlterTableConcatenate = HiveConf.getBoolVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBCONCATENATELISTBUCKETING);
        this.listBucketingDepth = HiveConf.getIntVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBCONCATENATELISTBUCKETINGDEPTH);
        this.shouldDeleteS3Path = HiveConf.getBoolVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBDELETES3PATH);
        queryId = HiveConf.getVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBQUERYID);
        this.specPath = RCFileBlockMergeOutputFormat.getMergeOutputPath(job).toString();
        Path tmpPath = Utilities.toTempPath(this.specPath);
        tmpPath = !Utilities.isS3Path(new Path(this.specPath)) ? Utilities.toTempPath(this.specPath) : new Path(this.specPath);
        Path taskTmpPath = Utilities.toTaskTempPath(this.specPath);
        this.updatePaths(tmpPath, taskTmpPath);
        try {
            this.fs = new Path(this.specPath).getFileSystem((Configuration)job);
            this.autoDelete = ShimLoader.getHadoopShims().fileSystemDeleteOnExit(this.fs, this.outPath);
        }
        catch (IOException e) {
            this.exception = true;
            throw new RuntimeException(e);
        }
    }

    private void updatePaths(Path tmpPath, Path taskTmpPath) {
        String taskId = Utilities.getTaskId((Configuration)this.jc);
        this.tmpPath = tmpPath;
        this.taskTmpPath = taskTmpPath;
        if (!Utilities.isS3Path(tmpPath)) {
            this.finalPath = new Path(tmpPath, taskId);
            this.outPath = new Path(taskTmpPath, Utilities.toTempPath(taskId));
        } else {
            this.outPath = this.finalPath = new Path(tmpPath, Utilities.getS3FileName(taskId, queryId));
        }
    }

    public void map(Object k, RCFileValueBufferWrapper value, OutputCollector<Object, Object> output, Reporter reporter) throws IOException {
        try {
            boolean sameCodec;
            RCFileKeyBufferWrapper key = null;
            key = k instanceof CombineHiveKey ? (RCFileKeyBufferWrapper)((CombineHiveKey)k).getKey() : (RCFileKeyBufferWrapper)k;
            if (this.isListBucketingAlterTableConcatenate) {
                if (this.tmpPathFixedConcatenate) {
                    this.checkPartitionsMatch(key.inputPath.getParent());
                } else {
                    this.fixTmpPathConcatenate(key.inputPath.getParent());
                    this.tmpPathFixedConcatenate = true;
                }
            } else if (this.hasDynamicPartitions || this.listBucketingDepth > 0) {
                if (this.tmpPathFixed) {
                    this.checkPartitionsMatch(key.inputPath.getParent());
                } else {
                    this.fixTmpPath(key.inputPath.getParent());
                    this.tmpPathFixed = true;
                }
            }
            if (Utilities.isS3Path(this.tmpPath) && this.shouldDeleteS3Path) {
                Utilities.cleanS3DynDirectory(this.tmpPath, this.fs, queryId);
            }
            if (this.outWriter == null) {
                this.codec = key.codec;
                this.columnNumber = key.keyBuffer.getColumnNumber();
                this.jc.setInt("hive.io.rcfile.column.number.conf", this.columnNumber);
                this.outWriter = new RCFile.Writer(this.fs, (Configuration)this.jc, this.outPath, null, this.codec);
            }
            boolean bl = sameCodec = this.codec == key.codec || this.codec.getClass().equals(key.codec.getClass());
            if (key.keyBuffer.getColumnNumber() != this.columnNumber || !sameCodec) {
                throw new IOException("RCFileMerge failed because the input files use different CompressionCodec or have different column number setting.");
            }
            this.outWriter.flushBlock(key.keyBuffer, value.valueBuffer, key.recordLength, key.keyLength, key.compressedKeyLength);
        }
        catch (Throwable e) {
            this.exception = true;
            this.close();
            throw new IOException(e);
        }
    }

    private void checkPartitionsMatch(Path inputPath) throws HiveException {
        if (!this.dpPath.equals((Object)inputPath)) {
            String msg = "Multiple partitions for one block merge mapper: " + this.dpPath + " NOT EQUAL TO " + inputPath;
            LOG.error((Object)msg);
            throw new HiveException(msg);
        }
    }

    private String getDynPartDir(Path path) {
        String match = "";
        Matcher matcher = pat.matcher(path.toString());
        if (matcher.find()) {
            match = matcher.group();
        }
        return match;
    }

    private void fixTmpPath(Path inputPath) throws HiveException, IOException {
        this.dpPath = inputPath;
        Path newPath = null;
        if (Utilities.isS3Path(this.tmpPath)) {
            String dynPartPath = this.getDynPartDir(this.dpPath);
            newPath = new Path(dynPartPath);
        } else {
            newPath = new Path(".");
            int inputDepth = inputPath.depth();
            int tmpDepth = this.tmpPath.depth();
            while (inputPath != null && inputPath.depth() > tmpDepth) {
                newPath = new Path(inputPath.getName(), newPath);
                --inputDepth;
                inputPath = inputPath.getParent();
            }
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        Path newTaskTmpPath = new Path(this.taskTmpPath, newPath);
        if (!Utilities.isS3Path(this.tmpPath) && !this.fs.exists(newTmpPath)) {
            this.fs.mkdirs(newTmpPath);
        }
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    private void fixTmpPathConcatenate(Path inputPath) throws HiveException, IOException {
        this.dpPath = inputPath;
        Path newPath = new Path(".");
        for (int depth = this.listBucketingDepth; inputPath != null && depth > 0; inputPath = inputPath.getParent(), --depth) {
            newPath = new Path(inputPath.getName(), newPath);
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        Path newTaskTmpPath = new Path(this.taskTmpPath, newPath);
        if (!this.fs.exists(newTmpPath)) {
            this.fs.mkdirs(newTmpPath);
        }
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    public void close() throws IOException {
        Path specpath;
        if (this.outWriter == null) {
            return;
        }
        this.outWriter.close();
        this.outWriter = null;
        if (!this.exception && !Utilities.isS3Path(this.tmpPath)) {
            FileStatus fss = this.fs.getFileStatus(this.outPath);
            LOG.info((Object)("renamed path " + this.outPath + " to " + this.finalPath + " . File size is " + fss.getLen()));
            if (!this.fs.rename(this.outPath, this.finalPath)) {
                throw new IOException("Unable to rename output to " + this.finalPath);
            }
        } else if (!this.autoDelete && !Utilities.isS3Path(this.tmpPath)) {
            this.fs.delete(this.outPath, true);
        }
        if (Utilities.isS3Path(specpath = new Path(this.specPath))) {
            Utilities.delTmpFileAtSpecPathS3(this.fs, specpath.getName(), specpath.getParent());
        }
    }

    public static Path backupOutputPath(FileSystem fs, Path outpath, JobConf job) throws IOException, HiveException {
        if (fs.exists(outpath)) {
            Path backupPath = new Path(outpath.getParent(), BACKUP_PREFIX + outpath.getName());
            Utilities.rename(fs, outpath, backupPath);
            return backupPath;
        }
        return null;
    }

    public static void jobClose(String outputPath, boolean success, JobConf job, SessionState.LogHelper console, DynamicPartitionCtx dynPartCtx, Reporter reporter) throws HiveException, IOException {
        Path outpath = new Path(outputPath);
        if (!Utilities.isS3Path(outpath)) {
            FileSystem fs = outpath.getFileSystem((Configuration)job);
            Path backupPath = RCFileMergeMapper.backupOutputPath(fs, outpath, job);
            Utilities.mvFileToFinalPath(outputPath, (Configuration)job, success, LOG, dynPartCtx, null, (Progressable)reporter);
            fs.delete(backupPath, true);
        }
    }
}

