/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr.zookeeper;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLock;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperHiveLockManager
implements HiveLockManager {
    HiveLockManagerCtx ctx;
    public static final Log LOG = LogFactory.getLog((String)"ZooKeeperHiveLockManager");
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private ZooKeeper zooKeeper;
    private String parent;
    private int sessionTimeout;
    private String quorumServers;
    private int sleepTime;
    private int numRetriesForLock;
    private int numRetriesForUnLock;
    private static String clientIp = "UNKNOWN";
    private static Pattern shMode;
    private static Pattern exMode;

    private static String getQuorumServers(HiveConf conf) {
        String hosts = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM);
        String port = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT);
        return hosts + ":" + port;
    }

    @Override
    public void setContext(HiveLockManagerCtx ctx) throws LockException {
        this.ctx = ctx;
        HiveConf conf = ctx.getConf();
        this.sessionTimeout = conf.getIntVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT);
        this.quorumServers = ZooKeeperHiveLockManager.getQuorumServers(conf);
        this.sleepTime = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES) * 1000;
        this.numRetriesForLock = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES);
        this.numRetriesForUnLock = conf.getIntVar(HiveConf.ConfVars.HIVE_UNLOCK_NUMRETRIES);
        try {
            this.renewZookeeperInstance(this.sessionTimeout, this.quorumServers);
            this.parent = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_NAMESPACE);
            try {
                this.zooKeeper.create("/" + this.parent, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NODEEXISTS) {
                    LOG.warn((Object)("Unexpected ZK exception when creating parent node /" + this.parent), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create ZooKeeper object: ", (Throwable)e);
            throw new LockException(ErrorMsg.ZOOKEEPER_CLIENT_COULD_NOT_BE_INITIALIZED.getMsg());
        }
    }

    @Override
    public void refresh() {
        HiveConf conf = this.ctx.getConf();
        this.sleepTime = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES) * 1000;
        this.numRetriesForLock = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES);
        this.numRetriesForUnLock = conf.getIntVar(HiveConf.ConfVars.HIVE_UNLOCK_NUMRETRIES);
    }

    private void renewZookeeperInstance(int sessionTimeout, String quorumServers) throws InterruptedException, IOException {
        if (this.zooKeeper != null) {
            return;
        }
        this.zooKeeper = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)new DummyWatcher());
    }

    private static String getLastObjectName(String parent, HiveLockObject key) {
        return "/" + parent + "/" + key.getName();
    }

    private List<String> getObjectNames(HiveLockObject key) {
        String[] names;
        ArrayList<String> parents = new ArrayList<String>();
        String curParent = "/" + this.parent + "/";
        for (String name : names = key.getName().split("/")) {
            curParent = curParent + name;
            parents.add(curParent);
            curParent = curParent + "/";
        }
        return parents;
    }

    @Override
    public List<HiveLock> lock(List<HiveLockObj> lockObjects, boolean keepAlive) throws LockException {
        Collections.sort(lockObjects, new Comparator<HiveLockObj>(){

            @Override
            public int compare(HiveLockObj o1, HiveLockObj o2) {
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp == 0) {
                    if (o1.getMode() == o2.getMode()) {
                        return cmp;
                    }
                    if (o1.getMode() == HiveLockMode.EXCLUSIVE) {
                        return -1;
                    }
                    return 1;
                }
                return cmp;
            }
        });
        HiveLockObj prevLockObj = null;
        ArrayList<HiveLock> hiveLocks = new ArrayList<HiveLock>();
        for (HiveLockObj lockObject : lockObjects) {
            if (prevLockObj != null && prevLockObj.getName().equals(lockObject.getName())) {
                prevLockObj = lockObject;
                continue;
            }
            ZooKeeperHiveLock lock = null;
            try {
                lock = this.lock(lockObject.getObj(), lockObject.getMode(), keepAlive, true);
            }
            catch (LockException e) {
                console.printError("Error in acquireLocks...");
                LOG.error((Object)"Error in acquireLocks...", (Throwable)e);
                lock = null;
            }
            if (lock == null) {
                this.releaseLocks(hiveLocks);
                return null;
            }
            hiveLocks.add(lock);
            prevLockObj = lockObject;
        }
        return hiveLocks;
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) {
        if (hiveLocks != null) {
            int len = hiveLocks.size();
            for (int pos = len - 1; pos >= 0; --pos) {
                HiveLock hiveLock = hiveLocks.get(pos);
                try {
                    LOG.info((Object)(" about to release lock for " + hiveLock.getHiveLockObject().getName()));
                    this.unlock(hiveLock);
                    continue;
                }
                catch (LockException e) {
                    LOG.warn((Object)"Error when releasing lock", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ZooKeeperHiveLock lock(HiveLockObject key, HiveLockMode mode, boolean keepAlive) throws LockException {
        return this.lock(key, mode, keepAlive, false);
    }

    private String createChild(String name, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this.zooKeeper.create(name, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    private String getLockName(String parent, HiveLockMode mode) {
        return parent + "/" + "LOCK-" + (Object)((Object)mode) + "-";
    }

    private ZooKeeperHiveLock lock(HiveLockObject key, HiveLockMode mode, boolean keepAlive, boolean parentCreated) throws LockException {
        int tryNum = 1;
        ZooKeeperHiveLock ret = null;
        do {
            try {
                if (tryNum > 1) {
                    Thread.sleep(this.sleepTime);
                    if (this.zooKeeper.getState() == ZooKeeper.States.CLOSED) {
                        this.zooKeeper = null;
                    }
                    this.prepareRetry();
                }
                if ((ret = this.lockPrimitive(key, mode, keepAlive, parentCreated)) != null) break;
                ++tryNum;
            }
            catch (Exception e1) {
                ++tryNum;
                if (e1 instanceof KeeperException) {
                    KeeperException e = (KeeperException)((Object)e1);
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: {
                            LOG.warn((Object)"Possibly transient ZooKeeper exception: ", (Throwable)e);
                            break;
                        }
                        default: {
                            LOG.error((Object)"Serious Zookeeper exception: ", (Throwable)e);
                        }
                    }
                }
                if (tryNum < this.numRetriesForLock) continue;
                throw new LockException(e1);
            }
        } while (tryNum < this.numRetriesForLock);
        return ret;
    }

    private ZooKeeperHiveLock lockPrimitive(HiveLockObject key, HiveLockMode mode, boolean keepAlive, boolean parentCreated) throws KeeperException, InterruptedException {
        String res;
        String lastName;
        List<Object> names = new ArrayList();
        HiveLockObject.HiveLockObjectData lockData = key.getData();
        lockData.setClientIp(clientIp);
        if (parentCreated) {
            lastName = ZooKeeperHiveLockManager.getLastObjectName(this.parent, key);
            names.add(lastName);
        } else {
            names = this.getObjectNames(key);
            lastName = (String)names.get(names.size() - 1);
        }
        for (String string : names) {
            try {
                res = this.createChild(string, new byte[0], CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) continue;
                throw e;
            }
        }
        res = this.createChild(this.getLockName(lastName, mode), key.getData().toString().getBytes(), keepAlive ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.EPHEMERAL_SEQUENTIAL);
        int seqNo = this.getSequenceNumber(res, this.getLockName(lastName, mode));
        if (seqNo == -1) {
            this.zooKeeper.delete(res, -1);
            return null;
        }
        List list = this.zooKeeper.getChildren(lastName, false);
        String exLock = this.getLockName(lastName, HiveLockMode.EXCLUSIVE);
        String shLock = this.getLockName(lastName, HiveLockMode.SHARED);
        for (String child : list) {
            child = lastName + "/" + child;
            int childSeq = seqNo;
            if (child.startsWith(exLock)) {
                childSeq = this.getSequenceNumber(child, exLock);
            }
            if (mode == HiveLockMode.EXCLUSIVE && child.startsWith(shLock)) {
                childSeq = this.getSequenceNumber(child, shLock);
            }
            if (childSeq < 0 || childSeq >= seqNo) continue;
            this.zooKeeper.delete(res, -1);
            console.printError("conflicting lock present for " + key.getDisplayName() + " mode " + (Object)((Object)mode));
            return null;
        }
        return new ZooKeeperHiveLock(res, key, mode);
    }

    @Override
    public void unlock(HiveLock hiveLock) throws LockException {
        this.unlockWithRetry(this.ctx.getConf(), this.zooKeeper, hiveLock, this.parent);
    }

    private void unlockWithRetry(HiveConf conf, ZooKeeper zkpClient, HiveLock hiveLock, String parent) throws LockException {
        int tryNum = 0;
        while (true) {
            try {
                if (++tryNum > 1) {
                    Thread.sleep(this.sleepTime);
                    this.prepareRetry();
                }
                ZooKeeperHiveLockManager.unlockPrimitive(conf, zkpClient, hiveLock, parent);
            }
            catch (Exception e) {
                if (tryNum < this.numRetriesForUnLock) continue;
                throw new LockException(e);
                if (tryNum < this.numRetriesForUnLock) continue;
            }
            break;
        }
    }

    private static void unlockPrimitive(HiveConf conf, ZooKeeper zkpClient, HiveLock hiveLock, String parent) throws LockException {
        ZooKeeperHiveLock zLock = (ZooKeeperHiveLock)hiveLock;
        try {
            zkpClient.delete(zLock.getPath(), -1);
            HiveLockObject obj = zLock.getHiveLockObject();
            String name = ZooKeeperHiveLockManager.getLastObjectName(parent, obj);
            List children = zkpClient.getChildren(name, false);
            if (children == null || children.isEmpty()) {
                zkpClient.delete(name, -1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to release ZooKeeper lock: ", (Throwable)e);
            throw new LockException(e);
        }
    }

    public static void releaseAllLocks(HiveConf conf) throws Exception {
        ZooKeeper zkpClient = null;
        try {
            int sessionTimeout = conf.getIntVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT);
            String quorumServers = ZooKeeperHiveLockManager.getQuorumServers(conf);
            DummyWatcher dummWatcher = new DummyWatcher();
            zkpClient = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)dummWatcher);
            String parent = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_NAMESPACE);
            List<HiveLock> locks = ZooKeeperHiveLockManager.getLocks(conf, zkpClient, null, parent, false, false);
            Exception lastExceptionGot = null;
            if (locks != null) {
                for (HiveLock lock : locks) {
                    try {
                        ZooKeeperHiveLockManager.unlockPrimitive(conf, zkpClient, lock, parent);
                    }
                    catch (Exception e) {
                        lastExceptionGot = e;
                    }
                }
            }
            if (lastExceptionGot != null) {
                throw lastExceptionGot;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to release all locks: ", (Throwable)e);
            throw new Exception(ErrorMsg.ZOOKEEPER_CLIENT_COULD_NOT_BE_INITIALIZED.getMsg());
        }
        finally {
            if (zkpClient != null) {
                zkpClient.close();
                zkpClient = null;
            }
        }
    }

    @Override
    public List<HiveLock> getLocks(boolean verifyTablePartition, boolean fetchData) throws LockException {
        return ZooKeeperHiveLockManager.getLocks(this.ctx.getConf(), this.zooKeeper, null, this.parent, verifyTablePartition, fetchData);
    }

    @Override
    public List<HiveLock> getLocks(HiveLockObject key, boolean verifyTablePartitions, boolean fetchData) throws LockException {
        return ZooKeeperHiveLockManager.getLocks(this.ctx.getConf(), this.zooKeeper, key, this.parent, verifyTablePartitions, fetchData);
    }

    private static List<HiveLock> getLocks(HiveConf conf, ZooKeeper zkpClient, HiveLockObject key, String parent, boolean verifyTablePartition, boolean fetchData) throws LockException {
        List children;
        String commonParent;
        ArrayList<HiveLock> locks = new ArrayList<HiveLock>();
        boolean recurse = true;
        try {
            if (key != null) {
                commonParent = "/" + parent + "/" + key.getName();
                children = zkpClient.getChildren(commonParent, false);
                recurse = false;
            } else {
                commonParent = "/" + parent;
                children = zkpClient.getChildren(commonParent, false);
            }
        }
        catch (Exception e) {
            return locks;
        }
        LinkedList<String> childn = new LinkedList<String>();
        if (children != null && !children.isEmpty()) {
            for (String child : children) {
                childn.add(commonParent + "/" + child);
            }
        }
        String curChild;
        while ((curChild = (String)childn.poll()) != null) {
            HiveLockObject.HiveLockObjectData data;
            HiveLockObject obj;
            HiveLockMode mode;
            if (recurse) {
                try {
                    children = zkpClient.getChildren(curChild, false);
                    for (String child : children) {
                        childn.add(curChild + "/" + child);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((mode = ZooKeeperHiveLockManager.getLockMode(conf, curChild)) == null || (obj = ZooKeeperHiveLockManager.getLockObject(conf, curChild, mode, data = null, parent, verifyTablePartition)) == null || key != null && !obj.getName().equals(key.getName())) continue;
            if (fetchData) {
                try {
                    data = new HiveLockObject.HiveLockObjectData(new String(zkpClient.getData(curChild, (Watcher)new DummyWatcher(), null)));
                    data.setClientIp(clientIp);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error in getting data for " + curChild), (Throwable)e);
                }
            }
            obj.setData(data);
            ZooKeeperHiveLock lck = new ZooKeeperHiveLock(curChild, obj, mode);
            locks.add(lck);
        }
        return locks;
    }

    private void removeAllRedundantNodes() {
        try {
            this.renewZookeeperInstance(this.sessionTimeout, this.quorumServers);
            this.checkRedundantNode("/" + this.parent);
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
                this.zooKeeper = null;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while removing all redundant nodes", (Throwable)e);
        }
    }

    private void checkRedundantNode(String node) {
        try {
            if (ZooKeeperHiveLockManager.getLockMode(this.ctx.getConf(), node) != null) {
                return;
            }
            List children = this.zooKeeper.getChildren(node, false);
            for (String child : children) {
                this.checkRedundantNode(node + "/" + child);
            }
            children = this.zooKeeper.getChildren(node, false);
            if (children == null || children.isEmpty()) {
                this.zooKeeper.delete(node, -1);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error in checkRedundantNode for node " + node), (Throwable)e);
        }
    }

    @Override
    public void close() throws LockException {
        try {
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
                this.zooKeeper = null;
            }
            if (HiveConf.getBoolVar(this.ctx.getConf(), HiveConf.ConfVars.HIVE_ZOOKEEPER_CLEAN_EXTRA_NODES)) {
                this.removeAllRedundantNodes();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to close zooKeeper client: " + e));
            throw new LockException(e);
        }
    }

    private int getSequenceNumber(String resPath, String path) {
        String tst = resPath.substring(path.length());
        try {
            return new Integer(tst);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static HiveLockObject getLockObject(HiveConf conf, String path, HiveLockMode mode, HiveLockObject.HiveLockObjectData data, String parent, boolean verifyTablePartition) throws LockException {
        try {
            Partition partn;
            Hive db = Hive.get(conf);
            int indx = path.lastIndexOf("LOCK-" + mode.toString());
            String objName = path.substring(("/" + parent + "/").length(), indx - 1);
            String[] names = objName.split("/");
            if (names.length < 2) {
                return null;
            }
            if (!verifyTablePartition) {
                return new HiveLockObject(names, data);
            }
            Table tab = db.getTable(names[0], names[1], false);
            if (tab == null) {
                return null;
            }
            if (names.length == 2) {
                return new HiveLockObject(tab, data);
            }
            HashMap<String, String> partSpec = new HashMap<String, String>();
            for (indx = 2; indx < names.length; ++indx) {
                String[] partVals = names[indx].split("=");
                partSpec.put(partVals[0], partVals[1]);
            }
            try {
                partn = db.getPartition(tab, partSpec, false);
            }
            catch (HiveException e) {
                partn = null;
            }
            if (partn == null) {
                return new HiveLockObject(new DummyPartition(tab, path, partSpec), data);
            }
            return new HiveLockObject(partn, data);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to create ZooKeeper object: " + e));
            throw new LockException(e);
        }
    }

    private static HiveLockMode getLockMode(HiveConf conf, String path) {
        Matcher shMatcher = shMode.matcher(path);
        Matcher exMatcher = exMode.matcher(path);
        if (shMatcher.matches()) {
            return HiveLockMode.SHARED;
        }
        if (exMatcher.matches()) {
            return HiveLockMode.EXCLUSIVE;
        }
        return null;
    }

    @Override
    public void prepareRetry() throws LockException {
        try {
            this.renewZookeeperInstance(this.sessionTimeout, this.quorumServers);
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    static {
        try {
            InetAddress clientAddr = InetAddress.getLocalHost();
            clientIp = clientAddr.getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        shMode = Pattern.compile("^.*-(SHARED)-([0-9]+)$");
        exMode = Pattern.compile("^.*-(EXCLUSIVE)-([0-9]+)$");
    }

    public static class DummyWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
        }
    }
}

