/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3.S3FileSystem;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.RecoverPartitionDesc;

public class PartitionRecoverer {
    public static final Log LOG = LogFactory.getLog(PartitionRecoverer.class);
    static final String pathDelimiter = "/";

    public int execute(Hive db, RecoverPartitionDesc desc, HiveConf conf) throws HiveException {
        Table table = db.getTable(desc.getDbName(), desc.getTableName());
        URI location = table.getDataLocation();
        FileSystem fs = this.getFileSystem(location, conf);
        if (fs instanceof NativeS3FileSystem || fs instanceof S3FileSystem) {
            LOG.info((Object)"Using s3 library to directly access the partition information");
            PartitionRecoverer.findS3Partitions(table.getPartCols(), new Path(location.toString()), fs, conf, db, table);
        } else {
            PartitionRecoverer.findPartitions(table.getPartCols(), 0, new Path(location.toString()), fs, new LinkedHashMap<String, String>(), db, table);
        }
        return 0;
    }

    private static void addPartitionIfNotExists(Hive db, Table table, Map<String, String> partitionSequence, boolean isS3Fs) throws HiveException {
        if (db.getPartition(table, partitionSequence, false) == null) {
            if (isS3Fs) {
                db.createPartition(table, partitionSequence, true);
            } else {
                db.createPartition(table, partitionSequence);
            }
        }
    }

    private FileSystem getFileSystem(URI location, HiveConf conf) throws HiveException {
        try {
            return FileSystem.get((URI)location, (Configuration)conf);
        }
        catch (IOException e) {
            throw new HiveException("IOException raised while scanning directories", e);
        }
    }

    private static Path getPartitionLocation(List<KeyValue> partitionSequence, URI location) {
        return null;
    }

    private static Map<String, String> getPartitionSpec(List<KeyValue> partitionSequence) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (KeyValue keyValue : partitionSequence) {
            result.put(keyValue.key, keyValue.value);
        }
        return result;
    }

    public static String join(LinkedHashMap<String, String> partitionSequence) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> keyValue : partitionSequence.entrySet()) {
            if (!first) {
                buffer.append(pathDelimiter);
            } else {
                first = false;
            }
            buffer.append(keyValue.getKey() + "=" + keyValue.getValue());
        }
        return buffer.toString();
    }

    private static void findPartitions(List<FieldSchema> partitionColumns, int partitionNameIndex, Path path, FileSystem fs, LinkedHashMap<String, String> partitionValues, Hive db, Table table) throws HiveException {
        try {
            if (partitionColumns.size() == 0) {
                return;
            }
            if (partitionNameIndex == partitionColumns.size()) {
                LinkedHashMap<String, String> partitionValuesClone = new LinkedHashMap<String, String>();
                partitionValuesClone.putAll(partitionValues);
                PartitionRecoverer.addPartitionIfNotExists(db, table, partitionValuesClone, false);
            } else {
                FieldSchema partitionColumn = partitionColumns.get(partitionNameIndex);
                String partitionName = partitionColumn.getName();
                for (FileStatus fileStatus : fs.listStatus(path)) {
                    String fileName = fileStatus.getPath().getName();
                    if (!fileStatus.isDir() || !fileName.startsWith(partitionName + "=")) continue;
                    partitionValues.put(partitionName, fileName.substring(partitionName.length() + 1));
                    PartitionRecoverer.findPartitions(partitionColumns, partitionNameIndex + 1, fileStatus.getPath(), fs, partitionValues, db, table);
                    partitionValues.remove(partitionValues.size() - 1);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException("IOException while scanning directories for partitions", e);
        }
    }

    private static void findS3Partitions(List<FieldSchema> partitionColumns, Path path, FileSystem fs, HiveConf conf, Hive db, Table table) throws HiveException {
        AmazonS3Client s3Client = Utilities.getS3Client(fs.getUri(), conf);
        String bucketName = fs.getUri().getHost();
        LOG.info((Object)("The S3 bucket to read from is: " + bucketName));
        String s3path = path.toString();
        int bucketNameIndex = s3path.indexOf(bucketName);
        if (bucketNameIndex == -1) {
            throw new HiveException("The given path " + path.toString() + " does not contain the bucket name " + bucketName);
        }
        String pathRoot = s3path.substring(bucketNameIndex + bucketName.length());
        if (pathRoot.startsWith(pathDelimiter)) {
            pathRoot = pathRoot.substring(pathDelimiter.length());
        }
        LOG.info((Object)("The root path is: " + pathRoot));
        String partitionPattern = pathRoot;
        for (FieldSchema partitionColumn : partitionColumns) {
            String partitionName = partitionColumn.getName();
            if (partitionPattern != null && !partitionPattern.isEmpty()) {
                partitionPattern = partitionPattern + pathDelimiter + partitionName + "=([^" + pathDelimiter + "]*)";
                continue;
            }
            partitionPattern = partitionPattern + partitionName + "=([^" + pathDelimiter + "]*)";
        }
        Pattern p = Pattern.compile(partitionPattern, 2);
        LOG.debug((Object)("The file search pattern is:" + partitionPattern));
        String lastPartition = new String("");
        String s3FolderConstant = "_$folder$";
        try {
            ObjectListing listing;
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(pathRoot);
            do {
                listing = s3Client.listObjects(listObjectsRequest);
                for (S3ObjectSummary s3Obj : listing.getObjectSummaries()) {
                    Matcher matcher;
                    String currKey = s3Obj.getKey();
                    if (currKey.endsWith(s3FolderConstant)) {
                        currKey = currKey.substring(0, currKey.length() - s3FolderConstant.length());
                    }
                    if (!(matcher = p.matcher(currKey)).find()) continue;
                    LinkedHashMap<String, String> partitionValues = new LinkedHashMap<String, String>();
                    String currentPartition = new String();
                    int i = 1;
                    for (FieldSchema partitionColumn : partitionColumns) {
                        partitionValues.put(partitionColumn.getName(), matcher.group(i));
                        currentPartition = currentPartition + matcher.group(i);
                        ++i;
                    }
                    if (currentPartition.equals(lastPartition)) continue;
                    PartitionRecoverer.addPartitionIfNotExists(db, table, partitionValues, true);
                    lastPartition = currentPartition;
                }
                listObjectsRequest.setMarker(listing.getNextMarker());
            } while (listing.isTruncated());
        }
        catch (AmazonServiceException e) {
            throw new HiveException(e);
        }
    }

    public static class KeyValue {
        public String key;
        public String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

