/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.MergeWork;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverMergeFiles;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class GenMRFileSink1
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)GenMRFileSink1.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        FileSinkDesc fileSinkDesc;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        boolean chDir = false;
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        FileSinkOperator fsOp = (FileSinkOperator)nd;
        boolean isInsertTable = ((FileSinkDesc)fsOp.getConf()).getTableInfo().getTableName() != null && parseCtx.getQB().getParseInfo().isInsertToTable();
        HiveConf hconf = parseCtx.getConf();
        ((MapredWork)currTask.getWork()).setFinalMapRed(true);
        Map<FileSinkDesc, Task<? extends Serializable>> fileSinkDescs = ctx.getLinkedFileDescTasks();
        if (fileSinkDescs != null) {
            Task<? extends Serializable> childTask = fileSinkDescs.get(fsOp.getConf());
            this.processLinkedFileDesc(ctx, childTask);
            return null;
        }
        if (ctx.getMvTask() != null && !ctx.getMvTask().isEmpty()) {
            List<Task<MoveWork>> mvTasks = ctx.getMvTask();
            if (ctx.getSeenFileSinkOps() == null || !ctx.getSeenFileSinkOps().contains(nd)) {
                MoveTask mvTask = (MoveTask)this.findMoveTask(mvTasks, fsOp);
                if (isInsertTable && hconf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                    this.addStatsTask(fsOp, mvTask, currTask, parseCtx.getConf());
                }
                if (mvTask != null && !mvTask.isLocal() && ((FileSinkDesc)fsOp.getConf()).canBeMerged()) {
                    if (((FileSinkDesc)fsOp.getConf()).isLinkedFileSink()) {
                        if (hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) || hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES)) {
                            chDir = true;
                        }
                    } else {
                        boolean mergeMapRed;
                        MapredWork currWork = (MapredWork)currTask.getWork();
                        boolean mergeMapOnly = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) && currWork.getReducer() == null;
                        boolean bl = mergeMapRed = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES) && currWork.getReducer() != null;
                        if (mergeMapOnly || mergeMapRed) {
                            chDir = true;
                        }
                    }
                }
            }
        }
        String finalName = this.processFS(fsOp, stack, opProcCtx, chDir);
        if (chDir) {
            LOG.info((Object)"using CombineHiveInputformat for the merge job");
            this.createMRWorkForMergingFiles(fsOp, ctx, finalName);
        }
        if ((fileSinkDesc = (FileSinkDesc)fsOp.getConf()).isLinkedFileSink()) {
            Map<FileSinkDesc, Task<? extends Serializable>> linkedFileDescTasks = ctx.getLinkedFileDescTasks();
            if (linkedFileDescTasks == null) {
                linkedFileDescTasks = new HashMap<FileSinkDesc, Task<? extends Serializable>>();
                ctx.setLinkedFileDescTasks(linkedFileDescTasks);
            }
            if (currTask.getChildTasks() != null && currTask.getChildTasks().size() == 1) {
                for (FileSinkDesc fileDesc : fileSinkDesc.getLinkedFileSinkDesc()) {
                    linkedFileDescTasks.put(fileDesc, currTask.getChildTasks().get(0));
                }
            }
        }
        return null;
    }

    private void processLinkedFileDesc(GenMRProcContext ctx, Task<? extends Serializable> childTask) throws SemanticException {
        Operator<? extends OperatorDesc> currTopOp = ctx.getCurrTopOp();
        String currAliasId = ctx.getCurrAliasId();
        List<Operator<? extends OperatorDesc>> seenOps = ctx.getSeenOps();
        List<Task<? extends Serializable>> rootTasks = ctx.getRootTasks();
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        if (currTopOp != null) {
            if (!seenOps.contains(currTopOp)) {
                seenOps.add(currTopOp);
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, (MapredWork)currTask.getWork(), false, ctx);
            }
            if (!rootTasks.contains(currTask) && (currTask.getParentTasks() == null || currTask.getParentTasks().isEmpty())) {
                rootTasks.add(currTask);
            }
        }
        if (childTask != null) {
            currTask.addDependentTask(childTask);
        }
    }

    private void addStatsTask(FileSinkOperator nd, MoveTask mvTask, Task<? extends Serializable> currTask, HiveConf hconf) {
        MoveWork mvWork = (MoveWork)mvTask.getWork();
        StatsWork statsWork = null;
        if (mvWork.getLoadTableWork() != null) {
            statsWork = new StatsWork(mvWork.getLoadTableWork());
        } else if (mvWork.getLoadFileWork() != null) {
            statsWork = new StatsWork(mvWork.getLoadFileWork());
        }
        assert (statsWork != null) : "Error when genereting StatsTask";
        statsWork.setStatsReliable(hconf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
        MapredWork mrWork = (MapredWork)currTask.getWork();
        statsWork.setAggKey(((FileSinkDesc)nd.getConf()).getStatsAggPrefix());
        Task<StatsWork> statsTask = TaskFactory.get(statsWork, hconf, new Task[0]);
        ((FileSinkDesc)nd.getConf()).setGatherStats(true);
        mrWork.setGatheringStats(true);
        ((FileSinkDesc)nd.getConf()).setStatsReliable(hconf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
        ((FileSinkDesc)nd.getConf()).setMaxStatsKeyPrefixLength(hconf.getIntVar(HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX_MAX_LENGTH));
        mvTask.addDependentTask(statsTask);
        statsTask.subscribeFeed(mvTask);
    }

    private void createMRWorkForMergingFiles(FileSinkOperator fsInput, GenMRProcContext ctx, String finalName) throws SemanticException {
        MapredWork cplan;
        HiveConf conf = ctx.getParseCtx().getConf();
        FileSinkDesc fsInputDesc = (FileSinkDesc)fsInput.getConf();
        RowSchema inputRS = fsInput.getSchema();
        Operator<TableScanDesc> tsMerge = OperatorFactory.get(TableScanDesc.class, inputRS);
        TableDesc ts = (TableDesc)fsInputDesc.getTableInfo().clone();
        FileSinkDesc fsOutputDesc = new FileSinkDesc(finalName, ts, conf.getBoolVar(HiveConf.ConfVars.COMPRESSRESULT));
        boolean compressResult = conf.getBoolVar(HiveConf.ConfVars.COMPRESSRESULT);
        if (compressResult) {
            fsOutputDesc.setCompressType(conf.get("io.seqfile.compression.type"));
            fsOutputDesc.setCompressCodec(conf.get("mapred.output.compression.codec"));
        }
        fsOutputDesc.setDeleteS3Path(fsInputDesc.getDeleteS3Path());
        fsOutputDesc.setQueryId(fsInputDesc.getQueryId());
        FileSinkOperator fsOutput = (FileSinkOperator)OperatorFactory.getAndMakeChild(fsOutputDesc, inputRS, tsMerge);
        DynamicPartitionCtx dpCtx = fsInputDesc.getDynPartCtx();
        if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
            ArrayList<ColumnInfo> signature = inputRS.getSignature();
            String tblAlias = fsInputDesc.getTableInfo().getTableName();
            LinkedHashMap<String, String> colMap = new LinkedHashMap<String, String>();
            StringBuilder partCols = new StringBuilder();
            for (String dpCol : dpCtx.getDPColNames()) {
                ColumnInfo colInfo = new ColumnInfo(dpCol, TypeInfoFactory.stringTypeInfo, tblAlias, true);
                signature.add(colInfo);
                colMap.put(dpCol, dpCol);
                partCols.append(dpCol).append('/');
            }
            partCols.setLength(partCols.length() - 1);
            inputRS.setSignature(signature);
            DynamicPartitionCtx dpCtx2 = new DynamicPartitionCtx(dpCtx);
            dpCtx2.setInputToDPCols(colMap);
            fsOutputDesc.setDynPartCtx(dpCtx2);
            fsInputDesc.getTableInfo().getProperties().setProperty("partition_columns", partCols.toString());
        } else {
            fsInputDesc.getTableInfo().getProperties().remove("partition_columns");
        }
        MoveWork dummyMv = new MoveWork(null, null, null, new LoadFileDesc(fsInputDesc.getFinalDirName(), finalName, true, null, null), false);
        if (conf.getBoolVar(HiveConf.ConfVars.HIVEMERGERCFILEBLOCKLEVEL) && fsInputDesc.getTableInfo().getInputFileFormatClass().equals(RCFileInputFormat.class)) {
            String inputFormatClass = conf.getVar(HiveConf.ConfVars.HIVEMERGEINPUTFORMATBLOCKLEVEL);
            try {
                Class<?> c = Class.forName(inputFormatClass);
                LOG.info((Object)"RCFile format- Using block level merge");
                cplan = this.createRCFileMergeTask(fsInputDesc, finalName, dpCtx != null && dpCtx.getNumDPCols() > 0);
            }
            catch (ClassNotFoundException e) {
                String msg = "Illegal input format class: " + inputFormatClass;
                throw new SemanticException(msg);
            }
        } else {
            cplan = this.createMRWorkForMergingFiles(conf, tsMerge, fsInputDesc);
        }
        cplan.setInputformat("org.apache.hadoop.hive.ql.io.CombineHiveInputFormat");
        ConditionalTask cndTsk = this.createCondTask(conf, ctx.getCurrTask(), dummyMv, cplan, fsInputDesc.getFinalDirName());
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = (ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx)cndTsk.getResolverCtx();
        mrCtx.setDPCtx(fsInputDesc.getDynPartCtx());
        mrCtx.setLbCtx(fsInputDesc.getLbCtx());
        this.linkMoveTask(ctx, fsOutput, cndTsk);
    }

    private void linkMoveTask(GenMRProcContext ctx, FileSinkOperator newOutput, ConditionalTask cndTsk) {
        List<Task<MoveWork>> mvTasks = ctx.getMvTask();
        Task<MoveWork> mvTask = this.findMoveTask(mvTasks, newOutput);
        for (Task<? extends Serializable> tsk : cndTsk.getListTasks()) {
            this.linkMoveTask(ctx, mvTask, tsk);
        }
    }

    private void linkMoveTask(GenMRProcContext ctx, Task<MoveWork> mvTask, Task<? extends Serializable> task) {
        if (task.getDependentTasks() == null || task.getDependentTasks().isEmpty()) {
            this.addDependentMoveTasks(ctx, mvTask, task);
        } else {
            for (Task<Serializable> childTask : task.getDependentTasks()) {
                this.linkMoveTask(ctx, mvTask, childTask);
            }
        }
    }

    private void addDependentMoveTasks(GenMRProcContext ctx, Task<MoveWork> mvTask, Task<? extends Serializable> parentTask) {
        if (mvTask != null) {
            if (ctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_MULTI_INSERT_MOVE_TASKS_SHARE_DEPENDENCIES)) {
                DependencyCollectionTask dependencyTask = ctx.getDependencyTaskForMultiInsert();
                parentTask.addDependentTask(dependencyTask);
                if (mvTask.getWork().getLoadTableWork() != null) {
                    dependencyTask.addDependentTask(mvTask);
                } else {
                    parentTask.addDependentTask(mvTask);
                }
            } else {
                parentTask.addDependentTask(mvTask);
            }
        }
    }

    private MapredWork createMRWorkForMergingFiles(HiveConf conf, Operator<? extends OperatorDesc> topOp, FileSinkDesc fsDesc) {
        ArrayList<String> aliases = new ArrayList<String>();
        String inputDir = fsDesc.getFinalDirName();
        TableDesc tblDesc = fsDesc.getTableInfo();
        aliases.add(inputDir);
        MapredWork cplan = GenMapRedUtils.getMapRedWorkFromConf(conf);
        cplan.getPathToAliases().put(inputDir, aliases);
        cplan.getPathToPartitionInfo().put(inputDir, new PartitionDesc(tblDesc, null));
        cplan.setNumReduceTasks(0);
        cplan.getAliasToWork().put(inputDir, topOp);
        cplan.setMapperCannotSpanPartns(true);
        return cplan;
    }

    private MapredWork createRCFileMergeTask(FileSinkDesc fsInputDesc, String finalName, boolean hasDynamicPartitions) throws SemanticException {
        String inputDir = fsInputDesc.getFinalDirName();
        TableDesc tblDesc = fsInputDesc.getTableInfo();
        if (tblDesc.getInputFileFormatClass().equals(RCFileInputFormat.class)) {
            ArrayList<String> inputDirs = new ArrayList<String>();
            if (!hasDynamicPartitions && !this.isSkewedStoredAsDirs(fsInputDesc)) {
                inputDirs.add(inputDir);
            }
            MergeWork work = new MergeWork(inputDirs, finalName, hasDynamicPartitions, fsInputDesc.getDeleteS3Path(), fsInputDesc.getQueryId(), fsInputDesc.getDynPartCtx());
            LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap<String, ArrayList<String>>();
            pathToAliases.put(inputDir, (ArrayList)inputDirs.clone());
            work.setMapperCannotSpanPartns(true);
            work.setPathToAliases(pathToAliases);
            work.setAliasToWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>());
            if (hasDynamicPartitions || this.isSkewedStoredAsDirs(fsInputDesc)) {
                work.getPathToPartitionInfo().put(inputDir, new PartitionDesc(tblDesc, null));
            }
            work.setListBucketingCtx(fsInputDesc.getLbCtx());
            return work;
        }
        throw new SemanticException("createRCFileMergeTask called on non-RCFile table");
    }

    private boolean isSkewedStoredAsDirs(FileSinkDesc fsInputDesc) {
        return fsInputDesc.getLbCtx() == null ? false : fsInputDesc.getLbCtx().isSkewedStoredAsDir();
    }

    private ConditionalTask createCondTask(HiveConf conf, Task<? extends Serializable> currTask, MoveWork mvWork, MapredWork mergeWork, String inputPath) {
        Task<MapredWork> mergeOnlyMergeTask = TaskFactory.get(mergeWork, conf, new Task[0]);
        Task<MoveWork> moveOnlyMoveTask = TaskFactory.get(mvWork, conf, new Task[0]);
        Task<MapredWork> mergeAndMoveMergeTask = TaskFactory.get(mergeWork, conf, new Task[0]);
        Task<MoveWork> mergeAndMoveMoveTask = TaskFactory.get(mvWork, conf, new Task[0]);
        mergeAndMoveMergeTask.addDependentTask(mergeAndMoveMoveTask);
        ArrayList<Serializable> listWorks = new ArrayList<Serializable>();
        listWorks.add(mvWork);
        listWorks.add(mergeWork);
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        listTasks.add(moveOnlyMoveTask);
        listTasks.add(mergeOnlyMergeTask);
        listTasks.add(mergeAndMoveMergeTask);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, conf, new Task[0]);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverMergeFiles());
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = new ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx(listTasks, inputPath);
        cndTsk.setResolverCtx(mrCtx);
        currTask.addDependentTask(cndTsk);
        return cndTsk;
    }

    private Task<MoveWork> findMoveTask(List<Task<MoveWork>> mvTasks, FileSinkOperator fsOp) {
        for (Task<MoveWork> mvTsk : mvTasks) {
            MoveWork mvWork = mvTsk.getWork();
            String srcDir = null;
            if (mvWork.getLoadFileWork() != null) {
                srcDir = mvWork.getLoadFileWork().getSourceDir();
            } else if (mvWork.getLoadTableWork() != null) {
                srcDir = mvWork.getLoadTableWork().getSourceDir();
            }
            String fsOpDirName = ((FileSinkDesc)fsOp.getConf()).getFinalDirName();
            if (srcDir == null || !srcDir.equalsIgnoreCase(fsOpDirName)) continue;
            return mvTsk;
        }
        return null;
    }

    private String processFS(FileSinkOperator fsOp, Stack<Node> stack, NodeProcessorCtx opProcCtx, boolean chDir) throws SemanticException {
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        List<FileSinkOperator> seenFSOps = ctx.getSeenFileSinkOps();
        if (seenFSOps == null) {
            seenFSOps = new ArrayList<FileSinkOperator>();
        }
        if (!seenFSOps.contains(fsOp)) {
            seenFSOps.add(fsOp);
        }
        ctx.setSeenFileSinkOps(seenFSOps);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        String dest = null;
        if (chDir) {
            dest = ((FileSinkDesc)fsOp.getConf()).getFinalDirName();
            ParseContext parseCtx = ctx.getParseCtx();
            Context baseCtx = parseCtx.getContext();
            String tmpDir = null;
            if (fsOp.fsSupportsMove()) {
                tmpDir = baseCtx.getExternalTmpFileURI(new Path(dest).toUri(), false);
            } else {
                LOG.info((Object)"File system does not support move hence creating a temp file on default scratch directory");
                tmpDir = baseCtx.getMRTmpFileURI();
            }
            FileSinkDesc fileSinkDesc = (FileSinkDesc)fsOp.getConf();
            if (fileSinkDesc.isLinkedFileSink()) {
                for (FileSinkDesc fsConf : fileSinkDesc.getLinkedFileSinkDesc()) {
                    String fileName = Utilities.getFileNameFromDirName(fsConf.getDirName());
                    fsConf.setParentDir(tmpDir);
                    fsConf.setDirName(tmpDir + "/" + fileName);
                }
            } else {
                fileSinkDesc.setDirName(tmpDir);
            }
        }
        Task<MoveWork> mvTask = null;
        if (!chDir) {
            mvTask = this.findMoveTask(ctx.getMvTask(), fsOp);
        }
        Operator<? extends OperatorDesc> currTopOp = ctx.getCurrTopOp();
        String currAliasId = ctx.getCurrAliasId();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        List<Operator<? extends OperatorDesc>> seenOps = ctx.getSeenOps();
        List<Task<? extends Serializable>> rootTasks = ctx.getRootTasks();
        if (mvTask != null) {
            this.addDependentMoveTasks(ctx, mvTask, currTask);
        }
        if (currTopOp != null) {
            Task<? extends Serializable> mapTask = opTaskMap.get(null);
            if (mapTask == null) {
                if (!seenOps.contains(currTopOp)) {
                    seenOps.add(currTopOp);
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, (MapredWork)currTask.getWork(), false, ctx);
                }
                opTaskMap.put(null, currTask);
                if (!rootTasks.contains(currTask) && (currTask.getParentTasks() == null || currTask.getParentTasks().isEmpty())) {
                    rootTasks.add(currTask);
                }
            } else if (!seenOps.contains(currTopOp)) {
                seenOps.add(currTopOp);
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, (MapredWork)mapTask.getWork(), false, ctx);
            } else {
                UnionOperator currUnionOp = ctx.getCurrUnionOp();
                if (currUnionOp != null) {
                    opTaskMap.put(null, currTask);
                    ctx.setCurrTopOp(null);
                    GenMapRedUtils.initUnionPlan(ctx, currUnionOp, currTask, false);
                    return dest;
                }
            }
            return dest;
        }
        UnionOperator currUnionOp = ctx.getCurrUnionOp();
        if (currUnionOp != null) {
            opTaskMap.put(null, currTask);
            GenMapRedUtils.initUnionPlan(ctx, currUnionOp, currTask, false);
            return dest;
        }
        return dest;
    }
}

