/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 624: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 667: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 626: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 650: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 558: 
            case 560: 
            case 561: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 577: 
            case 579: 
            case 580: 
            case 581: 
            case 590: 
            case 592: 
            case 594: 
            case 607: 
            case 608: 
            case 609: 
            case 615: 
            case 617: 
            case 618: 
            case 619: 
            case 620: 
            case 621: 
            case 622: 
            case 635: 
            case 636: 
            case 669: 
            case 672: 
            case 724: 
            case 725: 
            case 736: 
            case 737: 
            case 738: 
            case 739: 
            case 740: 
            case 741: 
            case 742: 
            case 743: 
            case 744: 
            case 745: 
            case 746: 
            case 747: 
            case 760: 
            case 803: 
            case 807: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 564: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 591: 
            case 616: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 582: {
                return new ColumnStatsSemanticAnalyzer(conf, tree);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(624, HiveOperation.EXPLAIN);
        commandType.put(667, HiveOperation.LOAD);
        commandType.put(626, HiveOperation.EXPORT);
        commandType.put(650, HiveOperation.IMPORT);
        commandType.put(590, HiveOperation.CREATEDATABASE);
        commandType.put(615, HiveOperation.DROPDATABASE);
        commandType.put(760, HiveOperation.SWITCHDATABASE);
        commandType.put(595, HiveOperation.CREATETABLE);
        commandType.put(803, HiveOperation.TRUNCATETABLE);
        commandType.put(619, HiveOperation.DROPTABLE);
        commandType.put(609, HiveOperation.DESCTABLE);
        commandType.put(608, HiveOperation.DESCFUNCTION);
        commandType.put(672, HiveOperation.MSCK);
        commandType.put(553, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(570, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(568, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(567, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(561, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(554, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(574, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(558, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(575, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(565, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(620, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(737, HiveOperation.SHOWDATABASES);
        commandType.put(742, HiveOperation.SHOWTABLES);
        commandType.put(736, HiveOperation.SHOWCOLUMNS);
        commandType.put(746, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(747, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(743, HiveOperation.SHOW_CREATETABLE);
        commandType.put(738, HiveOperation.SHOWFUNCTIONS);
        commandType.put(739, HiveOperation.SHOWINDEXES);
        commandType.put(741, HiveOperation.SHOWPARTITIONS);
        commandType.put(740, HiveOperation.SHOWLOCKS);
        commandType.put(591, HiveOperation.CREATEFUNCTION);
        commandType.put(616, HiveOperation.DROPFUNCTION);
        commandType.put(596, HiveOperation.CREATEVIEW);
        commandType.put(621, HiveOperation.DROPVIEW);
        commandType.put(592, HiveOperation.CREATEINDEX);
        commandType.put(617, HiveOperation.DROPINDEX);
        commandType.put(552, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(551, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(580, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(622, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(577, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(579, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(719, HiveOperation.QUERY);
        commandType.put(669, HiveOperation.LOCKTABLE);
        commandType.put(807, HiveOperation.UNLOCKTABLE);
        commandType.put(594, HiveOperation.CREATEROLE);
        commandType.put(618, HiveOperation.DROPROLE);
        commandType.put(635, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(724, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(744, HiveOperation.SHOW_GRANT);
        commandType.put(636, HiveOperation.GRANT_ROLE);
        commandType.put(725, HiveOperation.REVOKE_ROLE);
        commandType.put(745, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(550, HiveOperation.ALTERDATABASE);
        commandType.put(607, HiveOperation.DESCDATABASE);
        commandType.put(573, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(582, HiveOperation.ANALYZE_TABLE);
        tablePartitionCommandType.put(557, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(562, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(563, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(556, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(572, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(571, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(569, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(576, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(769, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(560, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
    }
}

