/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public final class TypeCheckProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)TypeCheckProcFactory.class.getName());

    private TypeCheckProcFactory() {
    }

    public static ExprNodeDesc processGByExpr(Node nd, Object procCtx) throws SemanticException {
        ASTNode expr = (ASTNode)nd;
        TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
        RowResolver input = ctx.getInputRR();
        ExprNodeColumnDesc desc = null;
        ColumnInfo colInfo = input.getExpression(expr);
        if (colInfo != null) {
            desc = new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
            ASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                ctx.getUnparseTranslator().addCopyTranslation(expr, source);
            }
            return desc;
        }
        return desc;
    }

    public static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "676%"), TypeCheckProcFactory.getNullExprProcessor());
        opRules.put(new RuleRegExp("R2", "273%|285%|282%|7%|18%"), TypeCheckProcFactory.getNumExprProcessor());
        opRules.put(new RuleRegExp("R3", "26%|283%|587%|757%|%|116%|47%|259%|119%|34%|147%|225%"), TypeCheckProcFactory.getStrExprProcessor());
        opRules.put(new RuleRegExp("R4", "240%|96%"), TypeCheckProcFactory.getBoolExprProcessor());
        opRules.put(new RuleRegExp("R5", "786%"), TypeCheckProcFactory.getColumnExprProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(TypeCheckProcFactory.getDefaultExprProcessor(), opRules, tcCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(expr);
        LinkedHashMap<Node, Object> nodeOutputs = new LinkedHashMap<Node, Object>();
        ogw.startWalking(topNodes, nodeOutputs);
        return TypeCheckProcFactory.convert(nodeOutputs);
    }

    private static Map<ASTNode, ExprNodeDesc> convert(Map<Node, Object> outputs) {
        LinkedHashMap<ASTNode, ExprNodeDesc> converted = new LinkedHashMap<ASTNode, ExprNodeDesc>();
        for (Map.Entry<Node, Object> entry : outputs.entrySet()) {
            if (entry.getKey() instanceof ASTNode && entry.getValue() instanceof ExprNodeDesc) {
                converted.put((ASTNode)entry.getKey(), (ExprNodeDesc)entry.getValue());
                continue;
            }
            LOG.warn((Object)("Invalid type entry " + entry));
        }
        return converted;
    }

    public static NullExprProcessor getNullExprProcessor() {
        return new NullExprProcessor();
    }

    public static NumExprProcessor getNumExprProcessor() {
        return new NumExprProcessor();
    }

    public static StrExprProcessor getStrExprProcessor() {
        return new StrExprProcessor();
    }

    public static BoolExprProcessor getBoolExprProcessor() {
        return new BoolExprProcessor();
    }

    public static ColumnExprProcessor getColumnExprProcessor() {
        return new ColumnExprProcessor();
    }

    public static DefaultExprProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        static HashMap<Integer, String> specialUnaryOperatorTextHashMap = new HashMap();
        static HashMap<Integer, String> specialFunctionTextHashMap;
        static HashMap<Integer, String> conversionFunctionTextHashMap;
        static HashSet<Integer> windowingTokens;

        private static boolean isRedundantConversionFunction(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children) {
            if (!isFunction) {
                return false;
            }
            if (children.size() != 1) {
                return false;
            }
            String funcText = conversionFunctionTextHashMap.get(((ASTNode)expr.getChild(0)).getType());
            if (funcText == null) {
                return false;
            }
            return ((PrimitiveTypeInfo)children.get(0).getTypeInfo()).getTypeName().equalsIgnoreCase(funcText);
        }

        public static String getFunctionText(ASTNode expr, boolean isFunction) {
            String funcText = null;
            if (!isFunction) {
                if (expr.getChildCount() == 1) {
                    funcText = specialUnaryOperatorTextHashMap.get(expr.getType());
                }
                if (funcText == null) {
                    funcText = expr.getText();
                }
            } else {
                assert (expr.getChildCount() >= 1);
                int funcType = ((ASTNode)expr.getChild(0)).getType();
                funcText = specialFunctionTextHashMap.get(funcType);
                if (funcText == null) {
                    funcText = conversionFunctionTextHashMap.get(funcType);
                }
                if (funcText == null) {
                    funcText = ((ASTNode)expr.getChild(0)).getText();
                }
            }
            return BaseSemanticAnalyzer.unescapeIdentifier(funcText);
        }

        public static ExprNodeDesc getFuncExprNodeDesc(String udfName, ExprNodeDesc ... children) throws UDFArgumentException {
            FunctionInfo fi = FunctionRegistry.getFunctionInfo(udfName);
            if (fi == null) {
                throw new UDFArgumentException(udfName + " not found.");
            }
            GenericUDF genericUDF = fi.getGenericUDF();
            if (genericUDF == null) {
                throw new UDFArgumentException(udfName + " is an aggregation function or a table function.");
            }
            ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.length);
            childrenList.addAll(Arrays.asList(children));
            return ExprNodeGenericFuncDesc.newInstance(genericUDF, childrenList);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static ExprNodeDesc getXpathOrFuncExprNodeDesc(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children, TypeCheckCtx ctx) throws SemanticException, UDFArgumentException {
            void var5_27;
            void var5_25;
            if (DefaultExprProcessor.isRedundantConversionFunction(expr, isFunction, children)) {
                assert (children.size() == 1);
                assert (children.get(0) != null);
                return children.get(0);
            }
            String funcText = DefaultExprProcessor.getFunctionText(expr, isFunction);
            if (funcText.equals(".")) {
                boolean isList;
                assert (children.size() == 2);
                assert (children.get(1) instanceof ExprNodeConstantDesc);
                ExprNodeDesc object = children.get(0);
                ExprNodeConstantDesc fieldName = (ExprNodeConstantDesc)children.get(1);
                assert (fieldName.getValue() instanceof String);
                String fieldNameString = (String)fieldName.getValue();
                TypeInfo objectTypeInfo = object.getTypeInfo();
                boolean bl = isList = object.getTypeInfo().getCategory() == ObjectInspector.Category.LIST;
                if (isList) {
                    objectTypeInfo = ((ListTypeInfo)objectTypeInfo).getListElementTypeInfo();
                }
                if (objectTypeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new SemanticException(ErrorMsg.INVALID_DOT.getMsg(expr));
                }
                TypeInfo t = ((StructTypeInfo)objectTypeInfo).getStructFieldTypeInfo(fieldNameString);
                if (isList) {
                    t = TypeInfoFactory.getListTypeInfo(t);
                }
                ExprNodeFieldDesc exprNodeFieldDesc = new ExprNodeFieldDesc(t, children.get(0), fieldNameString, isList);
            } else if (funcText.equals("[")) {
                assert (children.size() == 2);
                TypeInfo myt = children.get(0).getTypeInfo();
                if (myt.getCategory() == ObjectInspector.Category.LIST) {
                    if (!(children.get(1) instanceof ExprNodeConstantDesc) || !((ExprNodeConstantDesc)children.get(1)).getTypeInfo().equals(TypeInfoFactory.intTypeInfo)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_ARRAYINDEX_CONSTANT.getMsg()));
                    }
                    TypeInfo t = ((ListTypeInfo)myt).getListElementTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                } else {
                    if (myt.getCategory() != ObjectInspector.Category.MAP) throw new SemanticException(ErrorMsg.NON_COLLECTION_TYPE.getMsg(expr, myt.getTypeName()));
                    if (!(children.get(1) instanceof ExprNodeConstantDesc)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_MAPINDEX_CONSTANT.getMsg()));
                    }
                    if (!((ExprNodeConstantDesc)children.get(1)).getTypeInfo().equals(((MapTypeInfo)myt).getMapKeyTypeInfo())) {
                        throw new SemanticException(ErrorMsg.INVALID_MAPINDEX_TYPE.getMsg(expr));
                    }
                    TypeInfo t = ((MapTypeInfo)myt).getMapValueTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                }
            } else {
                FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcText);
                if (fi == null) {
                    if (!isFunction) throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg((ASTNode)expr.getChild(0)));
                }
                if (!fi.isNative()) {
                    ctx.getUnparseTranslator().addIdentifierTranslation((ASTNode)expr.getChild(0));
                }
                if (fi.getGenericUDTF() != null) {
                    throw new SemanticException(ErrorMsg.UDTF_INVALID_LOCATION.getMsg());
                }
                if (fi.getGenericUDAFResolver() != null) {
                    if (!isFunction) throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg(expr));
                    throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg((ASTNode)expr.getChild(0)));
                }
                if (!ctx.getAllowStatefulFunctions() && fi.getGenericUDF() != null && FunctionRegistry.isStateful(fi.getGenericUDF())) {
                    throw new SemanticException(ErrorMsg.UDF_STATEFUL_INVALID_LOCATION.getMsg());
                }
                if (fi.getGenericUDF() instanceof GenericUDFBaseCompare && children.size() == 2 && (children.get(0) instanceof ExprNodeConstantDesc && children.get(1) instanceof ExprNodeColumnDesc || children.get(0) instanceof ExprNodeColumnDesc && children.get(1) instanceof ExprNodeConstantDesc)) {
                    int constIdx = children.get(0) instanceof ExprNodeConstantDesc ? 0 : 1;
                    HashSet<String> inferTypes = new HashSet<String>(Arrays.asList("tinyint".toLowerCase(), "smallint".toLowerCase(), "int".toLowerCase(), "bigint".toLowerCase(), "float".toLowerCase(), "double".toLowerCase(), "string".toLowerCase()));
                    String constType = children.get(constIdx).getTypeString().toLowerCase();
                    String columnType = children.get(1 - constIdx).getTypeString().toLowerCase();
                    if (inferTypes.contains(constType) && inferTypes.contains(columnType) && !columnType.equalsIgnoreCase(constType)) {
                        void var13_38;
                        String constValue = ((ExprNodeConstantDesc)children.get(constIdx)).getValue().toString();
                        boolean triedDouble = false;
                        Object var13_29 = null;
                        try {
                            if (columnType.equalsIgnoreCase("tinyint")) {
                                Byte by = new Byte(constValue);
                            } else if (columnType.equalsIgnoreCase("smallint")) {
                                Short s = new Short(constValue);
                            } else if (columnType.equalsIgnoreCase("int")) {
                                Integer n = new Integer(constValue);
                            } else if (columnType.equalsIgnoreCase("bigint")) {
                                Long l = new Long(constValue);
                            } else if (columnType.equalsIgnoreCase("float")) {
                                Float f = new Float(constValue);
                            } else if (columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("string") && !constType.equalsIgnoreCase("bigint")) {
                                triedDouble = true;
                                Double d = new Double(constValue);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (triedDouble || fi.getGenericUDF() instanceof GenericUDFOPEqual && !columnType.equals("string")) {
                                return new ExprNodeConstantDesc(false);
                            }
                            try {
                                Double d = new Double(constValue);
                            }
                            catch (NumberFormatException ex) {
                                return new ExprNodeConstantDesc(false);
                            }
                        }
                        if (var13_38 != null) {
                            children.set(constIdx, new ExprNodeConstantDesc(var13_38));
                        }
                    }
                }
                ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(fi.getGenericUDF(), children);
            }
            if (FunctionRegistry.isOpPositive((ExprNodeDesc)var5_25)) {
                assert (var5_25.getChildren().size() == 1);
                ExprNodeDesc exprNodeDesc = var5_25.getChildren().get(0);
            }
            assert (var5_27 != null);
            return var5_27;
        }

        private boolean isDescendant(Node ans, Node des) {
            if (ans.getChildren() == null) {
                return false;
            }
            for (Node node : ans.getChildren()) {
                if (node == des) {
                    return true;
                }
                if (!this.isDescendant(node, des)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                if (this.isDescendant(nd, ctx.getErrorSrcNode())) {
                    ctx.setError(null, null);
                }
                return desc;
            }
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            if (windowingTokens.contains(expr.getType())) {
                return null;
            }
            if (expr.getType() == 788) {
                return null;
            }
            if (expr.getType() == 549) {
                RowResolver input = ctx.getInputRR();
                ExprNodeColumnListDesc columnList = new ExprNodeColumnListDesc();
                assert (expr.getChildCount() <= 1);
                if (expr.getChildCount() == 1) {
                    ASTNode child = (ASTNode)expr.getChild(0);
                    assert (child.getType() == 788);
                    assert (child.getChildCount() == 1);
                    String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    HashMap<String, ColumnInfo> columns = input.getFieldMap(tableAlias);
                    if (columns == null) {
                        throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(child));
                    }
                    for (Map.Entry<String, ColumnInfo> colMap : columns.entrySet()) {
                        ColumnInfo colInfo = colMap.getValue();
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), false));
                    }
                } else {
                    for (ColumnInfo colInfo : input.getColumnInfos()) {
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), false));
                    }
                }
                return columnList;
            }
            if (expr.getType() == 17 && expr.getChild(0).getType() == 786 && nodeOutputs[0] == null) {
                String tableAlias;
                RowResolver input = ctx.getInputRR();
                ColumnInfo colInfo = input.get(tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText()), ((ExprNodeConstantDesc)nodeOutputs[1]).getValue().toString());
                if (colInfo == null) {
                    ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(1)), expr);
                    return null;
                }
                return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
            }
            if (conversionFunctionTextHashMap.keySet().contains(expr.getType()) || specialFunctionTextHashMap.keySet().contains(expr.getType()) || expr.getToken().getType() == 13 || expr.getToken().getType() == 12) {
                return null;
            }
            boolean isFunction = expr.getType() == 632 || expr.getType() == 634 || expr.getType() == 633;
            int childrenBegin = isFunction ? 1 : 0;
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(expr.getChildCount() - childrenBegin);
            for (int ci = childrenBegin; ci < expr.getChildCount(); ++ci) {
                if (nodeOutputs[ci] instanceof ExprNodeColumnListDesc) {
                    children.addAll(((ExprNodeColumnListDesc)nodeOutputs[ci]).getChildren());
                    continue;
                }
                children.add((ExprNodeDesc)nodeOutputs[ci]);
            }
            if (expr.getType() == 634) {
                RowResolver input = ctx.getInputRR();
                for (ColumnInfo colInfo : input.getColumnInfos()) {
                    if (colInfo.getIsVirtualCol()) continue;
                    children.add(new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), false));
                }
            }
            if (children.contains(null)) {
                RowResolver input = ctx.getInputRR();
                List<String> possibleColumnNames = input.getReferenceableColumnAliases(null, -1);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, ", "));
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(0), reason), expr);
                return null;
            }
            try {
                return DefaultExprProcessor.getXpathOrFuncExprNodeDesc(expr, isFunction, children, ctx);
            }
            catch (UDFArgumentTypeException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_TYPE.getMsg(expr.getChild(childrenBegin + e.getArgumentId()), e.getMessage()));
            }
            catch (UDFArgumentLengthException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_LENGTH.getMsg(expr, e.getMessage()));
            }
            catch (UDFArgumentException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT.getMsg(expr, e.getMessage()));
            }
        }

        static {
            specialUnaryOperatorTextHashMap.put(274, "positive");
            specialUnaryOperatorTextHashMap.put(270, "negative");
            specialFunctionTextHashMap = new HashMap();
            specialFunctionTextHashMap.put(658, "isnull");
            specialFunctionTextHashMap.put(657, "isnotnull");
            conversionFunctionTextHashMap = new HashMap();
            conversionFunctionTextHashMap.put(585, "boolean");
            conversionFunctionTextHashMap.put(799, "tinyint");
            conversionFunctionTextHashMap.put(751, "smallint");
            conversionFunctionTextHashMap.put(656, "int");
            conversionFunctionTextHashMap.put(583, "bigint");
            conversionFunctionTextHashMap.put(629, "float");
            conversionFunctionTextHashMap.put(614, "double");
            conversionFunctionTextHashMap.put(756, "string");
            conversionFunctionTextHashMap.put(584, "binary");
            conversionFunctionTextHashMap.put(798, "timestamp");
            conversionFunctionTextHashMap.put(605, "decimal");
            windowingTokens = new HashSet();
            windowingTokens.add(168);
            windowingTokens.add(699);
            windowingTokens.add(613);
            windowingTokens.add(752);
            windowingTokens.add(588);
            windowingTokens.add(815);
            windowingTokens.add(814);
            windowingTokens.add(816);
            windowingTokens.add(243);
            windowingTokens.add(176);
            windowingTokens.add(102);
            windowingTokens.add(63);
            windowingTokens.add(790);
            windowingTokens.add(791);
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode parent = stack.size() > 1 ? (ASTNode)stack.get(stack.size() - 2) : null;
            RowResolver input = ctx.getInputRR();
            if (expr.getType() != 786) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr), expr);
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean isTableAlias = input.hasTableAlias(tableOrCol);
            ColumnInfo colInfo = input.get(null, tableOrCol);
            if (isTableAlias) {
                if (colInfo != null) {
                    if (parent != null && parent.getType() == 17) {
                        return null;
                    }
                    return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                }
                return null;
            }
            if (colInfo == null) {
                if (input.getIsExprResolver()) {
                    ASTNode exprNode = expr;
                    if (!stack.empty()) {
                        ASTNode tmp = (ASTNode)stack.pop();
                        if (!stack.empty()) {
                            exprNode = (ASTNode)stack.peek();
                        }
                        stack.push(tmp);
                    }
                    ctx.setError(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(exprNode), expr);
                    return null;
                }
                List<String> possibleColumnNames = input.getReferenceableColumnAliases(tableOrCol, -1);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, ", "));
                ctx.setError(ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(expr.getChild(0), reason), expr);
                LOG.debug((Object)(ErrorMsg.INVALID_TABLE_OR_COLUMN.toString() + ":" + input.toString()));
                return null;
            }
            ExprNodeColumnDesc exprNodColDesc = new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
            exprNodColDesc.setSkewedCol(colInfo.isSkewedCol());
            return exprNodColDesc;
        }
    }

    public static class BoolExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            Boolean bool = null;
            switch (expr.getToken().getType()) {
                case 240: {
                    bool = Boolean.TRUE;
                    break;
                }
                case 96: {
                    bool = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, bool);
        }
    }

    public static class StrExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String str = null;
            switch (expr.getToken().getType()) {
                case 283: {
                    str = BaseSemanticAnalyzer.unescapeSQLString(expr.getText());
                    break;
                }
                case 757: {
                    StringBuilder sb = new StringBuilder();
                    for (Node n : expr.getChildren()) {
                        sb.append(BaseSemanticAnalyzer.unescapeSQLString(((ASTNode)n).getText()));
                    }
                    str = sb.toString();
                    break;
                }
                case 587: {
                    str = BaseSemanticAnalyzer.charSetString(expr.getChild(0).getText(), expr.getChild(1).getText());
                    break;
                }
                default: {
                    str = BaseSemanticAnalyzer.unescapeIdentifier(expr.getText());
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, str);
        }
    }

    public static class NumExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            Number v = null;
            ASTNode expr = (ASTNode)nd;
            try {
                if (expr.getText().endsWith("L")) {
                    v = Long.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("S")) {
                    v = Short.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("Y")) {
                    v = Byte.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else {
                    if (expr.getText().endsWith("BD")) {
                        return new ExprNodeConstantDesc(TypeInfoFactory.decimalTypeInfo, expr.getText().substring(0, expr.getText().length() - 2));
                    }
                    v = Double.valueOf(expr.getText());
                    v = Long.valueOf(expr.getText());
                    v = Integer.valueOf(expr.getText());
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (v == null) {
                throw new SemanticException(ErrorMsg.INVALID_NUMERICAL_CONSTANT.getMsg(expr));
            }
            return new ExprNodeConstantDesc(v);
        }
    }

    public static class NullExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            return new ExprNodeNullDesc();
        }
    }
}

