/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;

public class ConditionalResolverCommonJoin
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Task<? extends Serializable>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverCommonJoinCtx ctx = (ConditionalResolverCommonJoinCtx)objCtx;
        ArrayList<Task<? extends Serializable>> resTsks = new ArrayList<Task<? extends Serializable>>();
        HashMap<String, ArrayList<String>> pathToAliases = ctx.getPathToAliases();
        HashMap<String, Long> aliasToKnownSize = ctx.getAliasToKnownSize();
        String bigTableAlias = this.resolveMapJoinTask(pathToAliases, ctx.getAliasToTask(), aliasToKnownSize, ctx.getHdfsTmpDir(), ctx.getLocalTmpDir(), conf);
        if (bigTableAlias == null) {
            resTsks.add(ctx.getCommonJoinTask());
        } else {
            Task<? extends Serializable> task = ctx.getAliasToTask().get(bigTableAlias);
            if (task.getTaskTag() == 3) {
                task.getBackupTask().setTaskTag(4);
            }
            resTsks.add(task);
        }
        return resTsks;
    }

    /*
     * WARNING - void declaration
     */
    private String resolveMapJoinTask(HashMap<String, ArrayList<String>> pathToAliases, HashMap<String, Task<? extends Serializable>> aliasToTask, HashMap<String, Long> aliasToKnownSize, String hdfsTmpDir, String localTmpDir, HiveConf conf) {
        AliasFileSizePair pair;
        String bigTableFileAlias = null;
        long smallTablesFileSizeSum = 0L;
        HashMap<String, AliasFileSizePair> aliasToFileSizeMap = new HashMap<String, AliasFileSizePair>();
        for (Map.Entry<String, Long> entry : aliasToKnownSize.entrySet()) {
            String alias = entry.getKey();
            pair = new AliasFileSizePair(alias, entry.getValue());
            aliasToFileSizeMap.put(alias, pair);
        }
        try {
            void var12_16;
            for (Map.Entry<String, Serializable> entry : pathToAliases.entrySet()) {
                ArrayList aliasArray;
                String p = entry.getKey();
                if (!p.startsWith(hdfsTmpDir) && !p.startsWith(localTmpDir) || (aliasArray = (ArrayList)entry.getValue()).size() <= 0) continue;
                Path path = new Path(p);
                FileSystem fs = path.getFileSystem((Configuration)conf);
                long fileSize = fs.getContentSummary(path).getLength();
                for (String alias : aliasArray) {
                    AliasFileSizePair pair2 = (AliasFileSizePair)aliasToFileSizeMap.get(alias);
                    if (pair2 == null) {
                        pair2 = new AliasFileSizePair(alias, 0L);
                        aliasToFileSizeMap.put(alias, pair2);
                    }
                    pair2.size += fileSize;
                }
            }
            ArrayList aliasFileSizeList = new ArrayList(aliasToFileSizeMap.values());
            Collections.sort(aliasFileSizeList);
            int n = aliasFileSizeList.size() - 1;
            boolean bigAliasFound = false;
            while (var12_16 >= 0) {
                pair = (AliasFileSizePair)aliasFileSizeList.get((int)var12_16);
                String alias = pair.alias;
                long size = pair.size;
                --var12_16;
                if (!bigAliasFound && aliasToTask.get(alias) != null) {
                    bigAliasFound = true;
                    bigTableFileAlias = alias;
                    continue;
                }
                smallTablesFileSizeSum += size;
            }
            long threshold = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
            if (smallTablesFileSizeSum <= threshold) {
                return bigTableFileAlias;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    class AliasFileSizePair
    implements Comparable<AliasFileSizePair> {
        String alias;
        long size;

        AliasFileSizePair(String alias, long size) {
            this.alias = alias;
            this.size = size;
        }

        @Override
        public int compareTo(AliasFileSizePair o) {
            if (o == null) {
                return 1;
            }
            return (int)(this.size - o.size);
        }
    }

    public static class ConditionalResolverCommonJoinCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private HashMap<String, Task<? extends Serializable>> aliasToTask;
        HashMap<String, ArrayList<String>> pathToAliases;
        HashMap<String, Long> aliasToKnownSize;
        private Task<? extends Serializable> commonJoinTask;
        private String localTmpDir;
        private String hdfsTmpDir;

        public HashMap<String, Task<? extends Serializable>> getAliasToTask() {
            return this.aliasToTask;
        }

        public void setAliasToTask(HashMap<String, Task<? extends Serializable>> aliasToTask) {
            this.aliasToTask = aliasToTask;
        }

        public Task<? extends Serializable> getCommonJoinTask() {
            return this.commonJoinTask;
        }

        public void setCommonJoinTask(Task<? extends Serializable> commonJoinTask) {
            this.commonJoinTask = commonJoinTask;
        }

        public HashMap<String, Long> getAliasToKnownSize() {
            return this.aliasToKnownSize;
        }

        public void setAliasToKnownSize(HashMap<String, Long> aliasToKnownSize) {
            this.aliasToKnownSize = aliasToKnownSize;
        }

        public HashMap<String, ArrayList<String>> getPathToAliases() {
            return this.pathToAliases;
        }

        public void setPathToAliases(HashMap<String, ArrayList<String>> pathToAliases) {
            this.pathToAliases = pathToAliases;
        }

        public String getLocalTmpDir() {
            return this.localTmpDir;
        }

        public void setLocalTmpDir(String localTmpDir) {
            this.localTmpDir = localTmpDir;
        }

        public String getHdfsTmpDir() {
            return this.hdfsTmpDir;
        }

        public void setHdfsTmpDir(String hdfsTmpDir) {
            this.hdfsTmpDir = hdfsTmpDir;
        }
    }
}

