/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class ConditionalResolverMergeFiles
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)ConditionalResolverMergeFiles.class.getName());

    @Override
    public List<Task<? extends Serializable>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverMergeFilesCtx ctx = (ConditionalResolverMergeFilesCtx)objCtx;
        String dirName = ctx.getDir();
        ArrayList<Task<? extends Serializable>> resTsks = new ArrayList<Task<? extends Serializable>>();
        long trgtSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESSIZE);
        long avgConditionSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESAVGSIZE);
        trgtSize = Math.max(trgtSize, avgConditionSize);
        Task<? extends Serializable> mvTask = ctx.getListTasks().get(0);
        Task<? extends Serializable> mrTask = ctx.getListTasks().get(1);
        Task<? extends Serializable> mrAndMvTask = ctx.getListTasks().get(2);
        try {
            Path dirPath = new Path(dirName);
            FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
            DynamicPartitionCtx dpCtx = ctx.getDPCtx();
            Task<? extends Serializable> moveTask = ctx.getListTasks().get(0);
            MoveWork moveWork = (MoveWork)moveTask.getWork();
            boolean moveBetweenDifferentFileSystem = this.isFileInDifferentFS(dirName, moveWork.getLoadFileWork().getTargetDir());
            if (moveBetweenDifferentFileSystem || inpFs.exists(dirPath)) {
                int lbLevel;
                MapredWork work = (MapredWork)mrTask.getWork();
                int n = lbLevel = ctx.getLbCtx() == null ? 0 : ctx.getLbCtx().calculateListBucketingLevel();
                if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                    int numDPCols = dpCtx.getNumDPCols();
                    int dpLbLevel = numDPCols + lbLevel;
                    this.generateActualTasks(conf, resTsks, trgtSize, avgConditionSize, mvTask, mrTask, mrAndMvTask, dirPath, inpFs, ctx, work, dpLbLevel, moveBetweenDifferentFileSystem);
                } else if (lbLevel == 0) {
                    long totalSz = this.getMergeSize(inpFs, dirPath, avgConditionSize, moveBetweenDifferentFileSystem);
                    if (totalSz >= 0L) {
                        this.setupMapRedWork(conf, work, trgtSize, totalSz);
                        resTsks.add(mrTask);
                    } else {
                        resTsks.add(mvTask);
                    }
                } else {
                    this.generateActualTasks(conf, resTsks, trgtSize, avgConditionSize, mvTask, mrTask, mrAndMvTask, dirPath, inpFs, ctx, work, lbLevel, moveBetweenDifferentFileSystem);
                }
            } else {
                resTsks.add(mvTask);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (resTsks.size() == 1);
        return resTsks;
    }

    private void generateActualTasks(HiveConf conf, List<Task<? extends Serializable>> resTsks, long trgtSize, long avgConditionSize, Task<? extends Serializable> mvTask, Task<? extends Serializable> mrTask, Task<? extends Serializable> mrAndMvTask, Path dirPath, FileSystem inpFs, ConditionalResolverMergeFilesCtx ctx, MapredWork work, int dpLbLevel, boolean moveBetweenDifferentFileSystem) throws IOException {
        DynamicPartitionCtx dpCtx = ctx.getDPCtx();
        FileStatus[] status = Utilities.getFileStatusRecurse(dirPath, dpLbLevel, inpFs);
        LinkedHashMap<String, PartitionDesc> ptpi = work.getPathToPartitionInfo();
        assert (ptpi.size() == 1);
        String path = (String)ptpi.keySet().iterator().next();
        PartitionDesc partDesc = (PartitionDesc)ptpi.get(path);
        TableDesc tblDesc = partDesc.getTableDesc();
        ptpi.remove(path);
        LinkedHashMap<String, ArrayList<String>> pta = work.getPathToAliases();
        assert (pta.size() == 1);
        path = (String)pta.keySet().iterator().next();
        ArrayList aliases = (ArrayList)pta.get(path);
        pta.remove(path);
        long totalSz = 0L;
        boolean doMerge = false;
        if (moveBetweenDifferentFileSystem) {
            doMerge = true;
            if (status.length == 0) {
                inpFs.createNewFile(new Path(dirPath, "empty"));
                status = Utilities.getFileStatusRecurse(dirPath, dpCtx.getNumDPCols(), inpFs);
            }
        }
        ArrayList<String> toMove = new ArrayList<String>();
        for (int i = 0; i < status.length; ++i) {
            long len = this.getMergeSize(inpFs, status[i].getPath(), avgConditionSize, moveBetweenDifferentFileSystem);
            if (len >= 0L) {
                doMerge = true;
                totalSz += len;
                PartitionDesc pDesc = dpCtx != null ? this.generateDPFullPartSpec(dpCtx, status, tblDesc, i) : partDesc;
                work.resolveDynamicPartitionStoredAsSubDirsMerge(conf, status[i].getPath(), tblDesc, aliases, pDesc);
                continue;
            }
            toMove.add(status[i].getPath().toString());
        }
        if (doMerge) {
            this.setupMapRedWork(conf, work, trgtSize, totalSz);
            if (toMove.size() > 0) {
                resTsks.add(mrAndMvTask);
                MoveWork mvWork = (MoveWork)mvTask.getWork();
                LoadFileDesc lfd = mvWork.getLoadFileWork();
                String targetDir = lfd.getTargetDir();
                ArrayList<String> targetDirs = new ArrayList<String>(toMove.size());
                for (int i = 0; i < toMove.size(); ++i) {
                    String toMoveStr = (String)toMove.get(i);
                    if (toMoveStr.endsWith("/")) {
                        toMoveStr = toMoveStr.substring(0, toMoveStr.length() - 1);
                    }
                    String[] moveStrSplits = toMoveStr.split("/");
                    String target = targetDir;
                    for (int dpIndex = moveStrSplits.length - dpLbLevel; dpIndex < moveStrSplits.length; ++dpIndex) {
                        target = target + "/" + moveStrSplits[dpIndex];
                    }
                    targetDirs.add(target);
                }
                LoadMultiFilesDesc lmfd = new LoadMultiFilesDesc(toMove, targetDirs, lfd.getIsDfsDir(), lfd.getColumns(), lfd.getColumnTypes());
                mvWork.setLoadFileWork(null);
                mvWork.setLoadTableWork(null);
                mvWork.setMultiFilesDesc(lmfd);
            } else {
                resTsks.add(mrTask);
            }
        } else {
            resTsks.add(mvTask);
        }
    }

    private PartitionDesc generateDPFullPartSpec(DynamicPartitionCtx dpCtx, FileStatus[] status, TableDesc tblDesc, int i) {
        LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(dpCtx.getPartSpec());
        Warehouse.makeSpecFromName(fullPartSpec, (Path)status[i].getPath());
        PartitionDesc pDesc = new PartitionDesc(tblDesc, fullPartSpec);
        return pDesc;
    }

    private void setupMapRedWork(HiveConf conf, MapredWork work, long targetSize, long totalSize) {
        if (work.getNumReduceTasks() > 0) {
            int maxReducers = conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
            int reducers = (int)((totalSize + targetSize - 1L) / targetSize);
            reducers = Math.max(1, reducers);
            reducers = Math.min(maxReducers, reducers);
            work.setNumReduceTasks(reducers);
        }
        work.setMaxSplitSize(targetSize);
        work.setMinSplitSize(targetSize);
        work.setMinSplitSizePerNode(targetSize);
        work.setMinSplitSizePerRack(targetSize);
    }

    private AverageSize getAverageSize(FileSystem inpFs, Path dirPath) {
        AverageSize dummy = new AverageSize(0L, 0);
        AverageSize error = new AverageSize(-1L, -1);
        try {
            FileStatus[] fStats = inpFs.listStatus(dirPath);
            if (fStats == null) {
                return error;
            }
            long totalSz = 0L;
            int numFiles = 0;
            for (FileStatus fStat : fStats) {
                if (fStat.isDir()) {
                    AverageSize avgSzDir = this.getAverageSize(inpFs, fStat.getPath());
                    if (avgSzDir.getTotalSize() < 0L) {
                        return error;
                    }
                    totalSz += avgSzDir.getTotalSize();
                    numFiles += avgSzDir.getNumFiles();
                    continue;
                }
                totalSz += fStat.getLen();
                ++numFiles;
            }
            return new AverageSize(totalSz, numFiles);
        }
        catch (IOException e) {
            return error;
        }
    }

    private boolean isFileInDifferentFS(String filename1, String filename2) {
        URI uri1 = null;
        URI uri2 = null;
        try {
            uri1 = new URI(filename1);
            uri2 = new URI(filename2);
            if (uri1 == null || uri2 == null || uri1.getHost() == null || uri2.getHost() == null) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing URIs: " + uri1 + ", " + uri2, e);
        }
        return !uri1.getHost().equals(uri2.getHost());
    }

    private long getMergeSize(FileSystem inpFs, Path dirPath, long avgSize, boolean moveBetweenDifferentFileSystem) {
        AverageSize averageSize = this.getAverageSize(inpFs, dirPath);
        if (!(moveBetweenDifferentFileSystem || averageSize.getNumFiles() > 1 && averageSize.getTotalSize() > 0L)) {
            return -1L;
        }
        if (moveBetweenDifferentFileSystem || averageSize.getTotalSize() / (long)averageSize.getNumFiles() < avgSize) {
            return averageSize.getTotalSize();
        }
        return -1L;
    }

    private static class AverageSize {
        private final long totalSize;
        private final int numFiles;

        public AverageSize(long totalSize, int numFiles) {
            this.totalSize = totalSize;
            this.numFiles = numFiles;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public int getNumFiles() {
            return this.numFiles;
        }
    }

    public static class ConditionalResolverMergeFilesCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<Task<? extends Serializable>> listTasks;
        private String dir;
        private DynamicPartitionCtx dpCtx;
        private ListBucketingCtx lbCtx;

        public ConditionalResolverMergeFilesCtx() {
        }

        public ConditionalResolverMergeFilesCtx(List<Task<? extends Serializable>> listTasks, String dir) {
            this.listTasks = listTasks;
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public List<Task<? extends Serializable>> getListTasks() {
            return this.listTasks;
        }

        public void setListTasks(List<Task<? extends Serializable>> listTasks) {
            this.listTasks = listTasks;
        }

        public DynamicPartitionCtx getDPCtx() {
            return this.dpCtx;
        }

        public void setDPCtx(DynamicPartitionCtx dp) {
            this.dpCtx = dp;
        }

        public ListBucketingCtx getLbCtx() {
            return this.lbCtx;
        }

        public void setLbCtx(ListBucketingCtx lbCtx) {
            this.lbCtx = lbCtx;
        }
    }
}

