/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SetProcessor
implements CommandProcessor {
    private static String prefix = "set: ";
    public static final String ENV_PREFIX = "env:";
    public static final String SYSTEM_PREFIX = "system:";
    public static final String HIVECONF_PREFIX = "hiveconf:";
    public static final String HIVEVAR_PREFIX = "hivevar:";
    public static final String SET_COLUMN_NAME = "set";

    public static boolean getBoolean(String value) {
        if (value.equals("on") || value.equals("true")) {
            return true;
        }
        if (value.equals("off") || value.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(prefix + "'" + value + "' is not a boolean");
    }

    private void dumpOptions(Properties p) {
        SessionState ss = SessionState.get();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.put("silent", ss.getIsSilent() ? "on" : "off");
        for (Object object : p.keySet()) {
            String oneProp = (String)object;
            String oneValue = p.getProperty(oneProp);
            sortedMap.put(oneProp, oneValue);
        }
        for (String string : ss.getHiveVariables().keySet()) {
            sortedMap.put(HIVEVAR_PREFIX + string, ss.getHiveVariables().get(string));
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            ss.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (Map.Entry entry : this.mapToSortedMap(System.getenv()).entrySet()) {
            ss.out.println(ENV_PREFIX + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (Map.Entry entry : this.propertiesToSortedMap(System.getProperties()).entrySet()) {
            ss.out.println(SYSTEM_PREFIX + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    private void dumpOption(String s) {
        SessionState ss = SessionState.get();
        if (ss.getConf().get(s) != null) {
            ss.out.println(s + "=" + ss.getConf().get(s));
        } else if (ss.getHiveVariables().containsKey(s)) {
            ss.out.println(s + "=" + ss.getHiveVariables().get(s));
        } else {
            ss.out.println(s + " is undefined");
        }
    }

    @Override
    public void init() {
    }

    private CommandProcessorResponse setVariable(String varname, String varvalue) {
        SessionState ss = SessionState.get();
        if (varvalue.contains("\n")) {
            ss.err.println("Warning: Value had a \\n character in it.");
        }
        if (varname.startsWith(ENV_PREFIX)) {
            ss.err.println("env:* variables can not be set.");
            return new CommandProcessorResponse(1);
        }
        if (varname.startsWith(SYSTEM_PREFIX)) {
            String propName = varname.substring(SYSTEM_PREFIX.length());
            System.getProperties().setProperty(propName, new VariableSubstitution().substitute(ss.getConf(), varvalue));
            return new CommandProcessorResponse(0);
        }
        if (varname.startsWith(HIVECONF_PREFIX)) {
            String propName = varname.substring(HIVECONF_PREFIX.length());
            try {
                this.setConf(varname, propName, varvalue, false);
                return new CommandProcessorResponse(0);
            }
            catch (IllegalArgumentException e) {
                return new CommandProcessorResponse(1, e.getMessage(), "42000");
            }
        }
        if (varname.startsWith(HIVEVAR_PREFIX)) {
            String propName = varname.substring(HIVEVAR_PREFIX.length());
            ss.getHiveVariables().put(propName, new VariableSubstitution().substitute(ss.getConf(), varvalue));
            return new CommandProcessorResponse(0);
        }
        try {
            this.setConf(varname, varname, varvalue, true);
            return new CommandProcessorResponse(0);
        }
        catch (IllegalArgumentException e) {
            return new CommandProcessorResponse(1, e.getMessage(), "42000");
        }
    }

    private void setConf(String varname, String key, String varvalue, boolean register) throws IllegalArgumentException {
        HiveConf.ConfVars confVars;
        HiveConf conf = SessionState.get().getConf();
        String value = new VariableSubstitution().substitute(conf, varvalue);
        if (conf.getBoolVar(HiveConf.ConfVars.HIVECONFVALIDATION) && (confVars = HiveConf.getConfVars(key)) != null && !confVars.isType(value)) {
            StringBuilder message = new StringBuilder();
            message.append("'SET ").append(varname).append('=').append(varvalue);
            message.append("' FAILED because ");
            message.append(key).append(" expects an ");
            message.append(confVars.typeString()).append(" value.");
            throw new IllegalArgumentException(message.toString());
        }
        conf.verifyAndSet(key, value);
        if (register) {
            SessionState.get().getOverriddenConfigurations().put(key, value);
        }
        try {
            Hive.get(SessionState.get().getConf(), true);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    private SortedMap<String, String> propertiesToSortedMap(Properties p) {
        TreeMap<String, String> sortedPropMap = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            sortedPropMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return sortedPropMap;
    }

    private SortedMap<String, String> mapToSortedMap(Map<String, String> data) {
        TreeMap<String, String> sortedEnvMap = new TreeMap<String, String>();
        sortedEnvMap.putAll(data);
        return sortedEnvMap;
    }

    private CommandProcessorResponse getVariable(String varname) {
        SessionState ss = SessionState.get();
        if (varname.equals("silent")) {
            ss.out.println("silent=" + ss.getIsSilent());
            return new CommandProcessorResponse(0);
        }
        if (varname.startsWith(SYSTEM_PREFIX)) {
            String propName = varname.substring(SYSTEM_PREFIX.length());
            String result = System.getProperty(propName);
            if (result != null) {
                ss.out.println(SYSTEM_PREFIX + propName + "=" + result);
                return new CommandProcessorResponse(0);
            }
            ss.out.println(propName + " is undefined as a system property");
            return new CommandProcessorResponse(1);
        }
        if (varname.indexOf(ENV_PREFIX) == 0) {
            String var = varname.substring(ENV_PREFIX.length());
            if (System.getenv(var) != null) {
                ss.out.println(ENV_PREFIX + var + "=" + System.getenv(var));
                return new CommandProcessorResponse(0);
            }
            ss.out.println(varname + " is undefined as an environmental variable");
            return new CommandProcessorResponse(1);
        }
        if (varname.indexOf(HIVECONF_PREFIX) == 0) {
            String var = varname.substring(HIVECONF_PREFIX.length());
            if (ss.getConf().get(var) != null) {
                ss.out.println(HIVECONF_PREFIX + var + "=" + ss.getConf().get(var));
                return new CommandProcessorResponse(0);
            }
            ss.out.println(varname + " is undefined as a hive configuration variable");
            return new CommandProcessorResponse(1);
        }
        if (varname.indexOf(HIVEVAR_PREFIX) == 0) {
            String var = varname.substring(HIVEVAR_PREFIX.length());
            if (ss.getHiveVariables().get(var) != null) {
                ss.out.println(HIVEVAR_PREFIX + var + "=" + ss.getHiveVariables().get(var));
                return new CommandProcessorResponse(0);
            }
            ss.out.println(varname + " is undefined as a hive variable");
            return new CommandProcessorResponse(1);
        }
        this.dumpOption(varname);
        return new CommandProcessorResponse(0, null, null, this.getSchema());
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState ss = SessionState.get();
        Schema sch = this.getSchema();
        String nwcmd = command.trim();
        if (nwcmd.equals("")) {
            this.dumpOptions(ss.getConf().getChangedProperties());
            return new CommandProcessorResponse(0, null, null, sch);
        }
        if (nwcmd.equals("-v")) {
            this.dumpOptions(ss.getConf().getAllProperties());
            return new CommandProcessorResponse(0, null, null, sch);
        }
        String[] part = new String[2];
        int eqIndex = nwcmd.indexOf(61);
        if (nwcmd.contains("=")) {
            if (eqIndex == nwcmd.length() - 1) {
                part[0] = nwcmd.substring(0, nwcmd.length() - 1);
                part[1] = "";
            } else {
                part[0] = nwcmd.substring(0, eqIndex).trim();
                part[1] = nwcmd.substring(eqIndex + 1).trim();
            }
            if (part[0].equals("silent")) {
                ss.setIsSilent(SetProcessor.getBoolean(part[1]));
                return new CommandProcessorResponse(0);
            }
            return this.setVariable(part[0], part[1]);
        }
        return this.getVariable(nwcmd);
    }

    private Schema getSchema() {
        Schema sch = new Schema();
        FieldSchema tmpFieldSchema = new FieldSchema();
        tmpFieldSchema.setName(SET_COLUMN_NAME);
        tmpFieldSchema.setType("string");
        sch.putToProperties("serialization.null.format", "\\N");
        sch.addToFieldSchemas(tmpFieldSchema);
        return sch;
    }
}

