/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="percentile", value="_FUNC_(expr, pc) - Returns the percentile(s) of expr at pc (range: [0,1]).pc can be a double or double array")
public class UDAFPercentile
extends UDAF {
    public static final Log l4j = LogFactory.getLog(UDAFPercentile.class);

    private static void increment(State s, DoubleWritable o, double i) {
        DoubleWritable count;
        if (s.counts == null) {
            s.counts = new HashMap();
        }
        if ((count = (DoubleWritable)s.counts.get(o)) == null) {
            DoubleWritable key = new DoubleWritable();
            key.set(o.get());
            s.counts.put(key, new DoubleWritable(i));
        } else {
            count.set(count.get() + i);
        }
    }

    private static double getPercentile(List<Map.Entry<DoubleWritable, DoubleWritable>> entriesList, double position) {
        double higherKey;
        long lower = (long)Math.floor(position);
        long higher = (long)Math.ceil(position);
        int i = 0;
        while (entriesList.get(i).getValue().get() < (double)(lower + 1L)) {
            ++i;
        }
        double lowerKey = entriesList.get(i).getKey().get();
        if (higher == lower) {
            return lowerKey;
        }
        if (entriesList.get(i).getValue().get() < (double)(higher + 1L)) {
            ++i;
        }
        if ((higherKey = entriesList.get(i).getKey().get()) == lowerKey) {
            return lowerKey;
        }
        return ((double)higher - position) * lowerKey + (position - (double)lower) * higherKey;
    }

    public static class PercentileDoubleArrayEvaluator
    implements UDAFEvaluator {
        private final State state = new State();
        private List<DoubleWritable> results;

        @Override
        public void init() {
            if (this.state.counts != null) {
                this.state.counts.clear();
            }
        }

        public boolean iterate(DoubleWritable o, List<DoubleWritable> percentiles) {
            l4j.info((Object)("In iterate percentiles is " + (percentiles == null ? "" : "not ") + "null"));
            l4j.info((Object)("In iterate precentiles has " + (percentiles == null ? "null" : Integer.toString(percentiles.size())) + " items"));
            if (this.state.percentiles == null) {
                if (percentiles != null) {
                    for (int i = 0; i < percentiles.size(); ++i) {
                        if (!(percentiles.get(i).get() < 0.0) && !(percentiles.get(i).get() > 1.0)) continue;
                        throw new RuntimeException("Percentile value must be wihin the range of 0 to 1.");
                    }
                    this.state.percentiles = new ArrayList<DoubleWritable>(percentiles);
                } else {
                    this.state.percentiles = new ArrayList();
                }
            }
            if (o != null) {
                UDAFPercentile.increment(this.state, o, 1.0);
            }
            return true;
        }

        public State terminatePartial() {
            return this.state;
        }

        public boolean merge(State other) {
            if (other == null || other.counts == null || other.percentiles == null) {
                return true;
            }
            if (this.state.percentiles == null) {
                this.state.percentiles = new ArrayList(other.percentiles);
            }
            if (other.counts != null) {
                for (Map.Entry e : other.counts.entrySet()) {
                    UDAFPercentile.increment(this.state, (DoubleWritable)e.getKey(), ((DoubleWritable)e.getValue()).get());
                }
            }
            return true;
        }

        public List<DoubleWritable> terminate() {
            int i;
            if (this.state.counts == null || this.state.counts.size() == 0) {
                return null;
            }
            Set entries = this.state.counts.entrySet();
            ArrayList entriesList = new ArrayList(entries);
            Collections.sort(entriesList, new MyComparator());
            long total = 0L;
            for (int i2 = 0; i2 < entriesList.size(); ++i2) {
                DoubleWritable count = (DoubleWritable)((Map.Entry)entriesList.get(i2)).getValue();
                total = (long)((double)total + count.get());
                count.set(total);
            }
            long maxPosition = total - 1L;
            if (this.results == null) {
                this.results = new ArrayList<DoubleWritable>();
                for (i = 0; i < this.state.percentiles.size(); ++i) {
                    this.results.add(new DoubleWritable());
                }
            }
            for (i = 0; i < this.state.percentiles.size(); ++i) {
                double position = (double)maxPosition * ((DoubleWritable)this.state.percentiles.get(i)).get();
                this.results.get(i).set(UDAFPercentile.getPercentile(entriesList, position));
            }
            return this.results;
        }
    }

    public static class PercentileDoubleEvaluator
    implements UDAFEvaluator {
        private State state = new State();
        private DoubleWritable result;

        @Override
        public void init() {
            if (this.state.counts != null) {
                this.state.counts.clear();
            }
        }

        public boolean iterate(DoubleWritable o, Double percentile) {
            if (o == null && percentile == null) {
                return false;
            }
            if (this.state.percentiles == null) {
                if (percentile < 0.0 || percentile > 1.0) {
                    throw new RuntimeException("Percentile value must be wihin the range of 0 to 1.");
                }
                this.state.percentiles = new ArrayList(1);
                this.state.percentiles.add(new DoubleWritable(percentile));
            }
            if (o != null) {
                UDAFPercentile.increment(this.state, o, 1.0);
            }
            return true;
        }

        public State terminatePartial() {
            return this.state;
        }

        public boolean merge(State other) {
            if (other == null || other.counts == null || other.percentiles == null) {
                return false;
            }
            if (this.state.percentiles == null) {
                this.state.percentiles = new ArrayList(other.percentiles);
            }
            if (other.counts != null) {
                for (Map.Entry e : other.counts.entrySet()) {
                    UDAFPercentile.increment(this.state, (DoubleWritable)e.getKey(), ((DoubleWritable)e.getValue()).get());
                }
            }
            return true;
        }

        public DoubleWritable terminate() {
            if (this.state.counts == null || this.state.counts.size() == 0) {
                return null;
            }
            Set entries = this.state.counts.entrySet();
            ArrayList entriesList = new ArrayList(entries);
            Collections.sort(entriesList, new MyComparator());
            l4j.info((Object)("In terminate entriesList is " + (entriesList == null ? "" : "not ") + "null"));
            l4j.info((Object)("In terminate entriesList has " + (entriesList == null ? "null" : Integer.toString(entriesList.size())) + " items"));
            if (entriesList.size() == 0) {
                return new DoubleWritable(0.0);
            }
            long total = 0L;
            for (int i = 0; i < entriesList.size(); ++i) {
                DoubleWritable count = (DoubleWritable)((Map.Entry)entriesList.get(i)).getValue();
                total = (long)((double)total + count.get());
                count.set(total);
            }
            if (this.result == null) {
                this.result = new DoubleWritable();
            }
            long maxPosition = total - 1L;
            double position = (double)maxPosition * ((DoubleWritable)this.state.percentiles.get(0)).get();
            this.result.set(UDAFPercentile.getPercentile(entriesList, position));
            return this.result;
        }
    }

    public static class MyComparator
    implements Comparator<Map.Entry<DoubleWritable, DoubleWritable>> {
        @Override
        public int compare(Map.Entry<DoubleWritable, DoubleWritable> o1, Map.Entry<DoubleWritable, DoubleWritable> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    public static class State {
        private Map<DoubleWritable, DoubleWritable> counts;
        private List<DoubleWritable> percentiles;
    }
}

