/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.IntWritable;

@Description(name="power,pow", value="_FUNC_(x1, x2) - raise x1 to the power of x2", extended="Example:\n  > SELECT _FUNC_(2, 3) FROM src LIMIT 1;\n  8")
public class UDFPower
extends UDF {
    private final DoubleWritable resultDouble = new DoubleWritable();
    private final HiveDecimalWritable resultHiveDecimal = new HiveDecimalWritable();

    public DoubleWritable evaluate(DoubleWritable a, DoubleWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.resultDouble.set(Math.pow(a.get(), b.get()));
        return this.resultDouble;
    }

    public DoubleWritable evaluate(DoubleWritable a, IntWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.resultDouble.set(Math.pow(a.get(), b.get()));
        return this.resultDouble;
    }

    public HiveDecimalWritable evaluate(HiveDecimalWritable a, IntWritable b) {
        if (a == null || b == null) {
            return null;
        }
        try {
            this.resultHiveDecimal.set(a.getHiveDecimal().pow(b.get()));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return this.resultHiveDecimal;
    }
}

