/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.TaskExecutionException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.serde.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

@Description(name="blob_explode", value="_FUNC_(doc, blobSerDe, inputClazz, method, p1, p2, ..., pn)")
public class GenericUDTFBlobExplode
extends GenericUDTF {
    private static Log LOGGER = LogFactory.getLog(GenericUDTFBlobExplode.class);
    protected ObjectInspector[] inputOIs = null;
    protected final SimpleDateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected final Map<String, AccessibleObject> accessorCache = new HashMap<String, AccessibleObject>();

    @Override
    public void close() throws HiveException {
    }

    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length < 5) {
            throw new UDFArgumentException("blocb_explode() takes at least 5 arguments");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveObjectInspector)args[i]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING) continue;
            throw new UDFArgumentException("Parameter #" + i + " of blob_explode() must be a string.");
        }
        this.defaultDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.inputOIs = args;
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (int i = 4; i < args.length; ++i) {
            fieldNames.add("c" + (i - 4));
            fieldOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    public void process(Object[] o) throws HiveException {
        String doc = ((StringObjectInspector)this.inputOIs[0]).getPrimitiveJavaObject(o[0]);
        String serDeName = ((StringObjectInspector)this.inputOIs[1]).getPrimitiveJavaObject(o[1]);
        String inputClassName = ((StringObjectInspector)this.inputOIs[2]).getPrimitiveJavaObject(o[2]);
        String methodName = ((StringObjectInspector)this.inputOIs[3]).getPrimitiveJavaObject(o[3]);
        LOGGER.info((Object)("--------------- doc = " + doc));
        LOGGER.info((Object)("--------------- serDeName = " + serDeName));
        LOGGER.info((Object)("--------------- inputClassName = " + inputClassName));
        LOGGER.info((Object)("--------------- methodName = " + methodName));
        try {
            Method method;
            Object result;
            Class<?> inputClazz = Class.forName(inputClassName, true, JavaUtils.getClassLoader());
            Serializer serDe = (Serializer)Class.forName(serDeName, true, JavaUtils.getClassLoader()).newInstance();
            serDe.setClazz(inputClazz);
            Object data = serDe.deserializeFromString(doc);
            if (data != null && (result = (method = inputClazz.getMethod(methodName, new Class[0])).invoke(data, new Object[0])) != null) {
                if (Collection.class.isAssignableFrom(result.getClass())) {
                    Collection rows = (Collection)result;
                    for (Object row : rows) {
                        this.forwardRow(o, row);
                    }
                } else {
                    this.forwardRow(o, result);
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new TaskExecutionException("Input and/or output class names not found.", e);
        }
        catch (SecurityException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new TaskExecutionException("Security exception.", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new TaskExecutionException("No such method found in input class", e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new UDFArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new TaskExecutionException("Illegal Method access.", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new TaskExecutionException("Method invokation failed.", e);
        }
        catch (InstantiationException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new TaskExecutionException("Object instantiation failed.", e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new UDFArgumentException(e);
        }
        catch (ParseException e) {
            LOGGER.warn((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new UDFArgumentException(e);
        }
    }

    protected void forwardRow(Object[] o, Object row) throws HiveException {
        Object[] result = new Object[o.length - 4];
        for (int i = 4; i < o.length; ++i) {
            String property = ((StringObjectInspector)this.inputOIs[i]).getPrimitiveJavaObject(o[i]);
            result[i - 4] = this.format(property, this.getPropertyValue(row, property));
        }
        this.forward(result);
    }

    protected Object format(String property, Object value) throws HiveException {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return this.defaultDateFormat.format((Date)value);
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPropertyValue(Object o, String property) throws HiveException {
        AccessibleObject accessor;
        AccessibleObject accessibleObject = accessor = this.accessorCache.containsKey(property) ? this.accessorCache.get(property) : this.cacheAccessor(o, property);
        if (accessor == null) {
            throw new UDFArgumentException(String.format("No accessor found for property = %s", property));
        }
        boolean accessible = accessor.isAccessible();
        if (!accessible) {
            accessor.setAccessible(true);
        }
        try {
            if (accessor instanceof Method) {
                Object object = ((Method)accessor).invoke(o, new Object[0]);
                return object;
            }
            Object object = ((Field)accessor).get(o);
            return object;
        }
        catch (Exception e) {
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            if (!accessible) {
                accessor.setAccessible(false);
            }
        }
    }

    protected AccessibleObject cacheAccessor(Object o, String property) {
        AccessibleObject accessor = null;
        if ("toString".equals(property)) {
            try {
                accessor = o.getClass().getDeclaredMethod("toString", new Class[0]);
            }
            catch (Exception e) {}
        } else {
            try {
                accessor = o.getClass().getDeclaredMethod("get" + StringUtils.capitalize(property), new Class[0]);
            }
            catch (Exception mge) {
                try {
                    accessor = o.getClass().getDeclaredMethod("is" + StringUtils.capitalize(property), new Class[0]);
                }
                catch (Exception mie) {
                    try {
                        accessor = o.getClass().getDeclaredField(property);
                    }
                    catch (Exception fe) {
                        // empty catch block
                    }
                }
            }
        }
        this.accessorCache.put(property, accessor);
        return accessor;
    }

    public String toString() {
        return "blob_explode";
    }
}

