/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Column;
import javax.persistence.Temporal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFBlobExplode;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="dcs_explode", value="_FUNC_(doc, blobSerDe, inputClazz, method, p1, p2, ..., pn)")
public class GenericUDTFDcsExplode
extends GenericUDTFBlobExplode {
    private static Log LOGGER = LogFactory.getLog(GenericUDTFDcsExplode.class);
    protected final NumberFormat formatter = NumberFormat.getNumberInstance();
    protected final Map<String, Format> formatCache = new HashMap<String, Format>();

    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        this.formatter.setGroupingUsed(false);
        return super.initialize(args);
    }

    @Override
    protected AccessibleObject cacheAccessor(Object o, String property) {
        AccessibleObject accessor = null;
        Column c = null;
        Temporal t = null;
        char[] prop = property.toCharArray();
        if (prop[0] >= 'a' && prop[0] <= 'z') {
            prop[0] = (char)(prop[0] - 32);
        }
        try {
            Method m = o.getClass().getDeclaredMethod("get" + new String(prop), new Class[0]);
            accessor = m;
            c = m.getAnnotation(Column.class);
            t = m.getAnnotation(Temporal.class);
        }
        catch (Exception me) {
            // empty catch block
        }
        try {
            Field f = o.getClass().getDeclaredField(property);
            if (accessor == null) {
                accessor = f;
            }
            if (c == null) {
                c = f.getAnnotation(Column.class);
            }
            if (t == null) {
                t = f.getAnnotation(Temporal.class);
            }
        }
        catch (Exception fe) {
            // empty catch block
        }
        this.accessorCache.put(property, accessor);
        this.formatCache.put(property, new Format(c, t));
        return accessor;
    }

    @Override
    protected Object format(String property, Object value) throws HiveException {
        Format format = this.formatCache.get(property);
        if (value == null) {
            if (format != null && !format.nullable) {
                throw new UDFArgumentException(String.format("Null value found for not nullable property = %s", property));
            }
            return "";
        }
        Class<?> clazz = value.getClass();
        if (Date.class.isAssignableFrom(clazz)) {
            return format == null ? this.defaultDateFormat.format((Date)value) : format.df.format((Date)value);
        }
        if (Boolean.class.isAssignableFrom(clazz) || clazz.equals(Boolean.TYPE)) {
            return format == null ? value.toString() : (Boolean.TRUE.equals(value) ? "Y" : "N");
        }
        if (Character.class.isAssignableFrom(clazz) || clazz.equals(Character.TYPE)) {
            return format == null ? value.toString() : String.valueOf((Character)value);
        }
        if (Short.class.isAssignableFrom(clazz) || clazz.equals(Short.TYPE) || Byte.class.isAssignableFrom(clazz) || clazz.equals(Byte.TYPE) || Integer.class.isAssignableFrom(clazz) || clazz.equals(Integer.TYPE) || AtomicInteger.class.isAssignableFrom(clazz) || AtomicLong.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || clazz.equals(Long.TYPE) || AtomicLong.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz)) {
            return format == null ? value.toString() : this.formatLong(property, ((Number)value).longValue(), format.precision);
        }
        if (Float.class.isAssignableFrom(clazz) || clazz.equals(Float.TYPE) || Double.class.isAssignableFrom(clazz) || clazz.equals(Double.TYPE) || BigDecimal.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz)) {
            return format == null ? value.toString() : this.formatDouble(property, this.formatter, ((Number)value).doubleValue(), format.precision, format.scale);
        }
        String formattedValue = value.toString().replace("\t", " ");
        return format == null ? formattedValue : formattedValue.substring(0, Math.min(formattedValue.length(), format.length));
    }

    private String formatLong(String property, long l, int precision) throws HiveException {
        String str = String.valueOf(l);
        if (precision <= 0 || str.length() <= precision) {
            return str;
        }
        throw new UDFArgumentException(String.format("Property [%s] fails precision=[%d] test for value=[%s].", property, precision, str));
    }

    private String formatDouble(String property, NumberFormat formatter, double d, int precision, int scale) throws HiveException {
        if (precision <= 0 && scale <= 0) {
            return String.valueOf(d);
        }
        formatter.setMaximumFractionDigits(scale);
        String str = formatter.format(d);
        int correction = d < 0.0 ? (str.startsWith("-0.") ? 3 : 2) : (d > 0.0 ? (str.startsWith("0.") ? 2 : 1) : 0);
        if (str.length() <= precision + correction) {
            return str;
        }
        throw new UDFArgumentException(String.format("Property [%s] fails precision, scale=[%d, %d] test for value=[%s].", property, precision, scale, d));
    }

    @Override
    public String toString() {
        return "dcs_explode";
    }

    static class Format {
        public boolean nullable = true;
        public int length = 255;
        public int precision = 0;
        public int scale = 0;
        public SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

        public Format(Column c, Temporal t) {
            if (c != null) {
                this.nullable = c.nullable();
                this.length = c.length();
                this.precision = c.precision();
                this.scale = c.scale();
            }
            this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (t != null) {
                switch (t.value()) {
                    case DATE: {
                        this.df = new SimpleDateFormat("yyyy/MM/dd");
                        break;
                    }
                    case TIME: {
                        this.df = new SimpleDateFormat("HH:mm:ss");
                        break;
                    }
                    default: {
                        this.df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    }
                }
            }
        }
    }
}

