/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;

public class S3Util {
    public Map<String, SortedSet<String>> groupByAliasAndBucket(Set<String> s3Paths, Configuration conf, Map<String, ArrayList<String>> pathToAliase) throws IOException {
        HashMap<String, SortedSet<String>> gropuedPaths = new HashMap<String, SortedSet<String>>();
        for (String pathStr : s3Paths) {
            String key;
            Path path = new Path(pathStr);
            FileSystem fs = path.getFileSystem(conf);
            if (!(fs instanceof NativeS3FileSystem)) {
                gropuedPaths.put(pathStr, new TreeSet());
                ((SortedSet)gropuedPaths.get(pathStr)).add(pathStr);
                continue;
            }
            String alias = "";
            if (pathToAliase != null && pathToAliase.containsKey(pathStr)) {
                alias = pathToAliase.get(pathStr).get(0);
            }
            if (!gropuedPaths.containsKey(key = alias + this.bucketFromURL(pathStr))) {
                gropuedPaths.put(key, new TreeSet());
            }
            ((SortedSet)gropuedPaths.get(key)).add(pathStr);
        }
        return gropuedPaths;
    }

    public String bucketFromURL(String urlString) {
        try {
            URI uri = new URI(urlString);
            return uri.getHost();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getCommonPrefixes(SortedSet<String> paths) {
        HashMap<String, String> prefixes = new HashMap<String, String>();
        block0: for (String path : paths) {
            String bucket = this.bucketFromURL(path);
            if (bucket == null || bucket.length() == 0) {
                throw new RuntimeException("Invalid S3 path '" + path + "'");
            }
            String prefix = (String)prefixes.get(bucket);
            if (prefix == null) {
                prefixes.put(bucket, path);
                continue;
            }
            if (prefix.length() > path.length()) {
                prefix = prefix.substring(0, path.length());
                prefixes.put(bucket, prefix);
            }
            for (int mismatchIndex = 0; mismatchIndex < prefix.length(); ++mismatchIndex) {
                if (prefix.charAt(mismatchIndex) == path.charAt(mismatchIndex)) continue;
                prefix = prefix.substring(0, mismatchIndex);
                prefixes.put(bucket, prefix.substring(0, prefix.lastIndexOf("/")));
                continue block0;
            }
        }
        return new ArrayList<String>(prefixes.values());
    }

    public String keyFromS3Path(String urlString) {
        try {
            URI uri = new URI(urlString);
            String key = uri.getPath();
            if (key == null) {
                key = "";
            }
            if (key.startsWith("/")) {
                key = key.substring(1);
            }
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

