/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.hive.ql.exec.spark.SparkShuffler;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import scala.Tuple2;

public class SortByShuffler
implements SparkShuffler {
    private final boolean totalOrder;

    public SortByShuffler(boolean totalOrder) {
        this.totalOrder = totalOrder;
    }

    @Override
    public JavaPairRDD<HiveKey, Iterable<BytesWritable>> shuffle(JavaPairRDD<HiveKey, BytesWritable> input, int numPartitions) {
        JavaPairRDD rdd;
        if (this.totalOrder) {
            rdd = numPartitions > 0 ? input.sortByKey(true, numPartitions) : input.sortByKey(true);
        } else {
            HashPartitioner partitioner = new HashPartitioner(numPartitions);
            rdd = input.repartitionAndSortWithinPartitions((Partitioner)partitioner);
        }
        return rdd.mapPartitionsToPair((PairFlatMapFunction)new ShuffleFunction());
    }

    @Override
    public String getName() {
        return "SortBy";
    }

    private static class ShuffleFunction
    implements PairFlatMapFunction<Iterator<Tuple2<HiveKey, BytesWritable>>, HiveKey, Iterable<BytesWritable>> {
        private static final long serialVersionUID = 1L;

        private ShuffleFunction() {
        }

        public Iterable<Tuple2<HiveKey, Iterable<BytesWritable>>> call(final Iterator<Tuple2<HiveKey, BytesWritable>> it) throws Exception {
            final Iterator<Tuple2<HiveKey, Iterable<BytesWritable>>> resultIt = new Iterator<Tuple2<HiveKey, Iterable<BytesWritable>>>(){
                HiveKey curKey = null;
                List<BytesWritable> curValues = new ArrayList<BytesWritable>();

                @Override
                public boolean hasNext() {
                    return it.hasNext() || this.curKey != null;
                }

                @Override
                public Tuple2<HiveKey, Iterable<BytesWritable>> next() {
                    while (it.hasNext()) {
                        Tuple2 pair = (Tuple2)it.next();
                        if (this.curKey != null && !this.curKey.equals(pair._1())) {
                            HiveKey key = this.curKey;
                            List<BytesWritable> values = this.curValues;
                            this.curKey = (HiveKey)((Object)pair._1());
                            this.curValues = new ArrayList<BytesWritable>();
                            this.curValues.add((BytesWritable)pair._2());
                            return new Tuple2((Object)key, values);
                        }
                        this.curKey = (HiveKey)((Object)pair._1());
                        this.curValues.add((BytesWritable)pair._2());
                    }
                    if (this.curKey == null) {
                        throw new NoSuchElementException();
                    }
                    HiveKey key = this.curKey;
                    this.curKey = null;
                    return new Tuple2((Object)key, this.curValues);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return new Iterable<Tuple2<HiveKey, Iterable<BytesWritable>>>(){

                @Override
                public Iterator<Tuple2<HiveKey, Iterable<BytesWritable>>> iterator() {
                    return resultIt;
                }
            };
        }
    }
}

