/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import scala.Tuple2;

class HiveKVResultCache {
    private static final Log LOG = LogFactory.getLog(HiveKVResultCache.class);
    @VisibleForTesting
    static final int IN_MEMORY_NUM_ROWS = 1024;
    private ObjectPair<HiveKey, BytesWritable>[] writeBuffer = new ObjectPair[1024];
    private ObjectPair<HiveKey, BytesWritable>[] readBuffer = new ObjectPair[1024];
    private File parentFile;
    private File tmpFile;
    private int readCursor = 0;
    private int writeCursor = 0;
    private boolean readBufferUsed = false;
    private int rowsInReadBuffer = 0;
    private Input input;
    private Output output;
    private static Configuration conf;
    private static int bufferSize;

    public HiveKVResultCache() {
        for (int i = 0; i < 1024; ++i) {
            this.writeBuffer[i] = new ObjectPair();
            this.readBuffer[i] = new ObjectPair();
        }
    }

    private void switchBufferAndResetCursor() {
        ObjectPair<HiveKey, BytesWritable>[] tmp = this.readBuffer;
        this.rowsInReadBuffer = this.writeCursor;
        this.readBuffer = this.writeBuffer;
        this.readBufferUsed = true;
        this.readCursor = 0;
        this.writeBuffer = tmp;
        this.writeCursor = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupOutput() throws IOException {
        if (this.parentFile == null) {
            while (true) {
                this.parentFile = File.createTempFile("hive-resultcache", "");
                if (this.parentFile.delete() && this.parentFile.mkdir()) {
                    this.parentFile.deleteOnExit();
                    break;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Retry creating tmp result-cache directory...");
            }
        }
        if (this.tmpFile == null || this.input != null) {
            this.tmpFile = File.createTempFile("ResultCache", ".tmp", this.parentFile);
            LOG.info((Object)("ResultCache created temp file " + this.tmpFile.getAbsolutePath()));
            this.tmpFile.deleteOnExit();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.tmpFile);
            this.output = new Output(fos);
        }
        finally {
            if (this.output == null && fos != null) {
                fos.close();
            }
        }
    }

    private BytesWritable readValue(Input input) {
        return new BytesWritable(input.readBytes(input.readInt()));
    }

    private void writeValue(Output output, BytesWritable bytesWritable) {
        int size = bytesWritable.getLength();
        output.writeInt(size);
        output.writeBytes(bytesWritable.getBytes(), 0, size);
    }

    private HiveKey readHiveKey(Input input) {
        HiveKey hiveKey = new HiveKey(input.readBytes(input.readInt()), input.readInt());
        hiveKey.setDistKeyLength(input.readInt());
        return hiveKey;
    }

    private void writeHiveKey(Output output, HiveKey hiveKey) {
        int size = hiveKey.getLength();
        output.writeInt(size);
        output.writeBytes(hiveKey.getBytes(), 0, size);
        output.writeInt(hiveKey.hashCode());
        output.writeInt(hiveKey.getDistKeyLength());
    }

    public synchronized void add(HiveKey key, BytesWritable value) {
        if (this.writeCursor >= 1024) {
            if (!this.readBufferUsed) {
                this.switchBufferAndResetCursor();
            } else {
                try {
                    if (this.output == null) {
                        this.setupOutput();
                    }
                    for (int i = 0; i < 1024; ++i) {
                        ObjectPair<HiveKey, BytesWritable> pair = this.writeBuffer[i];
                        this.writeHiveKey(this.output, pair.getFirst());
                        this.writeValue(this.output, pair.getSecond());
                        pair.setFirst(null);
                        pair.setSecond(null);
                    }
                    this.writeCursor = 0;
                }
                catch (Exception e) {
                    this.clear();
                    throw new RuntimeException("Failed to spill rows to disk", e);
                }
            }
        }
        ObjectPair<HiveKey, BytesWritable> pair = this.writeBuffer[this.writeCursor++];
        pair.setFirst(key);
        pair.setSecond(value);
    }

    public synchronized void clear() {
        this.rowsInReadBuffer = 0;
        this.readCursor = 0;
        this.writeCursor = 0;
        this.readBufferUsed = false;
        if (this.parentFile != null) {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.input = null;
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.output = null;
            }
            try {
                FileUtil.fullyDelete((File)this.parentFile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.parentFile = null;
            this.tmpFile = null;
        }
    }

    public synchronized boolean hasNext() {
        return this.readBufferUsed || this.writeCursor > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Tuple2<HiveKey, BytesWritable> next() {
        Preconditions.checkState(this.hasNext());
        if (!this.readBufferUsed) {
            try {
                if (this.input == null && this.output != null) {
                    this.output.close();
                    this.output = null;
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(this.tmpFile);
                        this.input = new Input(fis, bufferSize);
                    }
                    finally {
                        if (this.input == null && fis != null) {
                            fis.close();
                        }
                    }
                }
                if (this.input != null) {
                    for (int i = 0; i < 1024; ++i) {
                        ObjectPair<HiveKey, BytesWritable> pair = this.readBuffer[i];
                        pair.setFirst(this.readHiveKey(this.input));
                        pair.setSecond(this.readValue(this.input));
                    }
                    if (this.input.eof()) {
                        this.input.close();
                        this.input = null;
                    }
                    this.rowsInReadBuffer = 1024;
                    this.readBufferUsed = true;
                    this.readCursor = 0;
                } else {
                    if (this.writeCursor == 1) {
                        ObjectPair<HiveKey, BytesWritable> pair = this.writeBuffer[0];
                        Tuple2 row = new Tuple2((Object)pair.getFirst(), (Object)pair.getSecond());
                        pair.setFirst(null);
                        pair.setSecond(null);
                        this.writeCursor = 0;
                        return row;
                    }
                    this.switchBufferAndResetCursor();
                }
            }
            catch (Exception e) {
                this.clear();
                throw new RuntimeException("Failed to load rows from disk", e);
            }
        }
        ObjectPair<HiveKey, BytesWritable> pair = this.readBuffer[this.readCursor];
        Tuple2 row = new Tuple2((Object)pair.getFirst(), (Object)pair.getSecond());
        pair.setFirst(null);
        pair.setSecond(null);
        if (++this.readCursor >= this.rowsInReadBuffer) {
            this.readBufferUsed = false;
            this.rowsInReadBuffer = 0;
            this.readCursor = 0;
        }
        return row;
    }

    static {
        SessionState ss = SessionState.get();
        conf = ss != null ? ss.getConf() : new Configuration();
        bufferSize = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_KRYO_BUFFER_SIZE);
    }
}

