/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;

public class Context {
    private boolean isHDFSCleanup;
    private Path resFile;
    private Path resDir;
    private FileSystem resFs;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.Context");
    private Path[] resDirPaths;
    private int resDirFilesNum;
    boolean initialized;
    String originalTracker = null;
    private final Map<String, ContentSummary> pathToCS = new ConcurrentHashMap<String, ContentSummary>();
    private Path nonLocalScratchPath;
    private boolean fNonLocalScratchDirUsed = false;
    private final String localScratchDir;
    private final String scratchDirPermission;
    private final Map<String, Path> fsScratchDirs = new HashMap<String, Path>();
    private final Configuration conf;
    protected int pathid = 10000;
    protected boolean explain = false;
    protected String cboInfo;
    protected boolean cboSucceeded;
    protected boolean explainLogical = false;
    protected String cmd = "";
    protected int tryCount = 0;
    private TokenRewriteStream tokenRewriteStream;
    private String executionId;
    protected List<HiveLock> hiveLocks;
    protected HiveLockManager hiveLockMgr;
    protected HiveTxnManager hiveTxnManager;
    private AcidUtils.Operation acidOperation = AcidUtils.Operation.NOT_ACID;
    private boolean needLockMgr;
    private final Map<LoadTableDesc, WriteEntity> loadTableOutputMap = new HashMap<LoadTableDesc, WriteEntity>();
    private final Map<WriteEntity, List<HiveLockObj>> outputLockObjects = new HashMap<WriteEntity, List<HiveLockObj>>();
    private final String stagingDir;
    private static final String MR_PREFIX = "-mr-";
    private static final String EXT_PREFIX = "-ext-";
    private static final String LOCAL_PREFIX = "-local-";

    public Context(Configuration conf) throws IOException {
        this(conf, Context.generateExecutionId());
    }

    public Context(Configuration conf, String executionId) {
        this.conf = conf;
        this.executionId = executionId;
        this.nonLocalScratchPath = new Path(SessionState.getHDFSSessionPath(conf), executionId);
        this.localScratchDir = new Path(SessionState.getLocalSessionPath(conf), executionId).toUri().getPath();
        this.scratchDirPermission = HiveConf.getVar(conf, HiveConf.ConfVars.SCRATCHDIRPERMISSION);
        this.stagingDir = HiveConf.getVar(conf, HiveConf.ConfVars.STAGINGDIR);
    }

    public void changeDFSScratchDir(String newScratchDir) {
        if (this.fNonLocalScratchDirUsed) {
            throw new RuntimeException("Configured scratchdir already in use");
        }
        this.nonLocalScratchPath = new Path(newScratchDir + "_" + this.executionId);
        LOG.info((Object)("INSERT/CTAS query optimization: scratchdir changed to '" + this.nonLocalScratchPath + "'"));
    }

    private Path getNonLocalScratchDir() {
        if (!this.fNonLocalScratchDirUsed) {
            this.fNonLocalScratchDirUsed = true;
        }
        return this.nonLocalScratchPath;
    }

    public Map<LoadTableDesc, WriteEntity> getLoadTableOutputMap() {
        return this.loadTableOutputMap;
    }

    public Map<WriteEntity, List<HiveLockObj>> getOutputLockObjects() {
        return this.outputLockObjects;
    }

    public void setExplain(boolean value) {
        this.explain = value;
    }

    public boolean getExplain() {
        return this.explain;
    }

    public boolean getExplainLogical() {
        return this.explainLogical;
    }

    public void setExplainLogical(boolean explainLogical) {
        this.explainLogical = explainLogical;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getCmd() {
        return this.cmd;
    }

    private Path getStagingDir(Path inputPath, boolean mkdir) {
        FileSystem fs;
        URI inputPathUri = inputPath.toUri();
        String inputPathName = inputPathUri.getPath();
        String fileSystem = inputPathUri.getScheme() + ":" + inputPathUri.getAuthority();
        try {
            fs = inputPath.getFileSystem(this.conf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting FileSystem for " + inputPath + ": " + e, e);
        }
        String stagingPathName = inputPathName.indexOf(this.stagingDir) == -1 ? new Path(inputPathName, this.stagingDir).toString() : inputPathName.substring(0, inputPathName.indexOf(this.stagingDir) + this.stagingDir.length());
        String key = fileSystem + "-" + stagingPathName + "-" + TaskRunner.getTaskRunnerID();
        Path dir = this.fsScratchDirs.get(key);
        if (dir == null) {
            dir = fs.makeQualified(new Path(stagingPathName + "_" + this.executionId + "-" + TaskRunner.getTaskRunnerID()));
            LOG.debug((Object)("Created staging dir = " + dir + " for path = " + inputPath));
            if (mkdir) {
                try {
                    if (!FileUtils.mkdir(fs, dir, true, this.conf)) {
                        throw new IllegalStateException("Cannot create staging directory  '" + dir.toString() + "'");
                    }
                    if (this.isHDFSCleanup) {
                        fs.deleteOnExit(dir);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot create staging directory '" + dir.toString() + "': " + e.getMessage(), e);
                }
            }
            this.fsScratchDirs.put(key, dir);
        }
        return dir;
    }

    private Path getScratchDir(String scheme, String authority, boolean mkdir, String scratchDir) {
        String fileSystem = scheme + ":" + authority;
        Path dir = this.fsScratchDirs.get(fileSystem + "-" + TaskRunner.getTaskRunnerID());
        if (dir == null) {
            Path dirPath = new Path(scheme, authority, scratchDir + "-" + TaskRunner.getTaskRunnerID());
            if (mkdir) {
                try {
                    FileSystem fs = dirPath.getFileSystem(this.conf);
                    dirPath = new Path(fs.makeQualified(dirPath).toString());
                    FsPermission fsPermission = new FsPermission(this.scratchDirPermission);
                    if (!fs.mkdirs(dirPath, fsPermission)) {
                        throw new RuntimeException("Cannot make directory: " + dirPath.toString());
                    }
                    if (this.isHDFSCleanup) {
                        fs.deleteOnExit(dirPath);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            dir = dirPath;
            this.fsScratchDirs.put(fileSystem + "-" + TaskRunner.getTaskRunnerID(), dir);
        }
        return dir;
    }

    public Path getLocalScratchDir(boolean mkdir) {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
            URI uri = fs.getUri();
            return this.getScratchDir(uri.getScheme(), uri.getAuthority(), mkdir, this.localScratchDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getMRScratchDir() {
        if (this.isLocalOnlyExecutionMode()) {
            return this.getLocalScratchDir(!this.explain);
        }
        try {
            Path dir = FileUtils.makeQualified(this.getNonLocalScratchDir(), this.conf);
            URI uri = dir.toUri();
            Path newScratchDir = this.getScratchDir(uri.getScheme(), uri.getAuthority(), !this.explain, uri.getPath());
            LOG.info((Object)("New scratch dir is " + newScratchDir));
            return newScratchDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error while making MR scratch directory - check filesystem config (" + e.getCause() + ")", e);
        }
    }

    private Path getExternalScratchDir(URI extURI) {
        return this.getStagingDir(new Path(extURI.getScheme(), extURI.getAuthority(), extURI.getPath()), !this.explain);
    }

    public void removeScratchDir() {
        for (Map.Entry<String, Path> entry : this.fsScratchDirs.entrySet()) {
            try {
                Path p = entry.getValue();
                p.getFileSystem(this.conf).delete(p, true);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error Removing Scratch: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        this.fsScratchDirs.clear();
    }

    private String nextPathId() {
        return Integer.toString(this.pathid++);
    }

    public boolean isMRTmpFileURI(String uriStr) {
        return uriStr.indexOf(this.executionId) != -1 && uriStr.indexOf(MR_PREFIX) != -1;
    }

    public Path getMRTmpPath(URI uri) {
        return new Path(this.getStagingDir(new Path(uri), !this.explain), MR_PREFIX + this.nextPathId());
    }

    public Path getMRTmpPath() {
        return new Path(this.getMRScratchDir(), MR_PREFIX + this.nextPathId());
    }

    public Path getLocalTmpPath() {
        return new Path(this.getLocalScratchDir(true), LOCAL_PREFIX + this.nextPathId());
    }

    public Path getExternalTmpPath(Path path) {
        URI extURI = path.toUri();
        if (extURI.getScheme().equals("viewfs")) {
            return this.getExtTmpPathRelTo(path.getParent());
        }
        return new Path(this.getExternalScratchDir(extURI), EXT_PREFIX + this.nextPathId());
    }

    public Path getExtTmpPathRelTo(Path path) {
        return new Path(this.getStagingDir(path, !this.explain), EXT_PREFIX + this.nextPathId());
    }

    public Path getResFile() {
        return this.resFile;
    }

    public void setResFile(Path resFile) {
        this.resFile = resFile;
        this.resDir = null;
        this.resDirPaths = null;
        this.resDirFilesNum = 0;
    }

    public Path getResDir() {
        return this.resDir;
    }

    public void setResDir(Path resDir) {
        this.resDir = resDir;
        this.resFile = null;
        this.resDirFilesNum = 0;
        this.resDirPaths = null;
    }

    public void clear() throws IOException {
        FileSystem fs;
        if (this.resDir != null) {
            try {
                fs = this.resDir.getFileSystem(this.conf);
                if (fs.exists(this.resDir)) {
                    fs.delete(this.resDir, true);
                }
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        if (this.resFile != null) {
            try {
                fs = this.resFile.getFileSystem(this.conf);
                if (fs.exists(this.resFile)) {
                    fs.delete(this.resFile, false);
                }
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        this.removeScratchDir();
        this.originalTracker = null;
        this.setNeedLockMgr(false);
    }

    public DataInput getStream() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                if (this.resFile == null && this.resDir == null) {
                    return null;
                }
                if (this.resFile != null) {
                    return this.resFile.getFileSystem(this.conf).open(this.resFile);
                }
                this.resFs = this.resDir.getFileSystem(this.conf);
                FileStatus status = this.resFs.getFileStatus(this.resDir);
                assert (status.isDir());
                FileStatus[] resDirFS = this.resFs.globStatus(new Path(this.resDir + "/*"), FileUtils.HIDDEN_FILES_PATH_FILTER);
                this.resDirPaths = new Path[resDirFS.length];
                int pos = 0;
                for (FileStatus resFS : resDirFS) {
                    if (resFS.isDir()) continue;
                    this.resDirPaths[pos++] = resFS.getPath();
                }
                if (pos == 0) {
                    return null;
                }
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
            return this.getNextStream();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
    }

    private DataInput getNextStream() {
        try {
            if (this.resDir != null && this.resDirFilesNum < this.resDirPaths.length && this.resDirPaths[this.resDirFilesNum] != null) {
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        return null;
    }

    public void resetStream() {
        if (this.initialized) {
            this.resDirFilesNum = 0;
            this.initialized = false;
        }
    }

    private static boolean strEquals(String str1, String str2) {
        return StringUtils.equals(str1, str2);
    }

    public void setTokenRewriteStream(TokenRewriteStream tokenRewriteStream) {
        assert (this.tokenRewriteStream == null);
        this.tokenRewriteStream = tokenRewriteStream;
    }

    public TokenRewriteStream getTokenRewriteStream() {
        return this.tokenRewriteStream;
    }

    public static String generateExecutionId() {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS");
        String executionId = "hive_" + format.format(new Date()) + "_" + Math.abs(rand.nextLong());
        return executionId;
    }

    public boolean isLocalOnlyExecutionMode() {
        if (HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
            return false;
        }
        return ShimLoader.getHadoopShims().isLocalMode(this.conf);
    }

    public List<HiveLock> getHiveLocks() {
        return this.hiveLocks;
    }

    public void setHiveLocks(List<HiveLock> hiveLocks) {
        this.hiveLocks = hiveLocks;
    }

    public HiveTxnManager getHiveTxnManager() {
        return this.hiveTxnManager;
    }

    public void setHiveTxnManager(HiveTxnManager txnMgr) {
        this.hiveTxnManager = txnMgr;
    }

    public void setOriginalTracker(String originalTracker) {
        this.originalTracker = originalTracker;
    }

    public void restoreOriginalTracker() {
        if (this.originalTracker != null) {
            ShimLoader.getHadoopShims().setJobLauncherRpcAddress(this.conf, this.originalTracker);
            this.originalTracker = null;
        }
    }

    public void addCS(String path, ContentSummary cs) {
        this.pathToCS.put(path, cs);
    }

    public ContentSummary getCS(Path path) {
        return this.getCS(path.toString());
    }

    public ContentSummary getCS(String path) {
        return this.pathToCS.get(path);
    }

    public Map<String, ContentSummary> getPathToCS() {
        return this.pathToCS;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public boolean isHDFSCleanup() {
        return this.isHDFSCleanup;
    }

    public void setHDFSCleanup(boolean isHDFSCleanup) {
        this.isHDFSCleanup = isHDFSCleanup;
    }

    public boolean isNeedLockMgr() {
        return this.needLockMgr;
    }

    public void setNeedLockMgr(boolean needLockMgr) {
        this.needLockMgr = needLockMgr;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public void setAcidOperation(AcidUtils.Operation op) {
        this.acidOperation = op;
    }

    public AcidUtils.Operation getAcidOperation() {
        return this.acidOperation;
    }

    public String getCboInfo() {
        return this.cboInfo;
    }

    public void setCboInfo(String cboInfo) {
        this.cboInfo = cboInfo;
    }

    public boolean isCboSucceeded() {
        return this.cboSucceeded;
    }

    public void setCboSucceeded(boolean cboSucceeded) {
        this.cboSucceeded = cboSucceeded;
    }
}

