/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.FileFormatException;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.IndexUpdater;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.mapred.InputFormat;

public class LoadSemanticAnalyzer
extends BaseSemanticAnalyzer {
    public LoadSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    public static FileStatus[] matchFilesOrDir(FileSystem fs, Path path) throws IOException {
        FileStatus[] srcs = fs.globStatus(path, new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return name.equals("_metadata") ? true : !name.startsWith("_") && !name.startsWith(".");
            }
        });
        if (srcs != null && srcs.length == 1 && srcs[0].isDir()) {
            srcs = fs.listStatus(srcs[0].getPath(), new PathFilter(){

                public boolean accept(Path p) {
                    String name = p.getName();
                    return !name.startsWith("_") && !name.startsWith(".");
                }
            });
        }
        return srcs;
    }

    private URI initializeFromURI(String fromPath, boolean isLocal) throws IOException, URISyntaxException {
        URI defaultURI;
        URI fromURI = new Path(fromPath).toUri();
        String fromScheme = fromURI.getScheme();
        String fromAuthority = fromURI.getAuthority();
        String path = fromURI.getPath();
        if (!path.startsWith("/")) {
            path = isLocal ? URIUtil.decode((String)new Path(System.getProperty("user.dir"), fromPath).toUri().toString()) : new Path(new Path("/user/" + System.getProperty("user.name")), path).toString();
        }
        if (StringUtils.isEmpty(fromScheme)) {
            if (isLocal) {
                fromScheme = "file";
            } else {
                defaultURI = FileSystem.get((Configuration)this.conf).getUri();
                fromScheme = defaultURI.getScheme();
                fromAuthority = defaultURI.getAuthority();
            }
        }
        if (!fromScheme.equals("file") && StringUtils.isEmpty(fromAuthority)) {
            defaultURI = FileSystem.get((Configuration)this.conf).getUri();
            fromAuthority = defaultURI.getAuthority();
        }
        this.LOG.debug((Object)(fromScheme + "@" + fromAuthority + "@" + path));
        return new URI(fromScheme, fromAuthority, path, null, null);
    }

    private void applyConstraints(URI fromURI, URI toURI, Tree ast, boolean isLocal) throws SemanticException {
        if (isLocal && !fromURI.getScheme().equals("file")) {
            throw new SemanticException(ErrorMsg.ILLEGAL_PATH.getMsg(ast, "Source file system should be \"file\" if \"local\" is specified"));
        }
        try {
            FileStatus[] srcs = LoadSemanticAnalyzer.matchFilesOrDir(FileSystem.get((URI)fromURI, (Configuration)this.conf), new Path(fromURI));
            if (srcs == null || srcs.length == 0) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "No files matching path " + fromURI));
            }
            for (FileStatus oneSrc : srcs) {
                if (!oneSrc.isDir()) continue;
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "source contains directory: " + oneSrc.getPath().toString()));
            }
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast), e);
        }
        if (!(isLocal || StringUtils.equals(fromURI.getScheme(), toURI.getScheme()) && StringUtils.equals(fromURI.getAuthority(), toURI.getAuthority()))) {
            String reason = "Move from: " + fromURI.toString() + " to: " + toURI.toString() + " is not valid. " + "Please check that values for params \"default.fs.name\" and " + "\"hive.metastore.warehouse.dir\" do not conflict.";
            throw new SemanticException(ErrorMsg.ILLEGAL_PATH.getMsg(ast, reason));
        }
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        URI fromURI;
        boolean isLocal = false;
        boolean isOverWrite = false;
        Tree fromTree = ast.getChild(0);
        Tree tableTree = ast.getChild(1);
        if (ast.getChildCount() == 4) {
            isLocal = true;
            isOverWrite = true;
        }
        if (ast.getChildCount() == 3) {
            if (ast.getChild(2).getText().toLowerCase().equals("local")) {
                isLocal = true;
            } else {
                isOverWrite = true;
            }
        }
        try {
            String fromPath = LoadSemanticAnalyzer.stripQuotes(fromTree.getText());
            fromURI = this.initializeFromURI(fromPath, isLocal);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(fromTree, e.getMessage()), e);
        }
        catch (URISyntaxException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(fromTree, e.getMessage()), e);
        }
        BaseSemanticAnalyzer.TableSpec ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, (ASTNode)tableTree);
        if (ts.tableHandle.isOffline()) {
            throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg(":Table " + ts.tableName));
        }
        if (ts.tableHandle.isView()) {
            throw new SemanticException(ErrorMsg.DML_AGAINST_VIEW.getMsg());
        }
        if (ts.tableHandle.isNonNative()) {
            throw new SemanticException(ErrorMsg.LOAD_INTO_NON_NATIVE.getMsg());
        }
        if (ts.tableHandle.isStoredAsSubDirectories()) {
            throw new SemanticException(ErrorMsg.LOAD_INTO_STORED_AS_DIR.getMsg());
        }
        URI toURI = (ts.partHandle != null ? ts.partHandle.getDataLocation() : ts.tableHandle.getDataLocation()).toUri();
        List<FieldSchema> parts = ts.tableHandle.getPartitionKeys();
        if (parts != null && parts.size() > 0 && (ts.partSpec == null || ts.partSpec.size() == 0)) {
            throw new SemanticException(ErrorMsg.NEED_PARTITION_ERROR.getMsg());
        }
        this.applyConstraints(fromURI, toURI, fromTree, isLocal);
        if (TableType.MANAGED_TABLE.equals((Object)ts.tableHandle.getTableType())) {
            this.ensureFileFormatsMatch(ts, fromURI);
        }
        this.inputs.add(this.toReadEntity(new Path(fromURI)));
        Task<MoveWork> rTask = null;
        boolean preservePartitionSpecs = false;
        Map<String, String> partSpec = ts.getPartSpec();
        if (partSpec == null) {
            partSpec = new LinkedHashMap<String, String>();
            this.outputs.add(new WriteEntity(ts.tableHandle, isOverWrite ? WriteEntity.WriteType.INSERT_OVERWRITE : WriteEntity.WriteType.INSERT));
        } else {
            try {
                Partition part = Hive.get().getPartition(ts.tableHandle, partSpec, false);
                if (part != null) {
                    if (part.isOffline()) {
                        throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg(ts.tableName + ":" + part.getName()));
                    }
                    if (isOverWrite) {
                        this.outputs.add(new WriteEntity(part, WriteEntity.WriteType.INSERT_OVERWRITE));
                    } else {
                        this.outputs.add(new WriteEntity(part, WriteEntity.WriteType.INSERT));
                        preservePartitionSpecs = true;
                    }
                } else {
                    this.outputs.add(new WriteEntity(ts.tableHandle, isOverWrite ? WriteEntity.WriteType.INSERT_OVERWRITE : WriteEntity.WriteType.INSERT));
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
        }
        LoadTableDesc loadTableWork = new LoadTableDesc(new Path(fromURI), Utilities.getTableDesc(ts.tableHandle), partSpec, isOverWrite);
        if (preservePartitionSpecs) {
            loadTableWork.setInheritTableSpecs(false);
        }
        Task<MoveWork> childTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, true, isLocal), this.conf, new Task[0]);
        if (rTask != null) {
            rTask.addDependentTask(childTask);
        } else {
            rTask = childTask;
        }
        this.rootTasks.add(rTask);
        Task<StatsWork> statTask = null;
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            StatsWork statDesc = new StatsWork(loadTableWork);
            statDesc.setNoStatsAggregator(true);
            statDesc.setClearAggregatorStats(true);
            statDesc.setStatsReliable(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
            statTask = TaskFactory.get(statDesc, this.conf, new Task[0]);
        }
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEINDEXAUTOUPDATE)) {
            IndexUpdater indexUpdater = new IndexUpdater(loadTableWork, this.getInputs(), (Configuration)this.conf);
            try {
                List<Task<? extends Serializable>> indexUpdateTasks = indexUpdater.generateUpdateTasks();
                for (Task<? extends Serializable> updateTask : indexUpdateTasks) {
                    childTask.addDependentTask(updateTask);
                    if (statTask == null) continue;
                    updateTask.addDependentTask(statTask);
                }
            }
            catch (HiveException e) {
                this.console.printInfo("WARNING: could not auto-update stale indexes, indexes are not out of sync");
            }
        } else if (statTask != null) {
            childTask.addDependentTask(statTask);
        }
    }

    private void ensureFileFormatsMatch(BaseSemanticAnalyzer.TableSpec ts, URI fromURI) throws SemanticException {
        Class<? extends InputFormat> destInputFormat = ts.tableHandle.getInputFormatClass();
        if (OrcInputFormat.class.equals(destInputFormat)) {
            Path inputFilePath = new Path(fromURI);
            try {
                FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)this.conf);
                OrcFile.createReader(fs, inputFilePath);
            }
            catch (FileFormatException e) {
                throw new SemanticException(ErrorMsg.INVALID_FILE_FORMAT_IN_LOAD.getMsg("Destination table is stored as ORC but the file being loaded is not a valid ORC file."));
            }
            catch (IOException e) {
                throw new SemanticException("Unable to load data to destination table. Error: " + e.getMessage());
            }
        }
    }
}

