/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joshelser.dropwizard.metrics.hadoop.HadoopMetrics2Reporter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricVariableRatioGauge;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodahaleMetrics
implements Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodahaleMetrics.class);
    private static final FileAttribute<Set<PosixFilePermission>> FILE_ATTRS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
    private static final FileAttribute<Set<PosixFilePermission>> DIR_ATTRS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));
    private static final String JSON_REPORTER_THREAD_NAME = "json-metric-reporter";
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final Lock timersLock = new ReentrantLock();
    private final Lock countersLock = new ReentrantLock();
    private final Lock gaugesLock = new ReentrantLock();
    private final Lock metersLock = new ReentrantLock();
    private LoadingCache<String, Timer> timers;
    private LoadingCache<String, Counter> counters;
    private LoadingCache<String, Meter> meters;
    private ConcurrentHashMap<String, Gauge> gauges;
    private HiveConf conf;
    private final Set<Closeable> reporters = new HashSet<Closeable>();
    private final ThreadLocal<HashMap<String, CodahaleMetricsScope>> threadLocalScopes = new ThreadLocal<HashMap<String, CodahaleMetricsScope>>(){

        @Override
        protected HashMap<String, CodahaleMetricsScope> initialValue() {
            return new HashMap<String, CodahaleMetricsScope>();
        }
    };

    public CodahaleMetrics(HiveConf conf) {
        this.conf = conf;
        this.timers = CacheBuilder.newBuilder().build(new CacheLoader<String, Timer>(){

            @Override
            public Timer load(String key) {
                Timer timer = new Timer((Reservoir)new ExponentiallyDecayingReservoir());
                CodahaleMetrics.this.metricRegistry.register(key, (Metric)timer);
                return timer;
            }
        });
        this.counters = CacheBuilder.newBuilder().build(new CacheLoader<String, Counter>(){

            @Override
            public Counter load(String key) {
                Counter counter = new Counter();
                CodahaleMetrics.this.metricRegistry.register(key, (Metric)counter);
                return counter;
            }
        });
        this.meters = CacheBuilder.newBuilder().build(new CacheLoader<String, Meter>(){

            @Override
            public Meter load(String key) {
                Meter meter = new Meter();
                CodahaleMetrics.this.metricRegistry.register(key, (Metric)meter);
                return meter;
            }
        });
        this.gauges = new ConcurrentHashMap();
        this.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet());
        this.registerAll("buffers", (MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet());
        this.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet());
        this.registerAll("classLoading", (MetricSet)new ClassLoadingGaugeSet());
        HashSet<MetricsReporting> finalReporterList = new HashSet<MetricsReporting>();
        ArrayList<String> metricsReporterNames = Lists.newArrayList(Splitter.on(",").trimResults().omitEmptyStrings().split(conf.getVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER)));
        if (metricsReporterNames != null) {
            for (String metricsReportingName : metricsReporterNames) {
                try {
                    MetricsReporting reporter = MetricsReporting.valueOf(metricsReportingName.trim().toUpperCase());
                    finalReporterList.add(reporter);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Metrics reporter skipped due to invalid configured reporter: " + metricsReportingName);
                }
            }
        }
        this.initReporting(finalReporterList);
    }

    @Override
    public void close() throws Exception {
        if (this.reporters != null) {
            for (Closeable closeable : this.reporters) {
                closeable.close();
            }
        }
        for (Map.Entry entry : this.metricRegistry.getMetrics().entrySet()) {
            this.metricRegistry.remove((String)entry.getKey());
        }
        this.timers.invalidateAll();
        this.counters.invalidateAll();
        this.meters.invalidateAll();
    }

    @Override
    public void startStoredScope(String name) {
        if (this.threadLocalScopes.get().containsKey(name)) {
            this.threadLocalScopes.get().get(name).open();
        } else {
            this.threadLocalScopes.get().put(name, new CodahaleMetricsScope(name));
        }
    }

    @Override
    public void endStoredScope(String name) {
        if (this.threadLocalScopes.get().containsKey(name)) {
            this.threadLocalScopes.get().get(name).close();
            this.threadLocalScopes.get().remove(name);
        }
    }

    public MetricsScope getStoredScope(String name) throws IllegalArgumentException {
        if (this.threadLocalScopes.get().containsKey(name)) {
            return this.threadLocalScopes.get().get(name);
        }
        throw new IllegalArgumentException("No metrics scope named " + name);
    }

    @Override
    public MetricsScope createScope(String name) {
        return new CodahaleMetricsScope(name);
    }

    @Override
    public void endScope(MetricsScope scope) {
        ((CodahaleMetricsScope)scope).close();
    }

    @Override
    public Long incrementCounter(String name) {
        return this.incrementCounter(name, 1L);
    }

    @Override
    public Long incrementCounter(String name, long increment) {
        String key = name;
        try {
            this.countersLock.lock();
            this.counters.get(key).inc(increment);
            Long l = this.counters.get(key).getCount();
            return l;
        }
        catch (ExecutionException ee) {
            throw new IllegalStateException("Error retrieving counter from the metric registry ", ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    @Override
    public Long decrementCounter(String name) {
        return this.decrementCounter(name, 1L);
    }

    @Override
    public Long decrementCounter(String name, long decrement) {
        String key = name;
        try {
            this.countersLock.lock();
            this.counters.get(key).dec(decrement);
            Long l = this.counters.get(key).getCount();
            return l;
        }
        catch (ExecutionException ee) {
            throw new IllegalStateException("Error retrieving counter from the metric registry ", ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    @Override
    public void addGauge(String name, final MetricsVariable variable) {
        Gauge gauge = new Gauge(){

            public Object getValue() {
                return variable.getValue();
            }
        };
        this.addGaugeInternal(name, gauge);
    }

    @Override
    public void addRatio(String name, MetricsVariable<Integer> numerator, MetricsVariable<Integer> denominator) {
        Preconditions.checkArgument(numerator != null, "Numerator must not be null");
        Preconditions.checkArgument(denominator != null, "Denominator must not be null");
        MetricVariableRatioGauge gauge = new MetricVariableRatioGauge(numerator, denominator);
        this.addGaugeInternal(name, (Gauge)gauge);
    }

    private void addGaugeInternal(String name, Gauge gauge) {
        try {
            this.gaugesLock.lock();
            this.gauges.put(name, gauge);
            if (this.metricRegistry.getGauges().containsKey(name)) {
                LOGGER.warn("A Gauge with name [" + name + "] already exists.  The old gauge will be overwritten, but this is not recommended");
                this.metricRegistry.remove(name);
            }
            this.metricRegistry.register(name, (Metric)gauge);
        }
        finally {
            this.gaugesLock.unlock();
        }
    }

    @Override
    public void markMeter(String name) {
        String key = name;
        try {
            this.metersLock.lock();
            Meter meter = this.meters.get(name);
            meter.mark();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error retrieving meter " + name + " from the metric registry ", e);
        }
        finally {
            this.metersLock.unlock();
        }
    }

    private Timer getTimer(String name) {
        String key = name;
        try {
            Timer timer;
            this.timersLock.lock();
            Timer timer2 = timer = this.timers.get(key);
            return timer2;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error retrieving timer " + name + " from the metric registry ", e);
        }
        finally {
            this.timersLock.unlock();
        }
    }

    private void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.metricRegistry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    @VisibleForTesting
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @VisibleForTesting
    public String dumpJson() throws Exception {
        ObjectMapper jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false));
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.metricRegistry);
    }

    private void initReporting(Set<MetricsReporting> reportingSet) {
        for (MetricsReporting reporting : reportingSet) {
            switch (reporting) {
                case CONSOLE: {
                    ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    consoleReporter.start(1L, TimeUnit.SECONDS);
                    this.reporters.add((Closeable)consoleReporter);
                    break;
                }
                case JMX: {
                    JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    jmxReporter.start();
                    this.reporters.add((Closeable)jmxReporter);
                    break;
                }
                case JSON_FILE: {
                    JsonFileReporter jsonFileReporter = new JsonFileReporter();
                    jsonFileReporter.start();
                    this.reporters.add(jsonFileReporter);
                    break;
                }
                case HADOOP2: {
                    String applicationName = this.conf.get(HiveConf.ConfVars.HIVE_METRICS_HADOOP2_COMPONENT_NAME.varname);
                    long reportingInterval = HiveConf.toTime(this.conf.get(HiveConf.ConfVars.HIVE_METRICS_HADOOP2_INTERVAL.varname), TimeUnit.SECONDS, TimeUnit.SECONDS);
                    HadoopMetrics2Reporter metrics2Reporter = HadoopMetrics2Reporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(DefaultMetricsSystem.initialize((String)applicationName), applicationName, applicationName, "General");
                    metrics2Reporter.start(reportingInterval, TimeUnit.SECONDS);
                }
            }
        }
    }

    class JsonFileReporter
    implements Closeable,
    Runnable {
        private ObjectMapper jsonMapper = null;
        private ScheduledExecutorService executorService;
        private Path path;
        private Path metricsDir;

        JsonFileReporter() {
        }

        public void start() {
            this.jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false));
            long time = CodahaleMetrics.this.conf.getTimeVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, TimeUnit.MILLISECONDS);
            String pathString = CodahaleMetrics.this.conf.getVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION);
            this.path = Paths.get(pathString, new String[0]).toAbsolutePath();
            LOGGER.info("Reporting metrics to {}", (Object)this.path);
            this.metricsDir = this.path.getParent();
            if (!this.metricsDir.toFile().exists()) {
                LOGGER.warn("Metrics directory {} does not exist, creating one", (Object)this.metricsDir);
                try {
                    Files.createDirectories(this.metricsDir, DIR_ATTRS);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to create directory {}: {}", (Object)this.metricsDir, (Object)e.getMessage());
                    return;
                }
            }
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat(CodahaleMetrics.JSON_REPORTER_THREAD_NAME).build());
            this.executorService.scheduleWithFixedDelay(this, 0L, time, TimeUnit.MILLISECONDS);
        }

        @Override
        public void close() {
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Path tmpFile = null;
            try {
                String json = this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)CodahaleMetrics.this.metricRegistry);
                tmpFile = Files.createTempFile(this.metricsDir, "hmetrics", "json", FILE_ATTRS);
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile.toFile()));){
                    bw.write(json);
                }
                try {
                    Files.move(tmpFile, this.path, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to rename temp file {} to {}", (Object)tmpFile, (Object)this.path);
                    LOGGER.error("Exception during rename", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error writing JSON Metrics to file", (Throwable)e);
            }
            finally {
                if (tmpFile != null && tmpFile.toFile().exists()) {
                    try {
                        Files.delete(tmpFile);
                    }
                    catch (Exception e) {
                        LOGGER.error("failed to delete temporary metrics file {}", (Object)tmpFile, (Object)e);
                    }
                }
            }
        }
    }

    public class CodahaleMetricsScope
    implements MetricsScope {
        private final String name;
        private final Timer timer;
        private Timer.Context timerContext;
        private boolean isOpen = false;

        private CodahaleMetricsScope(String name) {
            this.name = name;
            this.timer = CodahaleMetrics.this.getTimer(name);
            this.open();
        }

        public void open() {
            if (!this.isOpen) {
                this.isOpen = true;
                this.timerContext = this.timer.time();
                CodahaleMetrics.this.incrementCounter("active_calls_" + this.name);
            } else {
                LOGGER.warn("Scope named " + this.name + " is not closed, cannot be opened.");
            }
        }

        public void close() {
            if (this.isOpen) {
                this.timerContext.close();
                CodahaleMetrics.this.decrementCounter("active_calls_" + this.name);
            } else {
                LOGGER.warn("Scope named " + this.name + " is not open, cannot be closed.");
            }
            this.isOpen = false;
        }
    }
}

