/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelOutputStream.class);
    private ChannelHandlerContext chc;
    private int bufSize;
    private String id;
    private ByteBuf buf;
    private byte[] singleByte = new byte[1];
    private boolean closed = false;
    private ChannelFutureListener listener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            if (future.isCancelled()) {
                LOG.error(ChannelOutputStream.this.id + " was cancelled");
            } else if (!future.isSuccess()) {
                LOG.error("Error on ID " + ChannelOutputStream.this.id, future.cause());
            }
        }
    };

    public ChannelOutputStream(ChannelHandlerContext chc, String id, int bufSize) {
        this.chc = chc;
        this.id = id;
        this.bufSize = bufSize;
        this.buf = chc.alloc().buffer(bufSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.singleByte[0] = (byte)b;
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int currentOffset = off;
        int bytesRemaining = len;
        while (bytesRemaining + this.buf.readableBytes() > this.bufSize) {
            int iterationLen = this.bufSize - this.buf.readableBytes();
            this.writeInternal(b, currentOffset, iterationLen);
            currentOffset += iterationLen;
            bytesRemaining -= iterationLen;
        }
        if (bytesRemaining > 0) {
            this.writeInternal(b, currentOffset, bytesRemaining);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buf.isReadable()) {
            this.writeToChannel();
        }
        this.chc.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed: " + this.id);
        }
        try {
            this.flush();
        }
        catch (IOException err) {
            LOG.error("Error flushing stream before close", (Throwable)err);
        }
        try {
            this.chc.close().addListener((GenericFutureListener)this.listener).sync();
        }
        catch (InterruptedException err) {
            throw new IOException(err);
        }
        finally {
            this.buf.release();
            this.buf = null;
            this.chc = null;
            this.closed = true;
        }
    }

    private void writeToChannel() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed: " + this.id);
        }
        this.chc.write((Object)this.buf.copy()).addListener((GenericFutureListener)this.listener);
        this.buf.clear();
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed: " + this.id);
        }
        this.buf.writeBytes(b, off, len);
        if (this.buf.readableBytes() >= this.bufSize) {
            this.writeToChannel();
        }
    }
}

