/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.StatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsNoJobTask
extends Task<StatsNoJobWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(StatsNoJobTask.class);
    private static ConcurrentMap<String, Partition> partUpdates;
    private static Table table;
    private static String tableFullName;
    private static JobConf jc;

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext driverContext, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, driverContext, opContext);
        jc = new JobConf((Configuration)this.conf);
    }

    @Override
    public int execute(DriverContext driverContext) {
        LOG.info("Executing stats (no job) task");
        String tableName = "";
        ExecutorService threadPool = null;
        Hive db = this.getHive();
        try {
            tableName = ((StatsNoJobWork)this.work).getTableSpecs().tableName;
            table = db.getTable(tableName);
            int numThreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVE_STATS_GATHER_NUM_THREADS);
            tableFullName = table.getDbName() + "." + table.getTableName();
            threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StatsNoJobTask-Thread-%d").build());
            partUpdates = new MapMaker().concurrencyLevel(numThreads).makeMap();
            LOG.info("Initialized threadpool for stats computation with " + numThreads + " threads");
        }
        catch (HiveException e) {
            LOG.error("Cannot get table " + tableName, (Throwable)e);
            this.console.printError("Cannot get table " + tableName, e.toString());
        }
        return this.aggregateStats(threadPool, db);
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS-NO-JOB";
    }

    private int aggregateStats(ExecutorService threadPool, Hive db) {
        int ret;
        block11: {
            ret = 0;
            try {
                Collection<Partition> partitions = null;
                partitions = ((StatsNoJobWork)this.work).getPrunedPartitionList() == null ? this.getPartitionsList() : ((StatsNoJobWork)this.work).getPrunedPartitionList().getPartitions();
                if (partitions == null) {
                    org.apache.hadoop.hive.metastore.api.Table tTable = table.getTTable();
                    Map<String, String> parameters = tTable.getParameters();
                    try {
                        Path dir = new Path(tTable.getSd().getLocation());
                        long numRows = 0L;
                        long rawDataSize = 0L;
                        long fileSize = 0L;
                        long numFiles = 0L;
                        long numErasureCodedFiles = 0L;
                        FileSystem fs = dir.getFileSystem((Configuration)this.conf);
                        FileStatus[] fileList = HiveStatsUtils.getFileStatusRecurse(dir, -1, fs);
                        boolean statsAvailable = false;
                        for (FileStatus file : fileList) {
                            if (file.isDir()) continue;
                            InputFormat inputFormat = ReflectionUtil.newInstance(table.getInputFormatClass(), (Configuration)jc);
                            FileSplit dummySplit = new FileSplit(file.getPath(), 0L, 0L, new String[]{table.getDataLocation().toString()});
                            if (file.getLen() == 0L) {
                                ++numFiles;
                                statsAvailable = true;
                                continue;
                            }
                            RecordReader recordReader = inputFormat.getRecordReader((InputSplit)dummySplit, jc, Reporter.NULL);
                            if (recordReader instanceof StatsProvidingRecordReader) {
                                StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                                numRows += statsRR.getStats().getRowCount();
                                rawDataSize += statsRR.getStats().getRawDataSize();
                                fileSize += file.getLen();
                                ++numFiles;
                                if (file.isErasureCoded()) {
                                    ++numErasureCodedFiles;
                                }
                                statsAvailable = true;
                            }
                            recordReader.close();
                        }
                        if (statsAvailable) {
                            parameters.put("numRows", String.valueOf(numRows));
                            parameters.put("rawDataSize", String.valueOf(rawDataSize));
                            parameters.put("totalSize", String.valueOf(fileSize));
                            parameters.put("numFiles", String.valueOf(numFiles));
                            parameters.put("numFilesErasureCoded", String.valueOf(numErasureCodedFiles));
                            EnvironmentContext environmentContext = new EnvironmentContext();
                            environmentContext.putToProperties("STATS_GENERATED", "TASK");
                            db.alterTable(tableFullName, new Table(tTable), environmentContext);
                            String msg = "Table " + tableFullName + " stats: [" + this.toString(parameters) + ']';
                            LOG.debug(msg);
                            this.console.printInfo(msg);
                            break block11;
                        }
                        String msg = "Table " + tableFullName + " does not provide stats.";
                        LOG.debug(msg);
                    }
                    catch (Exception e) {
                        this.console.printInfo("[Warning] could not update stats for " + tableFullName + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    }
                    break block11;
                }
                for (Partition partn : partitions) {
                    threadPool.execute(new StatsCollection(partn));
                }
                LOG.debug("Stats collection waiting for threadpool to shutdown..");
                this.shutdownAndAwaitTermination(threadPool);
                LOG.debug("Stats collection threadpool shutdown successful.");
                ret = this.updatePartitions(db);
            }
            catch (Exception e) {
                if (!((StatsNoJobWork)this.work).isStatsReliable()) break block11;
                ret = -1;
            }
        }
        return ret;
    }

    private int updatePartitions(Hive db) throws InvalidOperationException, HiveException {
        if (!partUpdates.isEmpty()) {
            ArrayList updatedParts = Lists.newArrayList(partUpdates.values());
            if (updatedParts.contains(null) && ((StatsNoJobWork)this.work).isStatsReliable()) {
                LOG.debug("Stats requested to be reliable. Empty stats found and hence failing the task.");
                return -1;
            }
            LOG.debug("Bulk updating partitions..");
            EnvironmentContext environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("STATS_GENERATED", "TASK");
            db.alterPartitions(tableFullName, Lists.newArrayList(partUpdates.values()), environmentContext);
            LOG.debug("Bulk updated " + partUpdates.values().size() + " partitions.");
        }
        return 0;
    }

    private void shutdownAndAwaitTermination(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(100L, TimeUnit.SECONDS)) {
                threadPool.shutdownNow();
                if (!threadPool.awaitTermination(100L, TimeUnit.SECONDS)) {
                    LOG.debug("Stats collection thread pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private String toString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (String statType : StatsSetupConst.SUPPORTED_STATS) {
            String value = parameters.get(statType);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(statType).append('=').append(value);
        }
        return builder.toString();
    }

    private List<Partition> getPartitionsList() throws HiveException {
        if (((StatsNoJobWork)this.work).getTableSpecs() != null) {
            BaseSemanticAnalyzer.TableSpec tblSpec = ((StatsNoJobWork)this.work).getTableSpecs();
            table = tblSpec.tableHandle;
            if (!table.isPartitioned()) {
                return null;
            }
            return tblSpec.partitions;
        }
        return null;
    }

    static {
        jc = null;
    }

    class StatsCollection
    implements Runnable {
        private final Partition partn;

        public StatsCollection(Partition part) {
            this.partn = part;
        }

        @Override
        public void run() {
            block7: {
                org.apache.hadoop.hive.metastore.api.Partition tPart = this.partn.getTPartition();
                Map<String, String> parameters = tPart.getParameters();
                try {
                    String threadName;
                    Path dir = new Path(tPart.getSd().getLocation());
                    long numRows = 0L;
                    long rawDataSize = 0L;
                    long fileSize = 0L;
                    long numFiles = 0L;
                    long numErasureCodedFiles = 0L;
                    FileSystem fs = dir.getFileSystem((Configuration)StatsNoJobTask.this.conf);
                    FileStatus[] fileList = HiveStatsUtils.getFileStatusRecurse(dir, -1, fs);
                    boolean statsAvailable = false;
                    for (FileStatus file : fileList) {
                        if (file.isDir()) continue;
                        InputFormat inputFormat = ReflectionUtil.newInstance(this.partn.getInputFormatClass(), (Configuration)jc);
                        FileSplit dummySplit = new FileSplit(file.getPath(), 0L, 0L, new String[]{this.partn.getLocation()});
                        RecordReader recordReader = inputFormat.getRecordReader((InputSplit)dummySplit, jc, Reporter.NULL);
                        if (recordReader instanceof StatsProvidingRecordReader) {
                            StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                            rawDataSize += statsRR.getStats().getRawDataSize();
                            numRows += statsRR.getStats().getRowCount();
                            fileSize += file.getLen();
                            ++numFiles;
                            if (file.isErasureCoded()) {
                                ++numErasureCodedFiles;
                            }
                            statsAvailable = true;
                        }
                        recordReader.close();
                    }
                    if (statsAvailable) {
                        parameters.put("numRows", String.valueOf(numRows));
                        parameters.put("rawDataSize", String.valueOf(rawDataSize));
                        parameters.put("totalSize", String.valueOf(fileSize));
                        parameters.put("numFiles", String.valueOf(numFiles));
                        parameters.put("numFilesErasureCoded", String.valueOf(numErasureCodedFiles));
                        partUpdates.put(tPart.getSd().getLocation(), new Partition(table, tPart));
                        threadName = Thread.currentThread().getName();
                        String msg = "Partition " + tableFullName + this.partn.getSpec() + " stats: [" + this.toString(parameters) + ']';
                        LOG.debug(threadName + ": " + msg);
                        StatsNoJobTask.this.console.printInfo(msg);
                    } else {
                        threadName = Thread.currentThread().getName();
                        String msg = "Partition " + tableFullName + this.partn.getSpec() + " does not provide stats.";
                        LOG.debug(threadName + ": " + msg);
                    }
                }
                catch (Exception e) {
                    StatsNoJobTask.this.console.printInfo("[Warning] could not update stats for " + tableFullName + this.partn.getSpec() + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    if (!((StatsNoJobWork)StatsNoJobTask.this.work).isStatsReliable()) break block7;
                    partUpdates.put(tPart.getSd().getLocation(), null);
                }
            }
        }

        private String toString(Map<String, String> parameters) {
            StringBuilder builder = new StringBuilder();
            for (String statType : StatsSetupConst.SUPPORTED_STATS) {
                String value = parameters.get(statType);
                if (value == null) continue;
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(statType).append('=').append(value);
            }
            return builder.toString();
        }
    }
}

