/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import org.apache.hadoop.hive.ql.exec.spark.SparkTran;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.io.WritableComparable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.storage.StorageLevel;

public abstract class CacheTran<KI extends WritableComparable, VI, KO extends WritableComparable, VO>
implements SparkTran<KI, VI, KO, VO> {
    private boolean caching = false;
    private JavaPairRDD<KO, VO> cachedRDD;
    protected final String name;
    private final BaseWork baseWork;

    protected CacheTran(boolean cache, String name, BaseWork baseWork) {
        this.caching = cache;
        this.name = name;
        this.baseWork = baseWork;
    }

    @Override
    public JavaPairRDD<KO, VO> transform(JavaPairRDD<KI, VI> input) {
        if (this.caching) {
            if (this.cachedRDD == null) {
                this.cachedRDD = this.doTransform(input);
                this.cachedRDD.persist(StorageLevel.MEMORY_AND_DISK());
            }
            return this.cachedRDD.setName(this.name + " (" + this.cachedRDD.getNumPartitions() + ", cached)");
        }
        JavaPairRDD<KO, VO> rdd = this.doTransform(input);
        return rdd.setName(this.name + " (" + rdd.getNumPartitions() + ")");
    }

    @Override
    public Boolean isCacheEnable() {
        return this.caching;
    }

    protected abstract JavaPairRDD<KO, VO> doTransform(JavaPairRDD<KI, VI> var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BaseWork getBaseWork() {
        return this.baseWork;
    }
}

