/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColumnVector
extends ColumnVector {
    public HiveDecimalWritable[] vector;
    public short scale;
    public short precision;

    public DecimalColumnVector(int precision, int scale) {
        this(1024, precision, scale);
    }

    public DecimalColumnVector(int size, int precision, int scale) {
        super(size);
        this.precision = (short)precision;
        this.scale = (short)scale;
        this.vector = new HiveDecimalWritable[size];
        for (int i = 0; i < size; ++i) {
            this.vector[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
    }

    public void fill(HiveDecimal value) {
        this.isRepeating = true;
        this.isNull[0] = false;
        if (this.vector[0] == null) {
            this.vector[0] = new HiveDecimalWritable(value);
        }
        this.set(0, value);
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setElement(int outputElementNum, int inputElementNum, ColumnVector inputColVector) {
        if (this.isRepeating && outputElementNum != 0) {
            throw new RuntimeException("Output column number expected to be 0 when isRepeating");
        }
        if (inputColVector.isRepeating) {
            inputElementNum = 0;
        }
        if (!this.noNulls && this.isNull[outputElementNum]) {
            return;
        }
        if (inputColVector.noNulls || !inputColVector.isNull[inputElementNum]) {
            HiveDecimal hiveDec = ((DecimalColumnVector)inputColVector).vector[inputElementNum].getHiveDecimal(this.precision, this.scale);
            if (hiveDec == null) {
                this.isNull[outputElementNum] = true;
                this.noNulls = false;
            }
        } else {
            this.isNull[outputElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append(this.vector[row].toString());
        } else {
            buffer.append("null");
        }
    }

    public void set(int elementNum, HiveDecimalWritable writable) {
        if (writable == null) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            HiveDecimal hiveDec = writable.getHiveDecimal(this.precision, this.scale);
            if (hiveDec == null) {
                this.noNulls = false;
                this.isNull[elementNum] = true;
            } else {
                this.vector[elementNum].set(hiveDec);
            }
        }
    }

    public void set(int elementNum, HiveDecimal hiveDec) {
        HiveDecimal checkedDec = HiveDecimal.enforcePrecisionScale(hiveDec, (int)this.precision, (int)this.scale);
        if (checkedDec == null) {
            this.noNulls = false;
            this.isNull[elementNum] = true;
        } else {
            this.vector[elementNum].set(checkedDec);
        }
    }

    public void setNullDataValue(int elementNum) {
        HiveDecimal minimumNonZeroValue = HiveDecimal.create(BigInteger.ONE, this.scale);
        this.vector[elementNum].set(minimumNonZeroValue);
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (size <= this.vector.length) {
            return;
        }
        HiveDecimalWritable[] oldArray = this.vector;
        this.vector = new HiveDecimalWritable[size];
        int initPos = 0;
        if (preserveData) {
            initPos = oldArray.length;
            System.arraycopy(oldArray, 0, this.vector, 0, oldArray.length);
        }
        for (int i = initPos; i < this.vector.length; ++i) {
            this.vector[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector outputColVector) {
        DecimalColumnVector output = (DecimalColumnVector)outputColVector;
        boolean[] outputIsNull = output.isNull;
        output.isRepeating = false;
        if (this.isRepeating) {
            if (this.noNulls || !this.isNull[0]) {
                outputIsNull[0] = false;
                output.set(0, this.vector[0]);
            } else {
                outputIsNull[0] = true;
                output.noNulls = false;
                output.vector[0].set(HiveDecimal.ZERO);
            }
            output.isRepeating = true;
            return;
        }
        if (this.noNulls) {
            if (selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != size; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        output.set(i, this.vector[i]);
                    }
                } else {
                    for (int j = 0; j != size; ++j) {
                        int i = sel[j];
                        output.set(i, this.vector[i]);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != size; ++i) {
                    output.set(i, this.vector[i]);
                }
            }
        } else if (selectedInUse) {
            for (int j = 0; j < size; ++j) {
                int i = sel[j];
                if (!this.isNull[i]) {
                    output.isNull[i] = false;
                    output.set(i, this.vector[i]);
                    continue;
                }
                output.isNull[i] = true;
                output.noNulls = false;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!this.isNull[i]) {
                    output.isNull[i] = false;
                    output.set(i, this.vector[i]);
                    continue;
                }
                output.isNull[i] = true;
                output.noNulls = false;
            }
        }
    }
}

