/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.Text;

public class VectorUDFDateDiffScalarCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private long longValue;
    private Timestamp timestampValue = null;
    private byte[] stringValue;
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final transient Text text = new Text();
    private int baseDate;
    private transient Date date = new Date(0L);

    public VectorUDFDateDiffScalarCol(Object object, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        if (object instanceof Long) {
            this.longValue = (Long)object;
        } else if (object instanceof Timestamp) {
            this.timestampValue = (Timestamp)object;
        } else if (object instanceof byte[]) {
            this.stringValue = (byte[])object;
        } else {
            throw new RuntimeException("Unexpected scalar object " + object.getClass().getName() + " " + object.toString());
        }
    }

    public VectorUDFDateDiffScalarCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        ColumnVector inputCol = batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        boolean[] outputIsNull = outputColVector.isNull;
        if (batch.size == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        switch (this.inputTypes[0]) {
            case DATE: {
                this.baseDate = (int)this.longValue;
                break;
            }
            case TIMESTAMP: {
                this.date.setTime(this.timestampValue.getTime());
                this.baseDate = DateWritable.dateToDays(this.date);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                try {
                    this.date.setTime(this.formatter.parse(new String(this.stringValue, "UTF-8")).getTime());
                    this.baseDate = DateWritable.dateToDays(this.date);
                    break;
                }
                catch (Exception e) {
                    outputColVector.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = true;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColVector.isNull[i] = true;
                        }
                    }
                    return;
                }
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
        switch (this.inputTypes[1]) {
            case DATE: {
                if (inputCol.isRepeating) {
                    if (inputCol.noNulls || !inputCol.isNull[0]) {
                        outputColVector.isNull[0] = false;
                        outputColVector.vector[0] = this.evaluateDate(inputCol, 0);
                    } else {
                        outputColVector.isNull[0] = true;
                        outputColVector.noNulls = false;
                    }
                    outputColVector.isRepeating = true;
                    break;
                }
                if (inputCol.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outputColVector.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = false;
                                outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                            }
                        }
                    } else {
                        if (!outputColVector.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outputColVector.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                } else {
                    outputColVector.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputCol.isRepeating) {
                    if (inputCol.noNulls || !inputCol.isNull[0]) {
                        outputColVector.isNull[0] = false;
                        outputColVector.vector[0] = this.evaluateTimestamp(inputCol, 0);
                    } else {
                        outputColVector.isNull[0] = true;
                        outputColVector.noNulls = false;
                    }
                    outputColVector.isRepeating = true;
                    break;
                }
                if (inputCol.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outputColVector.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = false;
                                outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                            }
                        }
                    } else {
                        if (!outputColVector.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outputColVector.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                } else {
                    outputColVector.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (inputCol.isRepeating) {
                    if (inputCol.noNulls || !inputCol.isNull[0]) {
                        outputColVector.isNull[0] = false;
                        this.evaluateString(inputCol, outputColVector, 0);
                    } else {
                        outputColVector.isNull[0] = true;
                        outputColVector.noNulls = false;
                    }
                    outputColVector.isRepeating = true;
                    break;
                }
                if (inputCol.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outputColVector.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = false;
                                this.evaluateString(inputCol, outputColVector, i);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                this.evaluateString(inputCol, outputColVector, i);
                            }
                        }
                    } else {
                        if (!outputColVector.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outputColVector.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            this.evaluateString(inputCol, outputColVector, i);
                        }
                    }
                } else {
                    outputColVector.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outputColVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outputColVector, i);
                        }
                    }
                }
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[1].name());
            }
        }
    }

    protected int evaluateTimestamp(ColumnVector columnVector, int index) {
        TimestampColumnVector tcv = (TimestampColumnVector)columnVector;
        this.date.setTime(tcv.getTime(index));
        return this.baseDate - DateWritable.dateToDays(this.date);
    }

    protected int evaluateDate(ColumnVector columnVector, int index) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        return this.baseDate - (int)lcv.vector[index];
    }

    protected void evaluateString(ColumnVector columnVector, LongColumnVector output, int i) {
        BytesColumnVector bcv = (BytesColumnVector)columnVector;
        this.text.set(bcv.vector[i], bcv.start[i], bcv.length[i]);
        try {
            this.date.setTime(this.formatter.parse(this.text.toString()).getTime());
            output.vector[i] = this.baseDate - DateWritable.dateToDays(this.date);
        }
        catch (ParseException e) {
            output.vector[i] = 1L;
            output.isNull[i] = true;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(int longValue) {
        this.longValue = longValue;
    }

    public byte[] getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(byte[] stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.stringValue + ", col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

