/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.session.SessionState;

public class HooksLoader {
    private final HiveConf conf;

    public HooksLoader(HiveConf conf) {
        this.conf = conf;
    }

    public final <T extends Hook> List<T> getHooks(HiveConf.ConfVars hookConfVar, SessionState.LogHelper console, Class<?> clazz) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            return this.getHooks(hookConfVar, clazz);
        }
        catch (ClassNotFoundException e) {
            console.printError(hookConfVar.varname + " Class not found: " + e.getMessage());
            throw e;
        }
    }

    public <T extends Hook> List<T> getHooks(HiveConf.ConfVars hookConfVar, Class<?> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] hookClasses;
        String csHooks = this.conf.getVar(hookConfVar);
        ImmutableList.Builder hooks = ImmutableList.builder();
        if (csHooks == null) {
            return ImmutableList.of();
        }
        if ((csHooks = csHooks.trim()).isEmpty()) {
            return ImmutableList.of();
        }
        for (String hookClass : hookClasses = csHooks.split(",")) {
            Hook hook = (Hook)Class.forName(hookClass.trim(), true, Utilities.getSessionSpecifiedClassLoader()).newInstance();
            hooks.add(hook);
        }
        return hooks.build();
    }
}

