/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.ql.io.orc.encoded.CacheChunk;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.IncompleteCb;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.orc.CompressionCodec;
import org.apache.orc.DataReader;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.RecordReaderUtils;
import org.apache.orc.impl.StreamName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EncodedReaderImpl
implements EncodedReader {
    public static final Logger LOG = LoggerFactory.getLogger(EncodedReaderImpl.class);
    private static final Object POOLS_CREATION_LOCK = new Object();
    private static Pools POOLS;
    private static final DataCache.DiskRangeListFactory CC_FACTORY;
    private final Object fileKey;
    private final DataReader dataReader;
    private boolean isDataReaderOpen = false;
    private final CompressionCodec codec;
    private final int bufferSize;
    private final List<OrcProto.Type> types;
    private final long rowIndexStride;
    private final DataCache cacheWrapper;
    private boolean isTracingEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodedReaderImpl(Object fileKey, List<OrcProto.Type> types, CompressionCodec codec, int bufferSize, long strideRate, DataCache cacheWrapper, DataReader dataReader, Reader.PoolFactory pf) throws IOException {
        this.fileKey = fileKey;
        this.codec = codec;
        this.types = types;
        this.bufferSize = bufferSize;
        this.rowIndexStride = strideRate;
        this.cacheWrapper = cacheWrapper;
        this.dataReader = dataReader;
        if (POOLS != null) {
            return;
        }
        if (pf == null) {
            pf = new NoopPoolFactory();
        }
        Pools pools = EncodedReaderImpl.createPools(pf);
        Object object = POOLS_CREATION_LOCK;
        synchronized (object) {
            if (POOLS != null) {
                return;
            }
            POOLS = pools;
        }
    }

    @Override
    public void readEncodedColumns(int stripeIx, StripeInformation stripe, OrcProto.RowIndex[] indexes, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Stream> streamList, boolean[] included, boolean[][] colRgs, Consumer<Reader.OrcEncodedColumnBatch> consumer) throws IOException {
        boolean hasFileId;
        long stripeOffset = stripe.getOffset();
        long offset = 0L;
        boolean[] hasNull = RecordReaderUtils.findPresentStreamsByColumn(streamList, this.types);
        if (this.isTracingEnabled) {
            LOG.trace("The following columns have PRESENT streams: " + EncodedReaderImpl.arrayToString(hasNull));
        }
        int colRgIx = -1;
        int lastColIx = -1;
        ColumnReadContext[] colCtxs = new ColumnReadContext[colRgs.length];
        boolean[] includedRgs = null;
        boolean isCompressed = this.codec != null;
        DiskRangeList.CreateHelper listToRead = new DiskRangeList.CreateHelper();
        boolean hasIndexOnlyCols = false;
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int colIx = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (!included[colIx] || StreamName.getArea(streamKind) != StreamName.Area.DATA) {
                hasIndexOnlyCols |= included[colIx];
                if (this.isTracingEnabled) {
                    LOG.trace("Skipping stream: " + streamKind + " at " + offset + ", " + length);
                }
                offset += length;
                continue;
            }
            ColumnReadContext ctx = null;
            if (lastColIx != colIx) {
                assert (colCtxs[++colRgIx] == null);
                lastColIx = colIx;
                includedRgs = colRgs[colRgIx];
                ctx = colCtxs[colRgIx] = new ColumnReadContext(colIx, encodings.get(colIx), indexes[colIx]);
                if (this.isTracingEnabled) {
                    LOG.trace("Creating context " + colRgIx + " for column " + colIx + ":" + ctx.toString());
                }
            } else {
                ctx = colCtxs[colRgIx];
                assert (ctx != null);
            }
            int indexIx = RecordReaderUtils.getIndexPosition(ctx.encoding.getKind(), this.types.get(colIx).getKind(), streamKind, isCompressed, hasNull[colIx]);
            ctx.addStream(offset, stream, indexIx);
            if (this.isTracingEnabled) {
                LOG.trace("Adding stream for column " + colIx + ": " + streamKind + " at " + offset + ", " + length + ", index position " + indexIx);
            }
            if (includedRgs == null || RecordReaderUtils.isDictionary(streamKind, encodings.get(colIx))) {
                RecordReaderUtils.addEntireStreamToRanges(offset, length, listToRead, true);
                if (this.isTracingEnabled) {
                    LOG.trace("Will read whole stream " + streamKind + "; added to " + listToRead.getTail());
                }
            } else {
                RecordReaderUtils.addRgFilteredStreamToRanges(stream, includedRgs, this.codec != null, indexes[colIx], encodings.get(colIx), this.types.get(colIx), this.bufferSize, hasNull[colIx], offset, length, listToRead, true);
            }
            offset += length;
        }
        boolean bl = hasFileId = this.fileKey != null;
        if (listToRead.get() == null) {
            if (hasIndexOnlyCols && includedRgs == null) {
                Reader.OrcEncodedColumnBatch ecb = EncodedReaderImpl.POOLS.ecbPool.take();
                ecb.init(this.fileKey, stripeIx, -1, colRgs.length);
                consumer.consumeData(ecb);
            } else {
                LOG.warn("Nothing to read for stripe [" + stripe + "]");
            }
            return;
        }
        DiskRangeList.MutateHelper toRead = new DiskRangeList.MutateHelper(listToRead.get());
        if (this.isTracingEnabled && LOG.isInfoEnabled()) {
            LOG.trace("Resulting disk ranges to read (file " + this.fileKey + "): " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
        }
        DataCache.BooleanRef isAllInCache = new DataCache.BooleanRef();
        if (hasFileId) {
            this.cacheWrapper.getFileData(this.fileKey, toRead.next, stripeOffset, CC_FACTORY, isAllInCache);
            if (this.isTracingEnabled && LOG.isInfoEnabled()) {
                LOG.trace("Disk ranges after cache (file " + this.fileKey + ", base offset " + stripeOffset + "): " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
            }
        }
        if (!isAllInCache.value) {
            if (!this.isDataReaderOpen) {
                this.dataReader.open();
                this.isDataReaderOpen = true;
            }
            this.dataReader.readFileData(toRead.next, stripeOffset, this.cacheWrapper.getAllocator().isDirectAlloc());
        }
        DiskRangeList iter = toRead.next;
        if (this.codec == null) {
            for (int colIxMod = 0; colIxMod < colRgs.length; ++colIxMod) {
                ColumnReadContext ctx = colCtxs[colIxMod];
                for (int streamIx = 0; streamIx < ctx.streamCount; ++streamIx) {
                    StreamContext sctx = ctx.streams[streamIx];
                    DiskRangeList newIter = this.preReadUncompressedStream(stripeOffset, iter, sctx.offset, sctx.offset + sctx.length);
                    if (newIter == null) continue;
                    iter = newIter;
                }
            }
            if (this.isTracingEnabled) {
                LOG.trace("Disk ranges after pre-read (file " + this.fileKey + ", base offset " + stripeOffset + "): " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
            }
            iter = toRead.next;
        }
        int rgCount = (int)Math.ceil((double)stripe.getNumberOfRows() / (double)this.rowIndexStride);
        for (int rgIx = 0; rgIx < rgCount; ++rgIx) {
            boolean isLastRg = rgIx == rgCount - 1;
            Reader.OrcEncodedColumnBatch ecb = EncodedReaderImpl.POOLS.ecbPool.take();
            ecb.init(this.fileKey, stripeIx, rgIx, colRgs.length);
            boolean isRGSelected = true;
            for (int colIxMod = 0; colIxMod < colRgs.length; ++colIxMod) {
                if (colRgs[colIxMod] != null && !colRgs[colIxMod][rgIx]) {
                    isRGSelected = false;
                    continue;
                }
                ColumnReadContext ctx = colCtxs[colIxMod];
                OrcProto.RowIndexEntry index = ctx.rowIndex.getEntry(rgIx);
                OrcProto.RowIndexEntry nextIndex = isLastRg ? null : ctx.rowIndex.getEntry(rgIx + 1);
                ecb.initColumn(colIxMod, ctx.colIx, Reader.OrcEncodedColumnBatch.MAX_DATA_STREAMS);
                for (int streamIx = 0; streamIx < ctx.streamCount; ++streamIx) {
                    StreamContext sctx = ctx.streams[streamIx];
                    EncodedColumnBatch.ColumnStreamData cb = null;
                    if (RecordReaderUtils.isDictionary(sctx.kind, ctx.encoding)) {
                        if (this.isTracingEnabled) {
                            LOG.trace("Getting stripe-level stream [" + sctx.kind + ", " + ctx.encoding + "] for column " + ctx.colIx + " RG " + rgIx + " at " + sctx.offset + ", " + sctx.length);
                        }
                        if (sctx.stripeLevelStream == null) {
                            sctx.stripeLevelStream = EncodedReaderImpl.POOLS.csdPool.take();
                            sctx.stripeLevelStream.incRef();
                            long unlockUntilCOffset = sctx.offset + sctx.length;
                            DiskRangeList lastCached = this.readEncodedStream(stripeOffset, iter, sctx.offset, sctx.offset + sctx.length, sctx.stripeLevelStream, unlockUntilCOffset, sctx.offset);
                            if (lastCached != null) {
                                iter = lastCached;
                            }
                        }
                        if (!isLastRg) {
                            sctx.stripeLevelStream.incRef();
                        }
                        cb = sctx.stripeLevelStream;
                    } else {
                        long cOffset = sctx.offset + index.getPositions(sctx.streamIndexOffset);
                        long nextCOffsetRel = isLastRg ? sctx.length : nextIndex.getPositions(sctx.streamIndexOffset);
                        long endCOffset = sctx.offset + RecordReaderUtils.estimateRgEndOffset(isCompressed, isLastRg, nextCOffsetRel, sctx.length, this.bufferSize);
                        long unlockUntilCOffset = sctx.offset + nextCOffsetRel;
                        boolean isStartOfStream = sctx.bufferIter == null;
                        DiskRangeList lastCached = this.readEncodedStream(stripeOffset, isStartOfStream ? iter : sctx.bufferIter, cOffset, endCOffset, cb = this.createRgColumnStreamData(rgIx, isLastRg, ctx.colIx, sctx, cOffset, endCOffset, isCompressed), unlockUntilCOffset, sctx.offset);
                        if (lastCached != null) {
                            sctx.bufferIter = iter = lastCached;
                        }
                    }
                    ecb.setStreamData(colIxMod, sctx.kind.getNumber(), cb);
                }
            }
            if (!isRGSelected) continue;
            consumer.consumeData(ecb);
        }
        if (this.isTracingEnabled) {
            LOG.trace("Disk ranges after preparing all the data " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
        }
        this.releaseInitialRefcounts(toRead.next);
        EncodedReaderImpl.releaseCacheChunksIntoObjectPool(toRead.next);
    }

    private static String arrayToString(boolean[] a) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length; ++i) {
            b.append(a[i] ? "1" : "0");
        }
        b.append(']');
        return b.toString();
    }

    private EncodedColumnBatch.ColumnStreamData createRgColumnStreamData(int rgIx, boolean isLastRg, int colIx, StreamContext sctx, long cOffset, long endCOffset, boolean isCompressed) {
        EncodedColumnBatch.ColumnStreamData cb = EncodedReaderImpl.POOLS.csdPool.take();
        cb.incRef();
        if (this.isTracingEnabled) {
            LOG.trace("Getting data for column " + colIx + " " + (isLastRg ? "last " : "") + "RG " + rgIx + " stream " + sctx.kind + " at " + sctx.offset + ", " + sctx.length + " index position " + sctx.streamIndexOffset + ": " + (isCompressed ? "" : "un") + "compressed [" + cOffset + ", " + endCOffset + ")");
        }
        return cb;
    }

    private void releaseInitialRefcounts(DiskRangeList current) {
        while (current != null) {
            CacheChunk cc;
            DiskRangeList toFree = current;
            current = current.next;
            if (!(toFree instanceof CacheChunk) || (cc = (CacheChunk)toFree).getBuffer() == null) continue;
            MemoryBuffer buffer = cc.getBuffer();
            this.cacheWrapper.releaseBuffer(buffer);
            cc.setBuffer(null);
        }
    }

    @Override
    public void setTracing(boolean isEnabled) {
        this.isTracingEnabled = isEnabled;
    }

    @Override
    public void close() throws IOException {
        this.dataReader.close();
    }

    public DiskRangeList readEncodedStream(long baseOffset, DiskRangeList start, long cOffset, long endCOffset, EncodedColumnBatch.ColumnStreamData csd, long unlockUntilCOffset, long streamOffset) throws IOException {
        if (csd.getCacheBuffers() == null) {
            csd.setCacheBuffers(new ArrayList<MemoryBuffer>());
        } else {
            csd.getCacheBuffers().clear();
        }
        if (cOffset == endCOffset) {
            return null;
        }
        boolean isCompressed = this.codec != null;
        ArrayList<ProcCacheChunk> toDecompress = null;
        ArrayList<ByteBuffer> toRelease = null;
        ArrayList<IncompleteCb> badEstimates = null;
        if (isCompressed) {
            toRelease = !this.dataReader.isTrackingDiskRanges() ? null : new ArrayList<ByteBuffer>();
            toDecompress = new ArrayList<ProcCacheChunk>();
            badEstimates = new ArrayList<IncompleteCb>();
        }
        DiskRangeList current = EncodedReaderImpl.findExactPosition(start, cOffset);
        if (this.isTracingEnabled) {
            LOG.trace("Starting read for [" + cOffset + "," + endCOffset + ") at " + current);
        }
        CacheChunk lastUncompressed = null;
        CacheChunk cacheChunk = lastUncompressed = isCompressed ? this.prepareRangesForCompressedRead(cOffset, endCOffset, streamOffset, unlockUntilCOffset, current, csd, toRelease, toDecompress, badEstimates) : this.prepareRangesForUncompressedRead(cOffset, endCOffset, streamOffset, unlockUntilCOffset, current, csd);
        if (badEstimates != null && !badEstimates.isEmpty()) {
            DiskRange[] cacheKeys = badEstimates.toArray(new DiskRange[badEstimates.size()]);
            long[] result = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, null, baseOffset);
            assert (result == null);
        }
        if (toDecompress == null || toDecompress.isEmpty()) {
            return lastUncompressed;
        }
        MemoryBuffer[] targetBuffers = new MemoryBuffer[toDecompress.size()];
        DiskRange[] cacheKeys = new DiskRange[toDecompress.size()];
        int ix = 0;
        for (ProcCacheChunk chunk : toDecompress) {
            cacheKeys[ix] = chunk;
            targetBuffers[ix] = chunk.getBuffer();
            ++ix;
        }
        this.cacheWrapper.getAllocator().allocateMultiple(targetBuffers, this.bufferSize);
        for (ProcCacheChunk chunk : toDecompress) {
            ByteBuffer dest = chunk.getBuffer().getByteBufferRaw();
            if (chunk.isOriginalDataCompressed) {
                EncodedReaderImpl.decompressChunk(chunk.originalData, this.codec, dest);
            } else {
                EncodedReaderImpl.copyUncompressedChunk(chunk.originalData, dest);
            }
            chunk.originalData = null;
            if (this.isTracingEnabled) {
                LOG.trace("Locking " + chunk.getBuffer() + " due to reuse (after decompression)");
            }
            this.cacheWrapper.reuseBuffer(chunk.getBuffer());
        }
        if (toRelease != null) {
            assert (this.dataReader.isTrackingDiskRanges());
            for (ByteBuffer buffer : toRelease) {
                this.dataReader.releaseBuffer(buffer);
            }
        }
        if (this.fileKey != null) {
            long[] collisionMask = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, targetBuffers, baseOffset);
            this.processCacheCollisions(collisionMask, toDecompress, targetBuffers, csd.getCacheBuffers());
        }
        for (ProcCacheChunk chunk : toDecompress) {
            this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, chunk);
        }
        return lastUncompressed;
    }

    private CacheChunk prepareRangesForCompressedRead(long cOffset, long endCOffset, long streamOffset, long unlockUntilCOffset, DiskRangeList current, EncodedColumnBatch.ColumnStreamData columnStreamData, List<ByteBuffer> toRelease, List<ProcCacheChunk> toDecompress, List<IncompleteCb> badEstimates) throws IOException {
        if (cOffset > current.getOffset()) {
            current = current.split((long)cOffset).next;
        }
        long currentOffset = cOffset;
        CacheChunk lastUncompressed = null;
        while (true) {
            DiskRangeList next = null;
            if (current instanceof CacheChunk) {
                CacheChunk cc = (CacheChunk)current;
                if (this.isTracingEnabled) {
                    LOG.trace("Locking " + cc.getBuffer() + " due to reuse");
                }
                this.cacheWrapper.reuseBuffer(cc.getBuffer());
                columnStreamData.getCacheBuffers().add(cc.getBuffer());
                currentOffset = cc.getEnd();
                if (this.isTracingEnabled) {
                    LOG.trace("Adding an already-uncompressed buffer " + cc.getBuffer());
                }
                this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, cc);
                lastUncompressed = cc;
                next = current.next;
                if (next != null && endCOffset >= 0L && currentOffset < endCOffset && next.getOffset() >= endCOffset) {
                    throw new IOException("Expected data at " + currentOffset + " (reading until " + endCOffset + "), but the next buffer starts at " + next.getOffset());
                }
            } else if (current instanceof IncompleteCb) {
                if (this.isTracingEnabled) {
                    LOG.trace("Cannot read " + current);
                }
                next = null;
                currentOffset = -1L;
            } else {
                BufferChunk bc = (BufferChunk)current;
                ProcCacheChunk newCached = this.addOneCompressionBuffer(bc, columnStreamData.getCacheBuffers(), toDecompress, toRelease, badEstimates);
                lastUncompressed = newCached == null ? lastUncompressed : newCached;
                next = newCached != null ? newCached.next : null;
                long l = currentOffset = next != null ? next.getOffset() : -1L;
            }
            if (next == null || endCOffset >= 0L && currentOffset >= endCOffset) break;
            current = next;
        }
        return lastUncompressed;
    }

    private CacheChunk prepareRangesForUncompressedRead(long cOffset, long endCOffset, long streamOffset, long unlockUntilCOffset, DiskRangeList current, EncodedColumnBatch.ColumnStreamData columnStreamData) throws IOException {
        long currentOffset = cOffset;
        CacheChunk lastUncompressed = null;
        boolean isFirst = true;
        while (true) {
            DiskRangeList next = null;
            assert (current instanceof CacheChunk);
            lastUncompressed = (CacheChunk)current;
            if (this.isTracingEnabled) {
                LOG.trace("Locking " + lastUncompressed.getBuffer() + " due to reuse");
            }
            this.cacheWrapper.reuseBuffer(lastUncompressed.getBuffer());
            if (isFirst) {
                columnStreamData.setIndexBaseOffset((int)(lastUncompressed.getOffset() - streamOffset));
                isFirst = false;
            }
            columnStreamData.getCacheBuffers().add(lastUncompressed.getBuffer());
            currentOffset = lastUncompressed.getEnd();
            if (this.isTracingEnabled) {
                LOG.trace("Adding an uncompressed buffer " + lastUncompressed.getBuffer());
            }
            this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, lastUncompressed);
            next = current.next;
            if (next == null || endCOffset >= 0L && currentOffset >= endCOffset) break;
            current = next;
        }
        return lastUncompressed;
    }

    private DiskRangeList preReadUncompressedStream(long baseOffset, DiskRangeList start, long streamOffset, long streamEnd) throws IOException {
        if (streamOffset == streamEnd) {
            return null;
        }
        ArrayList<UncompressedCacheChunk> toCache = null;
        ArrayList<ByteBuffer> toRelease = null;
        DiskRangeList current = EncodedReaderImpl.findIntersectingPosition(start, streamOffset, streamEnd);
        if (this.isTracingEnabled) {
            LOG.trace("Starting pre-read for [" + streamOffset + "," + streamEnd + ") at " + current);
        }
        if (streamOffset > current.getOffset()) {
            current = current.split((long)streamOffset).next;
        }
        long streamLen = streamEnd - streamOffset;
        int partSize = this.determineUncompressedPartSize();
        int partCount = (int)(streamLen / (long)partSize) + (streamLen % (long)partSize != 0L ? 1 : 0);
        CacheChunk lastUncompressed = null;
        MemoryBuffer[] singleAlloc = new MemoryBuffer[1];
        for (int i = 0; i < partCount; ++i) {
            long partOffset = streamOffset + (long)(i * partSize);
            long partEnd = Math.min(partOffset + (long)partSize, streamEnd);
            long hasEntirePartTo = partOffset;
            if (current == null) break;
            assert (partOffset <= current.getOffset());
            if (partOffset == current.getOffset() && current instanceof CacheChunk) {
                assert (current.getOffset() == partOffset && current.getEnd() == partEnd);
                lastUncompressed = (CacheChunk)current;
                current = current.next;
                continue;
            }
            if (current.getOffset() >= partEnd) continue;
            if (toRelease == null && this.dataReader.isTrackingDiskRanges()) {
                toRelease = new ArrayList<ByteBuffer>();
            }
            UncompressedCacheChunk candidateCached = null;
            DiskRangeList next = current;
            while (true) {
                boolean noMoreDataForPart;
                boolean bl = noMoreDataForPart = next == null || next.getOffset() >= partEnd;
                if (noMoreDataForPart && hasEntirePartTo < partEnd && candidateCached != null) {
                    lastUncompressed = EncodedReaderImpl.copyAndReplaceCandidateToNonCached(candidateCached, partOffset, hasEntirePartTo, this.cacheWrapper, singleAlloc);
                    candidateCached = null;
                }
                current = next;
                if (noMoreDataForPart) break;
                boolean wasSplit = false;
                if (current.getEnd() > partEnd) {
                    current = current.split(partEnd);
                    wasSplit = true;
                }
                if (this.isTracingEnabled) {
                    LOG.trace("Processing uncompressed file data at [" + current.getOffset() + ", " + current.getEnd() + ")");
                }
                BufferChunk curBc = (BufferChunk)current;
                if (!wasSplit && toRelease != null) {
                    toRelease.add(curBc.getChunk());
                }
                long hadEntirePartTo = hasEntirePartTo;
                long l = hasEntirePartTo = hasEntirePartTo == current.getOffset() ? current.getEnd() : -1L;
                if (hasEntirePartTo == -1L) {
                    if (candidateCached != null) {
                        assert (hadEntirePartTo != -1L);
                        EncodedReaderImpl.copyAndReplaceCandidateToNonCached(candidateCached, partOffset, hadEntirePartTo, this.cacheWrapper, singleAlloc);
                        candidateCached = null;
                    }
                    lastUncompressed = EncodedReaderImpl.copyAndReplaceUncompressedToNonCached(curBc, this.cacheWrapper, singleAlloc);
                    next = lastUncompressed.next;
                    continue;
                }
                if (candidateCached == null) {
                    candidateCached = new UncompressedCacheChunk(curBc);
                } else {
                    candidateCached.addChunk(curBc);
                }
                next = current.next;
            }
            if (candidateCached == null) continue;
            if (toCache == null) {
                toCache = new ArrayList<UncompressedCacheChunk>(partCount - i);
            }
            toCache.add(candidateCached);
        }
        if (toCache == null) {
            return lastUncompressed;
        }
        MemoryBuffer[] targetBuffers = toCache.size() == 1 ? singleAlloc : new MemoryBuffer[toCache.size()];
        targetBuffers[0] = null;
        DiskRange[] cacheKeys = new DiskRange[toCache.size()];
        int ix = 0;
        for (UncompressedCacheChunk chunk : toCache) {
            cacheKeys[ix] = chunk;
            ++ix;
        }
        this.cacheWrapper.getAllocator().allocateMultiple(targetBuffers, (int)(partCount == 1 ? streamLen : (long)partSize));
        ix = 0;
        for (UncompressedCacheChunk candidateCached : toCache) {
            candidateCached.setBuffer(targetBuffers[ix]);
            ByteBuffer dest = candidateCached.getBuffer().getByteBufferRaw();
            EncodedReaderImpl.copyAndReplaceUncompressedChunks(candidateCached, dest, candidateCached);
            candidateCached.clear();
            lastUncompressed = candidateCached;
            ++ix;
        }
        if (toRelease != null) {
            assert (this.dataReader.isTrackingDiskRanges());
            for (ByteBuffer buf : toRelease) {
                this.dataReader.releaseBuffer(buf);
            }
        }
        if (this.fileKey != null) {
            long[] collisionMask = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, targetBuffers, baseOffset);
            this.processCacheCollisions(collisionMask, toCache, targetBuffers, null);
        }
        return lastUncompressed;
    }

    private int determineUncompressedPartSize() {
        long orcCbSizeDefault = ((Number)OrcConf.BUFFER_SIZE.getDefaultValue()).longValue();
        int maxAllocSize = this.cacheWrapper.getAllocator().getMaxAllocation();
        return (int)Math.min((long)maxAllocSize, orcCbSizeDefault);
    }

    private static void copyUncompressedChunk(ByteBuffer src, ByteBuffer dest) {
        int startPos = dest.position();
        int startLim = dest.limit();
        dest.put(src);
        int newPos = dest.position();
        if (newPos > startLim) {
            throw new AssertionError((Object)("After copying, buffer [" + startPos + ", " + startLim + ") became [" + newPos + ", " + dest.limit() + ")"));
        }
        dest.position(startPos);
        dest.limit(newPos);
    }

    private static CacheChunk copyAndReplaceCandidateToNonCached(UncompressedCacheChunk candidateCached, long partOffset, long candidateEnd, DataCache cacheWrapper, MemoryBuffer[] singleAlloc) {
        singleAlloc[0] = null;
        cacheWrapper.getAllocator().allocateMultiple(singleAlloc, (int)(candidateEnd - partOffset));
        MemoryBuffer buffer = singleAlloc[0];
        cacheWrapper.reuseBuffer(buffer);
        ByteBuffer dest = buffer.getByteBufferRaw();
        CacheChunk tcc = EncodedReaderImpl.POOLS.tccPool.take();
        tcc.init(buffer, partOffset, candidateEnd);
        EncodedReaderImpl.copyAndReplaceUncompressedChunks(candidateCached, dest, tcc);
        return tcc;
    }

    private static CacheChunk copyAndReplaceUncompressedToNonCached(BufferChunk bc, DataCache cacheWrapper, MemoryBuffer[] singleAlloc) {
        singleAlloc[0] = null;
        cacheWrapper.getAllocator().allocateMultiple(singleAlloc, bc.getLength());
        MemoryBuffer buffer = singleAlloc[0];
        cacheWrapper.reuseBuffer(buffer);
        ByteBuffer dest = buffer.getByteBufferRaw();
        CacheChunk tcc = EncodedReaderImpl.POOLS.tccPool.take();
        tcc.init(buffer, bc.getOffset(), bc.getEnd());
        EncodedReaderImpl.copyUncompressedChunk(bc.getChunk(), dest);
        bc.replaceSelfWith(tcc);
        return tcc;
    }

    private static void copyAndReplaceUncompressedChunks(UncompressedCacheChunk candidateCached, ByteBuffer dest, CacheChunk tcc) {
        int startPos = dest.position();
        int startLim = dest.limit();
        DiskRangeList next = null;
        for (int i = 0; i < candidateCached.getCount(); ++i) {
            BufferChunk chunk = i == 0 ? candidateCached.getChunk() : (BufferChunk)next;
            dest.put(chunk.getData());
            next = chunk.next;
            if (i == 0) {
                chunk.replaceSelfWith(tcc);
                continue;
            }
            chunk.removeSelf();
        }
        int newPos = dest.position();
        if (newPos > startLim) {
            throw new AssertionError((Object)("After copying, buffer [" + startPos + ", " + startLim + ") became [" + newPos + ", " + dest.limit() + ")"));
        }
        dest.position(startPos);
        dest.limit(newPos);
    }

    private static void decompressChunk(ByteBuffer src, CompressionCodec codec, ByteBuffer dest) throws IOException {
        int startPos = dest.position();
        int startLim = dest.limit();
        codec.decompress(src, dest);
        dest.position(startPos);
        int newLim = dest.limit();
        if (newLim > startLim) {
            throw new AssertionError((Object)("After codec, buffer [" + startPos + ", " + startLim + ") became [" + dest.position() + ", " + newLim + ")"));
        }
    }

    public static void releaseCacheChunksIntoObjectPool(DiskRangeList current) {
        while (current != null) {
            if (current instanceof ProcCacheChunk) {
                EncodedReaderImpl.POOLS.pccPool.offer((ProcCacheChunk)current);
            } else if (current instanceof CacheChunk) {
                EncodedReaderImpl.POOLS.tccPool.offer((CacheChunk)current);
            }
            current = current.next;
        }
    }

    private void ponderReleaseInitialRefcount(long unlockUntilCOffset, long streamStartOffset, CacheChunk cc) {
        if (cc.getEnd() > unlockUntilCOffset) {
            return;
        }
        assert (cc.getBuffer() != null);
        try {
            this.releaseInitialRefcount(cc, false);
        }
        catch (AssertionError e) {
            LOG.error("BUG: releasing initial refcount; stream start " + streamStartOffset + ", unlocking until " + unlockUntilCOffset + " from [" + cc + "]: " + ((Throwable)((Object)e)).getMessage());
            throw e;
        }
        DiskRangeList prev = cc.prev;
        while (prev != null && prev.getEnd() > streamStartOffset && prev instanceof CacheChunk) {
            CacheChunk prevCc = (CacheChunk)prev;
            if (prevCc.buffer == null) break;
            try {
                this.releaseInitialRefcount(prevCc, true);
            }
            catch (AssertionError e) {
                LOG.error("BUG: releasing initial refcount; stream start " + streamStartOffset + ", unlocking until " + unlockUntilCOffset + " from [" + cc + "] and backtracked to [" + prevCc + "]: " + ((Throwable)((Object)e)).getMessage());
                throw e;
            }
            prev = prev.prev;
        }
    }

    private void releaseInitialRefcount(CacheChunk cc, boolean isBacktracking) {
        if (this.isTracingEnabled) {
            LOG.trace("Unlocking " + cc.getBuffer() + " for the fetching thread" + (isBacktracking ? "; backtracking" : ""));
        }
        this.cacheWrapper.releaseBuffer(cc.getBuffer());
        cc.setBuffer(null);
    }

    private void processCacheCollisions(long[] collisionMask, List<? extends CacheChunk> toDecompress, MemoryBuffer[] targetBuffers, List<MemoryBuffer> cacheBuffers) {
        if (collisionMask == null) {
            return;
        }
        assert (collisionMask.length >= toDecompress.size() >>> 6);
        long maskVal = -1L;
        for (int i = 0; i < toDecompress.size(); ++i) {
            if ((i & 0x3F) == 0) {
                maskVal = collisionMask[i >>> 6];
            }
            if ((maskVal & 1L) == 1L) {
                CacheChunk replacedChunk = toDecompress.get(i);
                MemoryBuffer replacementBuffer = targetBuffers[i];
                if (this.isTracingEnabled) {
                    LOG.trace("Discarding data due to cache collision: " + replacedChunk.getBuffer() + " replaced with " + replacementBuffer);
                }
                assert (replacedChunk.getBuffer() != replacementBuffer) : i + " was not replaced in the results even though mask is [" + Long.toBinaryString(maskVal) + "]";
                replacedChunk.handleCacheCollision(this.cacheWrapper, replacementBuffer, cacheBuffers);
            }
            maskVal >>= 1;
        }
    }

    private static DiskRangeList findExactPosition(DiskRangeList ranges, long offset) {
        if (offset < 0L) {
            return ranges;
        }
        return EncodedReaderImpl.findIntersectingPosition(ranges, offset, offset);
    }

    private static DiskRangeList findIntersectingPosition(DiskRangeList ranges, long offset, long end) {
        if (offset < 0L) {
            return ranges;
        }
        while (ranges.getEnd() <= offset) {
            ranges = ranges.next;
        }
        while (ranges.getOffset() > end) {
            ranges = ranges.prev;
        }
        while (ranges.prev != null && ranges.prev.getEnd() > offset) {
            ranges = ranges.prev;
        }
        return ranges;
    }

    private ProcCacheChunk addOneCompressionBuffer(BufferChunk current, List<MemoryBuffer> cacheBuffers, List<ProcCacheChunk> toDecompress, List<ByteBuffer> toRelease, List<IncompleteCb> badEstimates) throws IOException {
        DiskRangeList tmp;
        boolean isUncompressed;
        ByteBuffer slice = null;
        ByteBuffer compressed = current.getChunk();
        long cbStartOffset = current.getOffset();
        int b0 = compressed.get() & 0xFF;
        int b1 = compressed.get() & 0xFF;
        int b2 = compressed.get() & 0xFF;
        int chunkLength = b2 << 15 | b1 << 7 | b0 >> 1;
        if (chunkLength > this.bufferSize) {
            throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
        }
        int consumedLength = chunkLength + 3;
        long cbEndOffset = cbStartOffset + (long)consumedLength;
        boolean bl = isUncompressed = (b0 & 1) == 1;
        if (this.isTracingEnabled) {
            LOG.trace("Found CB at " + cbStartOffset + ", chunk length " + chunkLength + ", total " + consumedLength + ", " + (isUncompressed ? "not " : "") + "compressed");
        }
        if (compressed.remaining() >= chunkLength) {
            slice = compressed.slice();
            slice.limit(chunkLength);
            ProcCacheChunk cc = this.addOneCompressionBlockByteBuffer(slice, isUncompressed, cbStartOffset, cbEndOffset, chunkLength, current, toDecompress, cacheBuffers);
            if (compressed.remaining() <= 0 && this.dataReader.isTrackingDiskRanges()) {
                toRelease.add(compressed);
            }
            return cc;
        }
        if (current.getEnd() < cbEndOffset && !current.hasContiguousNext()) {
            badEstimates.add(this.addIncompleteCompressionBuffer(cbStartOffset, current, 0));
            return null;
        }
        ByteBuffer copy = EncodedReaderImpl.allocateBuffer(chunkLength, compressed.isDirect());
        int remaining = chunkLength - compressed.remaining();
        int originalPos = compressed.position();
        copy.put(compressed);
        if (this.isTracingEnabled) {
            LOG.trace("Removing partial CB " + current + " from ranges after copying its contents");
        }
        DiskRangeList next = current.next;
        current.removeSelf();
        if (this.dataReader.isTrackingDiskRanges()) {
            if (originalPos == 0) {
                this.dataReader.releaseBuffer(compressed);
            } else {
                toRelease.add(compressed);
            }
        }
        int extraChunkCount = 0;
        while (true) {
            if (!(next instanceof BufferChunk)) {
                throw new IOException("Trying to extend compressed block into uncompressed block " + next);
            }
            compressed = next.getData();
            ++extraChunkCount;
            if (compressed.remaining() >= remaining) {
                slice = compressed.slice();
                slice.limit(remaining);
                copy.put(slice);
                ProcCacheChunk cc = this.addOneCompressionBlockByteBuffer(copy, isUncompressed, cbStartOffset, cbEndOffset, remaining, (BufferChunk)next, toDecompress, cacheBuffers);
                if (compressed.remaining() <= 0 && this.dataReader.isTrackingDiskRanges()) {
                    this.dataReader.releaseBuffer(compressed);
                }
                return cc;
            }
            remaining -= compressed.remaining();
            copy.put(compressed);
            if (this.dataReader.isTrackingDiskRanges()) {
                this.dataReader.releaseBuffer(compressed);
            }
            tmp = next;
            DiskRangeList diskRangeList = next = next.hasContiguousNext() ? next.next : null;
            if (next == null) break;
            if (this.isTracingEnabled) {
                LOG.trace("Removing partial CB " + tmp + " from ranges after copying its contents");
            }
            tmp.removeSelf();
        }
        badEstimates.add(this.addIncompleteCompressionBuffer(cbStartOffset, tmp, extraChunkCount));
        return null;
    }

    private IncompleteCb addIncompleteCompressionBuffer(long cbStartOffset, DiskRangeList target, int extraChunkCount) {
        IncompleteCb icb = new IncompleteCb(cbStartOffset, target.getEnd());
        if (this.isTracingEnabled) {
            LOG.trace("Replacing " + target + " (and " + extraChunkCount + " previous chunks) with " + icb + " in the buffers");
        }
        target.replaceSelfWith(icb);
        return icb;
    }

    private ProcCacheChunk addOneCompressionBlockByteBuffer(ByteBuffer fullCompressionBlock, boolean isUncompressed, long cbStartOffset, long cbEndOffset, int lastChunkLength, BufferChunk lastChunk, List<ProcCacheChunk> toDecompress, List<MemoryBuffer> cacheBuffers) {
        MemoryBuffer futureAlloc = this.cacheWrapper.getAllocator().createUnallocated();
        cacheBuffers.add(futureAlloc);
        ProcCacheChunk cc = EncodedReaderImpl.POOLS.pccPool.take();
        cc.init(cbStartOffset, cbEndOffset, !isUncompressed, fullCompressionBlock, futureAlloc, cacheBuffers.size() - 1);
        toDecompress.add(cc);
        if (this.isTracingEnabled) {
            LOG.trace("Adjusting " + lastChunk + " to consume " + lastChunkLength + " compressed bytes");
        }
        lastChunk.getChunk().position(lastChunk.getChunk().position() + lastChunkLength);
        if (lastChunk.getChunk().remaining() <= 0) {
            if (this.isTracingEnabled) {
                LOG.trace("Replacing " + lastChunk + " with " + cc + " in the buffers");
            }
            lastChunk.replaceSelfWith(cc);
        } else {
            if (this.isTracingEnabled) {
                LOG.trace("Adding " + cc + " before " + lastChunk + " in the buffers");
            }
            lastChunk.insertPartBefore(cc);
        }
        return cc;
    }

    private static ByteBuffer allocateBuffer(int size, boolean isDirect) {
        return isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    private static Pools createPools(Reader.PoolFactory pf) {
        Pools pools = new Pools();
        pools.pccPool = pf.createPool(1024, new Pool.PoolObjectHelper<ProcCacheChunk>(){

            @Override
            public ProcCacheChunk create() {
                return new ProcCacheChunk();
            }

            @Override
            public void resetBeforeOffer(ProcCacheChunk t) {
                t.reset();
            }
        });
        pools.tccPool = pf.createPool(1024, new Pool.PoolObjectHelper<CacheChunk>(){

            @Override
            public CacheChunk create() {
                return new CacheChunk();
            }

            @Override
            public void resetBeforeOffer(CacheChunk t) {
                t.reset();
            }
        });
        pools.ecbPool = pf.createEncodedColumnBatchPool();
        pools.csdPool = pf.createColumnStreamDataPool();
        return pools;
    }

    static {
        CC_FACTORY = new DataCache.DiskRangeListFactory(){

            @Override
            public DiskRangeList createCacheChunk(MemoryBuffer buffer, long offset, long end) {
                CacheChunk tcc = POOLS.tccPool.take();
                tcc.init(buffer, offset, end);
                return tcc;
            }
        };
    }

    private static class NoopPoolFactory
    implements Reader.PoolFactory {
        private NoopPoolFactory() {
        }

        @Override
        public <T> Pool<T> createPool(final int size, final Pool.PoolObjectHelper<T> helper) {
            return new Pool<T>(){

                @Override
                public void offer(T t) {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public T take() {
                    return helper.create();
                }
            };
        }

        @Override
        public Pool<Reader.OrcEncodedColumnBatch> createEncodedColumnBatchPool() {
            return this.createPool(0, new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(){

                @Override
                public Reader.OrcEncodedColumnBatch create() {
                    return new Reader.OrcEncodedColumnBatch();
                }

                @Override
                public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
                }
            });
        }

        @Override
        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool() {
            return this.createPool(0, new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(){

                @Override
                public EncodedColumnBatch.ColumnStreamData create() {
                    return new EncodedColumnBatch.ColumnStreamData();
                }

                @Override
                public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
                }
            });
        }
    }

    private static class ProcCacheChunk
    extends CacheChunk {
        private ByteBuffer originalData = null;
        private boolean isOriginalDataCompressed;
        private int originalCbIndex;

        private ProcCacheChunk() {
        }

        public void init(long cbStartOffset, long cbEndOffset, boolean isCompressed, ByteBuffer originalData, MemoryBuffer targetBuffer, int originalCbIndex) {
            super.init(targetBuffer, cbStartOffset, cbEndOffset);
            this.isOriginalDataCompressed = isCompressed;
            this.originalData = originalData;
            this.originalCbIndex = originalCbIndex;
        }

        @Override
        public void reset() {
            super.reset();
            this.originalData = null;
        }

        @Override
        public String toString() {
            return super.toString() + ", original is set " + (this.originalData != null) + ", buffer was replaced " + (this.originalCbIndex == -1);
        }

        @Override
        public void handleCacheCollision(DataCache cacheWrapper, MemoryBuffer replacementBuffer, List<MemoryBuffer> cacheBuffers) {
            assert (this.originalCbIndex >= 0);
            cacheWrapper.getAllocator().deallocate(this.getBuffer());
            cacheWrapper.reuseBuffer(replacementBuffer);
            this.buffer = replacementBuffer;
            cacheBuffers.set(this.originalCbIndex, replacementBuffer);
            this.originalCbIndex = -1;
        }
    }

    private static class UncompressedCacheChunk
    extends CacheChunk {
        private BufferChunk chunk;
        private int count;

        public UncompressedCacheChunk(BufferChunk bc) {
            this.init(null, bc.getOffset(), bc.getEnd());
            this.chunk = bc;
            this.count = 1;
        }

        public void addChunk(BufferChunk bc) {
            assert (bc.getOffset() == this.getEnd());
            this.end = bc.getEnd();
            ++this.count;
        }

        public BufferChunk getChunk() {
            return this.chunk;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void handleCacheCollision(DataCache cacheWrapper, MemoryBuffer replacementBuffer, List<MemoryBuffer> cacheBuffers) {
            assert (cacheBuffers == null);
            cacheWrapper.getAllocator().deallocate(this.getBuffer());
            this.setBuffer(replacementBuffer);
        }

        public void clear() {
            this.chunk = null;
            this.count = -1;
        }
    }

    private static final class StreamContext {
        public long offset;
        public long length;
        public int streamIndexOffset;
        public OrcProto.Stream.Kind kind;
        DiskRangeList bufferIter;
        EncodedColumnBatch.ColumnStreamData stripeLevelStream;

        public StreamContext(OrcProto.Stream stream, long streamOffset, int streamIndexOffset) {
            this.kind = stream.getKind();
            this.length = stream.getLength();
            this.offset = streamOffset;
            this.streamIndexOffset = streamIndexOffset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" kind: ").append(this.kind);
            sb.append(" offset: ").append(this.offset);
            sb.append(" length: ").append(this.length);
            sb.append(" index_offset: ").append(this.streamIndexOffset);
            return sb.toString();
        }
    }

    private static final class ColumnReadContext {
        public static final int MAX_STREAMS = 6;
        int streamCount = 0;
        final StreamContext[] streams = new StreamContext[6];
        OrcProto.ColumnEncoding encoding;
        OrcProto.RowIndex rowIndex;
        int colIx;

        public ColumnReadContext(int colIx, OrcProto.ColumnEncoding encoding, OrcProto.RowIndex rowIndex) {
            this.encoding = encoding;
            this.rowIndex = rowIndex;
            this.colIx = colIx;
            this.streamCount = 0;
        }

        public void addStream(long offset, OrcProto.Stream stream, int indexIx) {
            this.streams[this.streamCount++] = new StreamContext(stream, offset, indexIx);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" column_index: ").append(this.colIx);
            sb.append(" encoding: ").append(this.encoding);
            sb.append(" stream_count: ").append(this.streamCount);
            int i = 0;
            for (StreamContext sc : this.streams) {
                if (sc != null) {
                    sb.append(" stream_").append(i).append(":").append(sc.toString());
                }
                ++i;
            }
            return sb.toString();
        }
    }

    private static class Pools {
        Pool<CacheChunk> tccPool;
        Pool<ProcCacheChunk> pccPool;
        Pool<Reader.OrcEncodedColumnBatch> ecbPool;
        Pool<EncodedColumnBatch.ColumnStreamData> csdPool;

        private Pools() {
        }
    }
}

