/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ASTBuilder {
    ASTNode curr;

    public static ASTBuilder construct(int tokenType, String text) {
        ASTBuilder b = new ASTBuilder();
        b.curr = ASTBuilder.createAST(tokenType, text);
        return b;
    }

    public static ASTNode createAST(int tokenType, String text) {
        return (ASTNode)ParseDriver.adaptor.create(tokenType, text);
    }

    public static ASTNode destNode() {
        return ASTBuilder.construct(737, "TOK_DESTINATION").add(ASTBuilder.construct(739, "TOK_DIR").add(980, "TOK_TMP_FILE")).node();
    }

    public static ASTNode table(RelNode scan) {
        RelOptHiveTable hTbl = (RelOptHiveTable)scan.getTable();
        ASTBuilder b = ASTBuilder.construct(971, "TOK_TABREF").add(ASTBuilder.construct(970, "TOK_TABNAME").add(27, hTbl.getHiveTableMD().getDbName()).add(27, hTbl.getHiveTableMD().getTableName()));
        if (((HiveTableScan)scan).isInsideView()) {
            b.add(ASTBuilder.construct(955, "TOK_TABLEPROPERTIES").add(ASTBuilder.construct(957, "TOK_TABLEPROPLIST").add(ASTBuilder.construct(956, "TOK_TABLEPROPERTY").add(353, "\"insideView\"").add(353, "\"TRUE\""))));
        }
        b.add(27, ((HiveTableScan)scan).getTableAlias());
        return b.node();
    }

    public static ASTNode join(ASTNode left, ASTNode right, JoinRelType joinType, ASTNode cond, boolean semiJoin) {
        ASTBuilder b = null;
        switch (joinType) {
            case INNER: {
                if (semiJoin) {
                    b = ASTBuilder.construct(807, "TOK_LEFTSEMIJOIN");
                    break;
                }
                b = ASTBuilder.construct(803, "TOK_JOIN");
                break;
            }
            case LEFT: {
                b = ASTBuilder.construct(806, "TOK_LEFTOUTERJOIN");
                break;
            }
            case RIGHT: {
                b = ASTBuilder.construct(888, "TOK_RIGHTOUTERJOIN");
                break;
            }
            case FULL: {
                b = ASTBuilder.construct(762, "TOK_FULLOUTERJOIN");
            }
        }
        b.add(left).add(right).add(cond);
        return b.node();
    }

    public static ASTNode subQuery(ASTNode qry, String alias) {
        return ASTBuilder.construct(935, "TOK_SUBQUERY").add(qry).add(27, alias).node();
    }

    public static ASTNode qualifiedName(String tableName, String colName) {
        ASTBuilder b = ASTBuilder.construct(18, ".").add(ASTBuilder.construct(967, "TOK_TABLE_OR_COL").add(27, tableName)).add(27, colName);
        return b.node();
    }

    public static ASTNode unqualifiedName(String colName) {
        ASTBuilder b = ASTBuilder.construct(967, "TOK_TABLE_OR_COL").add(27, colName);
        return b.node();
    }

    public static ASTNode where(ASTNode cond) {
        return ASTBuilder.construct(1005, "TOK_WHERE").add(cond).node();
    }

    public static ASTNode having(ASTNode cond) {
        return ASTBuilder.construct(775, "TOK_HAVING").add(cond).node();
    }

    public static ASTNode limit(Object offset, Object limit) {
        return ASTBuilder.construct(810, "TOK_LIMIT").add(342, offset.toString()).add(342, limit.toString()).node();
    }

    public static ASTNode selectExpr(ASTNode expr, String alias) {
        return ASTBuilder.construct(895, "TOK_SELEXPR").add(expr).add(27, alias).node();
    }

    public static ASTNode literal(RexLiteral literal) {
        return ASTBuilder.literal(literal, false);
    }

    public static ASTNode literal(RexLiteral literal, boolean useTypeQualInLiteral) {
        Object val = null;
        int type = 0;
        SqlTypeName sqlType = literal.getType().getSqlTypeName();
        switch (sqlType) {
            case BINARY: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_MONTH: 
            case INTERVAL_SECOND: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: {
                if (literal.getValue() != null) break;
                return ASTBuilder.construct(824, "TOK_NULL").node();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case DECIMAL: 
            case FLOAT: 
            case REAL: 
            case VARCHAR: 
            case CHAR: 
            case BOOLEAN: {
                if (literal.getValue3() != null) break;
                return ASTBuilder.construct(824, "TOK_NULL").node();
            }
        }
        switch (sqlType) {
            case TINYINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "Y" : literal.getValue3();
                type = 355;
                break;
            }
            case SMALLINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "S" : literal.getValue3();
                type = 352;
                break;
            }
            case INTEGER: {
                val = literal.getValue3();
                type = 7;
                break;
            }
            case BIGINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "L" : literal.getValue3();
                type = 7;
                break;
            }
            case DOUBLE: {
                val = literal.getValue3() + "D";
                type = 342;
                break;
            }
            case DECIMAL: {
                val = literal.getValue3() + "BD";
                type = 19;
                break;
            }
            case FLOAT: 
            case REAL: {
                val = literal.getValue3();
                type = 342;
                break;
            }
            case VARCHAR: 
            case CHAR: {
                val = literal.getValue3();
                String escapedVal = BaseSemanticAnalyzer.escapeSQLString(String.valueOf(val));
                type = 353;
                val = "'" + escapedVal + "'";
                break;
            }
            case BOOLEAN: {
                val = literal.getValue3();
                type = (Boolean)val != false ? 298 : 119;
                break;
            }
            case DATE: {
                Calendar c = (Calendar)literal.getValue();
                DateTime dt = new DateTime(c.getTimeInMillis(), DateTimeZone.forTimeZone(c.getTimeZone()));
                type = 727;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                val = df.format(dt.toDateTime(DateTimeZone.getDefault()).toDate());
                val = "'" + val + "'";
                break;
            }
            case TIME: 
            case TIMESTAMP: {
                Calendar c = (Calendar)literal.getValue();
                DateTime dt = new DateTime(c.getTimeInMillis(), DateTimeZone.forTimeZone(c.getTimeZone()));
                type = 978;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                val = df.format(dt.toDateTime(DateTimeZone.getDefault()).toDate());
                val = "'" + val + "'";
                break;
            }
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: {
                type = 797;
                BigDecimal monthsBd = (BigDecimal)literal.getValue();
                HiveIntervalYearMonth intervalYearMonth = new HiveIntervalYearMonth(monthsBd.intValue());
                val = "'" + intervalYearMonth.toString() + "'";
                break;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                type = 790;
                BigDecimal millisBd = (BigDecimal)literal.getValue();
                BigDecimal secsBd = millisBd.divide(BigDecimal.valueOf(1000L));
                HiveIntervalDayTime intervalDayTime = new HiveIntervalDayTime(secsBd);
                val = "'" + intervalDayTime.toString() + "'";
                break;
            }
            case NULL: {
                type = 824;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Type: " + sqlType);
            }
        }
        return (ASTNode)ParseDriver.adaptor.create(type, String.valueOf(val));
    }

    public ASTNode node() {
        return this.curr;
    }

    public ASTBuilder add(int tokenType, String text) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)ASTBuilder.createAST(tokenType, text));
        return this;
    }

    public ASTBuilder add(ASTBuilder b) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)b.curr);
        return this;
    }

    public ASTBuilder add(ASTNode n) {
        if (n != null) {
            ParseDriver.adaptor.addChild((Object)this.curr, (Object)n);
        }
        return this;
    }
}

