/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.org.apache.commons.lang.ObjectUtils;

public class ImportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    public static final String METADATA_NAME = "_metadata";
    private boolean tableExists = false;

    public ImportSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    public boolean existsTable() {
        return this.tableExists;
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        try {
            Tree fromTree = ast.getChild(0);
            boolean isLocationSet = false;
            boolean isExternalSet = false;
            boolean isTableSet = false;
            boolean isDbNameSet = false;
            boolean isPartSpecSet = false;
            String parsedLocation = null;
            String parsedTableName = null;
            String parsedDbName = null;
            LinkedHashMap<String, String> parsedPartSpec = new LinkedHashMap<String, String>();
            block10: for (int i = 1; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                switch (child.getToken().getType()) {
                    case 117: {
                        isExternalSet = true;
                        continue block10;
                    }
                    case 953: {
                        isLocationSet = true;
                        parsedLocation = EximUtil.relativeToAbsolutePath(this.conf, ImportSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                        continue block10;
                    }
                    case 942: {
                        isTableSet = true;
                        ASTNode tableNameNode = (ASTNode)child.getChild(0);
                        Map.Entry<String, String> dbTablePair = ImportSemanticAnalyzer.getDbTableNamePair(tableNameNode);
                        parsedDbName = dbTablePair.getKey();
                        parsedTableName = dbTablePair.getValue();
                        if (parsedDbName != null) {
                            isDbNameSet = true;
                        }
                        if (child.getChildCount() != 2) continue block10;
                        ASTNode partspec = (ASTNode)child.getChild(1);
                        isPartSpecSet = true;
                        this.parsePartitionSpec(child, parsedPartSpec);
                    }
                }
            }
            URI fromURI = EximUtil.getValidatedURI(this.conf, ImportSemanticAnalyzer.stripQuotes(fromTree.getText()));
            FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)this.conf);
            Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
            this.inputs.add(this.toReadEntity(fromPath));
            EximUtil.ReadMetaData rv = new EximUtil.ReadMetaData();
            try {
                rv = EximUtil.readMetaData(fs, new Path(fromPath, METADATA_NAME));
            }
            catch (IOException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
            }
            ReplicationSpec replicationSpec = rv.getReplicationSpec();
            if (replicationSpec.isNoop()) {
                return;
            }
            String dbname = SessionState.get().getCurrentDatabase();
            if (isDbNameSet) {
                dbname = parsedDbName;
            }
            CreateTableDesc tblDesc = this.getBaseCreateTableDescFromTable(dbname, rv.getTable());
            if (isExternalSet) {
                tblDesc.setExternal(isExternalSet);
            }
            if (isLocationSet) {
                tblDesc.setLocation(parsedLocation);
                this.inputs.add(this.toReadEntity(parsedLocation));
            }
            if (isTableSet) {
                tblDesc.setTableName(parsedTableName);
            }
            ArrayList<AddPartitionDesc> partitionDescs = new ArrayList<AddPartitionDesc>();
            Iterable<org.apache.hadoop.hive.metastore.api.Partition> partitions = rv.getPartitions();
            for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
                AddPartitionDesc partsDesc = this.getBaseAddPartitionDescFromPartition(fromPath, dbname, tblDesc, partition);
                partitionDescs.add(partsDesc);
            }
            if (isPartSpecSet) {
                boolean found = false;
                ListIterator partnIter = partitionDescs.listIterator();
                while (partnIter.hasNext()) {
                    AddPartitionDesc addPartitionDesc = (AddPartitionDesc)partnIter.next();
                    if (!found && addPartitionDesc.getPartition(0).getPartSpec().equals(parsedPartSpec)) {
                        found = true;
                        continue;
                    }
                    partnIter.remove();
                }
                if (!found) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Specified partition not found in import directory"));
                }
            }
            if (tblDesc.getTableName() == null) {
                throw new SemanticException(ErrorMsg.NEED_TABLE_SPECIFICATION.getMsg());
            }
            this.conf.set("import.destination.table", tblDesc.getTableName());
            for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                addPartitionDesc.setTableName(tblDesc.getTableName());
            }
            Warehouse wh = new Warehouse(this.conf);
            Table table = this.tableIfExists(tblDesc);
            if (table != null) {
                this.checkTable(table, tblDesc, replicationSpec);
                this.LOG.debug("table " + tblDesc.getTableName() + " exists: metadata checked");
                this.tableExists = true;
            }
            if (!replicationSpec.isInReplicationScope()) {
                this.createRegularImportTasks(this.rootTasks, tblDesc, partitionDescs, isPartSpecSet, replicationSpec, table, fromURI, fs, wh);
            } else {
                this.createReplImportTasks(this.rootTasks, tblDesc, partitionDescs, isPartSpecSet, replicationSpec, table, fromURI, fs, wh);
            }
        }
        catch (SemanticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.IMPORT_SEMANTIC_ERROR.getMsg(), e);
        }
    }

    private void parsePartitionSpec(ASTNode tableNode, LinkedHashMap<String, String> partSpec) throws SemanticException {
        if (tableNode.getChildCount() == 2) {
            ASTNode partspec = (ASTNode)tableNode.getChild(1);
            for (int j = 0; j < partspec.getChildCount(); ++j) {
                ASTNode partspec_val = (ASTNode)partspec.getChild(j);
                String val = null;
                String colName = ImportSemanticAnalyzer.unescapeIdentifier(partspec_val.getChild(0).getText().toLowerCase());
                if (partspec_val.getChildCount() < 2) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                }
                val = ImportSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                partSpec.put(colName, val);
            }
        }
    }

    private AddPartitionDesc getBaseAddPartitionDescFromPartition(Path fromPath, String dbname, CreateTableDesc tblDesc, org.apache.hadoop.hive.metastore.api.Partition partition) throws MetaException {
        AddPartitionDesc partsDesc = new AddPartitionDesc(dbname, tblDesc.getTableName(), EximUtil.makePartSpec(tblDesc.getPartCols(), partition.getValues()), partition.getSd().getLocation(), partition.getParameters());
        AddPartitionDesc.OnePartitionDesc partDesc = partsDesc.getPartition(0);
        partDesc.setInputFormat(partition.getSd().getInputFormat());
        partDesc.setOutputFormat(partition.getSd().getOutputFormat());
        partDesc.setNumBuckets(partition.getSd().getNumBuckets());
        partDesc.setCols(partition.getSd().getCols());
        partDesc.setSerializationLib(partition.getSd().getSerdeInfo().getSerializationLib());
        partDesc.setSerdeParams(partition.getSd().getSerdeInfo().getParameters());
        partDesc.setBucketCols(partition.getSd().getBucketCols());
        partDesc.setSortCols(partition.getSd().getSortCols());
        partDesc.setLocation(new Path(fromPath, Warehouse.makePartName(tblDesc.getPartCols(), partition.getValues())).toString());
        return partsDesc;
    }

    private CreateTableDesc getBaseCreateTableDescFromTable(String dbName, org.apache.hadoop.hive.metastore.api.Table table) {
        if (table.getPartitionKeys() == null || table.getPartitionKeys().size() == 0) {
            table.putToParameters("DO_NOT_UPDATE_STATS", "true");
        }
        CreateTableDesc tblDesc = new CreateTableDesc(dbName, table.getTableName(), false, table.isTemporary(), table.getSd().getCols(), table.getPartitionKeys(), table.getSd().getBucketCols(), table.getSd().getSortCols(), table.getSd().getNumBuckets(), null, null, null, null, null, null, table.getSd().getInputFormat(), table.getSd().getOutputFormat(), null, table.getSd().getSerdeInfo().getSerializationLib(), null, table.getSd().getSerdeInfo().getParameters(), table.getParameters(), false, null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColNames(), null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColValues(), null, null);
        tblDesc.setStoredAsSubDirectories(table.getSd().isStoredAsSubDirectories());
        return tblDesc;
    }

    private Task<?> loadTable(URI fromURI, Table table, boolean replace, Path tgtPath) {
        Path dataPath = new Path(fromURI.toString(), "data");
        Path tmpPath = this.ctx.getExternalTmpPath(tgtPath);
        Task<CopyWork> copyTask = TaskFactory.get(new CopyWork(dataPath, tmpPath, false), this.conf, new Task[0]);
        LoadTableDesc loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), new TreeMap<String, String>(), replace);
        Task<MoveWork> loadTableTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, false), this.conf, new Task[0]);
        copyTask.addDependentTask(loadTableTask);
        this.rootTasks.add(copyTask);
        return loadTableTask;
    }

    private Task<?> createTableTask(CreateTableDesc tableDesc) {
        return TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), tableDesc), this.conf, new Task[0]);
    }

    private Task<?> dropTableTask(Table table) {
        return TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), new DropTableDesc(table.getTableName(), false, true, true, null)), this.conf, new Task[0]);
    }

    private Task<? extends Serializable> alterTableTask(CreateTableDesc tableDesc) {
        tableDesc.setReplaceMode(true);
        return TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), tableDesc), this.conf, new Task[0]);
    }

    private Task<? extends Serializable> alterSinglePartition(URI fromURI, FileSystem fs, CreateTableDesc tblDesc, Table table, Warehouse wh, AddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec, Partition ptn) {
        addPartitionDesc.setReplaceMode(true);
        addPartitionDesc.getPartition(0).setLocation(ptn.getLocation());
        return TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]);
    }

    private Task<?> addSinglePartition(URI fromURI, FileSystem fs, CreateTableDesc tblDesc, Table table, Warehouse wh, AddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec) throws MetaException, IOException, HiveException {
        AddPartitionDesc.OnePartitionDesc partSpec = addPartitionDesc.getPartition(0);
        if (tblDesc.isExternal() && tblDesc.getLocation() == null) {
            this.LOG.debug("Importing in-place: adding AddPart for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()));
            Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]);
            return addPartTask;
        }
        String srcLocation = partSpec.getLocation();
        this.fixLocationInPartSpec(fs, tblDesc, table, wh, replicationSpec, partSpec);
        this.LOG.debug("adding dependent CopyWork/AddPart/MoveWork for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + " with source location: " + srcLocation);
        Path tgtLocation = new Path(partSpec.getLocation());
        Path tmpPath = this.ctx.getExternalTmpPath(tgtLocation);
        Task<CopyWork> copyTask = TaskFactory.get(new CopyWork(new Path(srcLocation), tmpPath, false), this.conf, new Task[0]);
        Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]);
        LoadTableDesc loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), partSpec.getPartSpec(), true);
        loadTableWork.setInheritTableSpecs(false);
        Task<MoveWork> loadPartTask = TaskFactory.get(new MoveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, false), this.conf, new Task[0]);
        copyTask.addDependentTask(loadPartTask);
        addPartTask.addDependentTask(loadPartTask);
        this.rootTasks.add(copyTask);
        return addPartTask;
    }

    private void fixLocationInPartSpec(FileSystem fs, CreateTableDesc tblDesc, Table table, Warehouse wh, ReplicationSpec replicationSpec, AddPartitionDesc.OnePartitionDesc partSpec) throws MetaException, HiveException, IOException {
        Path tgtPath = null;
        if (tblDesc.getLocation() == null) {
            if (table.getDataLocation() != null) {
                tgtPath = new Path(table.getDataLocation().toString(), Warehouse.makePartPath(partSpec.getPartSpec()));
            } else {
                Database parentDb = this.db.getDatabase(tblDesc.getDatabaseName());
                tgtPath = new Path(wh.getTablePath(parentDb, tblDesc.getTableName()), Warehouse.makePartPath(partSpec.getPartSpec()));
            }
        } else {
            tgtPath = new Path(tblDesc.getLocation(), Warehouse.makePartPath(partSpec.getPartSpec()));
        }
        FileSystem tgtFs = FileSystem.get((URI)tgtPath.toUri(), (Configuration)this.conf);
        this.checkTargetLocationEmpty(tgtFs, tgtPath, replicationSpec);
        partSpec.setLocation(tgtPath.toString());
    }

    private void checkTargetLocationEmpty(FileSystem fs, Path targetPath, ReplicationSpec replicationSpec) throws IOException, SemanticException {
        FileStatus[] status;
        if (replicationSpec.isInReplicationScope()) {
            return;
        }
        this.LOG.debug("checking emptiness of " + targetPath.toString());
        if (fs.exists(targetPath) && (status = fs.listStatus(targetPath, FileUtils.HIDDEN_FILES_PATH_FILTER)).length > 0) {
            this.LOG.debug("Files inc. " + status[0].getPath().toString() + " found in path : " + targetPath.toString());
            throw new SemanticException(ErrorMsg.TABLE_DATA_EXISTS.getMsg());
        }
    }

    private static String partSpecToString(Map<String, String> partSpec) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            if (!firstTime) {
                sb.append(',');
            }
            firstTime = false;
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private void checkTable(Table table, CreateTableDesc tableDesc, ReplicationSpec replicationSpec) throws SemanticException, URISyntaxException {
        String importedSerde;
        Map<String, String> importedTableParams;
        if (replicationSpec.isInReplicationScope()) {
            return;
        }
        if (table.getParameters().containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString()) && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_EXIM_RESTRICT_IMPORTS_INTO_REPLICATED_TABLES)) {
            throw new SemanticException(ErrorMsg.IMPORT_INTO_STRICT_REPL_TABLE.getMsg("Table " + table.getTableName() + " has repl.last.id parameter set."));
        }
        EximUtil.validateTable(table);
        if (!(!tableDesc.isExternal() || table.isPartitioned() && table.getTableType().equals((Object)TableType.EXTERNAL_TABLE))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" External table cannot overwrite existing table. Drop existing table first."));
        }
        if (tableDesc.getLocation() != null && !table.isPartitioned() && !table.getDataLocation().equals((Object)new Path(tableDesc.getLocation()))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Location does not match"));
        }
        List<FieldSchema> existingTableCols = table.getCols();
        List<FieldSchema> importedTableCols = tableDesc.getCols();
        if (!EximUtil.schemaCompare(importedTableCols, existingTableCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Column Schema does not match"));
        }
        List<FieldSchema> existingTablePartCols = table.getPartCols();
        List<FieldSchema> importedTablePartCols = tableDesc.getPartCols();
        if (!EximUtil.schemaCompare(importedTablePartCols, existingTablePartCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Partition Schema does not match"));
        }
        Map<String, String> existingTableParams = table.getParameters();
        String error = ImportSemanticAnalyzer.checkParams(existingTableParams, importedTableParams = tableDesc.getTblProps(), new String[]{"howl.isd", "howl.osd"});
        if (error != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table parameters do not match: " + error));
        }
        String existingifc = table.getInputFormatClass().getName();
        String importedifc = tableDesc.getInputFormat();
        String existingofc = table.getOutputFormatClass().getName();
        String importedofc = tableDesc.getOutputFormat();
        try {
            Class<?> origin = Class.forName(importedofc, true, Utilities.getSessionSpecifiedClassLoader());
            Class<? extends OutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
            if (replaced == null) {
                throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
            }
            importedofc = replaced.getCanonicalName();
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
        }
        if (!existingifc.equals(importedifc) || !existingofc.equals(importedofc)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table inputformat/outputformats do not match"));
        }
        String existingSerde = table.getSerializationLib();
        if (!existingSerde.equals(importedSerde = tableDesc.getSerName())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde class does not match"));
        }
        String existingSerdeFormat = table.getSerdeParam("serialization.format");
        String importedSerdeFormat = tableDesc.getSerdeProps().get("serialization.format");
        String string = importedSerdeFormat = importedSerdeFormat == null ? "1" : importedSerdeFormat;
        if (!ObjectUtils.equals(existingSerdeFormat, importedSerdeFormat)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde format does not match"));
        }
        if (!ObjectUtils.equals(table.getBucketCols(), tableDesc.getBucketCols())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table bucketing spec does not match"));
        }
        List<Order> existingOrder = table.getSortCols();
        List<Order> importedOrder = tableDesc.getSortCols();
        if (existingOrder != null) {
            if (importedOrder != null) {
                final class OrderComparator
                implements Comparator<Order> {
                    OrderComparator() {
                    }

                    @Override
                    public int compare(Order o1, Order o2) {
                        if (o1.getOrder() < o2.getOrder()) {
                            return -1;
                        }
                        if (o1.getOrder() == o2.getOrder()) {
                            return 0;
                        }
                        return 1;
                    }
                }
                Collections.sort(existingOrder, new OrderComparator());
                Collections.sort(importedOrder, new OrderComparator());
                if (!existingOrder.equals(importedOrder)) {
                    throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
                }
            }
        } else if (importedOrder != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
        }
    }

    private static String checkParams(Map<String, String> map1, Map<String, String> map2, String[] keys) {
        block6: {
            block5: {
                if (map1 == null) break block5;
                if (map2 != null) {
                    for (String key : keys) {
                        String v2;
                        String v1 = map1.get(key);
                        if (ObjectUtils.equals(v1, v2 = map2.get(key))) continue;
                        return "Mismatch for " + key;
                    }
                } else {
                    for (String key : keys) {
                        if (map1.get(key) == null) continue;
                        return "Mismatch for " + key;
                    }
                }
                break block6;
            }
            if (map2 == null) break block6;
            for (String key : keys) {
                if (map2.get(key) == null) continue;
                return "Mismatch for " + key;
            }
        }
        return null;
    }

    private void createRegularImportTasks(List<Task<? extends Serializable>> rootTasks, CreateTableDesc tblDesc, List<AddPartitionDesc> partitionDescs, boolean isPartSpecSet, ReplicationSpec replicationSpec, Table table, URI fromURI, FileSystem fs, Warehouse wh) throws HiveException, URISyntaxException, IOException, MetaException {
        if (table != null) {
            if (table.isPartitioned()) {
                this.LOG.debug("table partitioned");
                for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                    Map<String, String> partSpec = addPartitionDesc.getPartition(0).getPartSpec();
                    Partition ptn = null;
                    ptn = this.db.getPartition(table, partSpec, false);
                    if (ptn == null) {
                        rootTasks.add(this.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec));
                        continue;
                    }
                    throw new SemanticException(ErrorMsg.PARTITION_EXISTS.getMsg(ImportSemanticAnalyzer.partSpecToString(partSpec)));
                }
            } else {
                this.LOG.debug("table non-partitioned");
                Path tgtPath = new Path(table.getDataLocation().toString());
                FileSystem tgtFs = FileSystem.get((URI)tgtPath.toUri(), (Configuration)this.conf);
                this.checkTargetLocationEmpty(tgtFs, tgtPath, replicationSpec);
                this.loadTable(fromURI, table, false, tgtPath);
            }
            this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            this.LOG.debug("table " + tblDesc.getTableName() + " does not exist");
            Task<DDLWork> t = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), tblDesc), this.conf, new Task[0]);
            table = new Table(tblDesc.getDatabaseName(), tblDesc.getTableName());
            Database parentDb = this.db.getDatabase(tblDesc.getDatabaseName());
            this.outputs.add(new WriteEntity(parentDb, WriteEntity.WriteType.DDL_SHARED));
            if (this.isPartitioned(tblDesc)) {
                for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                    t.addDependentTask(this.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec));
                }
            } else {
                this.LOG.debug("adding dependent CopyWork/MoveWork for table");
                if (tblDesc.isExternal() && tblDesc.getLocation() == null) {
                    this.LOG.debug("Importing in place, no emptiness check, no copying/loading");
                    Path dataPath = new Path(fromURI.toString(), "data");
                    tblDesc.setLocation(dataPath.toString());
                } else {
                    Path tablePath = null;
                    tablePath = tblDesc.getLocation() != null ? new Path(tblDesc.getLocation()) : wh.getTablePath(parentDb, tblDesc.getTableName());
                    FileSystem tgtFs = FileSystem.get((URI)tablePath.toUri(), (Configuration)this.conf);
                    this.checkTargetLocationEmpty(tgtFs, tablePath, replicationSpec);
                    t.addDependentTask(this.loadTable(fromURI, table, false, tablePath));
                }
            }
            rootTasks.add(t);
        }
    }

    private void createReplImportTasks(List<Task<? extends Serializable>> rootTasks, CreateTableDesc tblDesc, List<AddPartitionDesc> partitionDescs, boolean isPartSpecSet, ReplicationSpec replicationSpec, Table table, URI fromURI, FileSystem fs, Warehouse wh) throws HiveException, URISyntaxException, IOException, MetaException {
        Database parentDb;
        Task<?> dr = null;
        WriteEntity.WriteType lockType = WriteEntity.WriteType.DDL_NO_LOCK;
        if (table != null && this.isPartitioned(tblDesc) != table.isPartitioned()) {
            if (replicationSpec.allowReplacementInto(table)) {
                dr = this.dropTableTask(table);
                lockType = WriteEntity.WriteType.DDL_EXCLUSIVE;
                table = null;
            } else {
                return;
            }
        }
        if ((parentDb = this.db.getDatabase(tblDesc.getDatabaseName())) == null) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(tblDesc.getDatabaseName()));
        }
        if (tblDesc.getLocation() == null) {
            tblDesc.setLocation(wh.getTablePath(parentDb, tblDesc.getTableName()).toString());
        }
        if (table == null) {
            if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                lockType = WriteEntity.WriteType.DDL_SHARED;
            }
            Task<?> t = this.createTableTask(tblDesc);
            table = new Table(tblDesc.getDatabaseName(), tblDesc.getTableName());
            if (!replicationSpec.isMetadataOnly()) {
                if (this.isPartitioned(tblDesc)) {
                    for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                        t.addDependentTask(this.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec));
                    }
                } else {
                    this.LOG.debug("adding dependent CopyWork/MoveWork for table");
                    t.addDependentTask(this.loadTable(fromURI, table, true, new Path(tblDesc.getLocation())));
                }
            }
            if (dr == null) {
                rootTasks.add(t);
            } else {
                dr.addDependentTask(t);
                rootTasks.add(dr);
            }
        } else if (table.isPartitioned()) {
            this.LOG.debug("table partitioned");
            for (AddPartitionDesc addPartitionDesc : partitionDescs) {
                Map<String, String> partSpec = addPartitionDesc.getPartition(0).getPartSpec();
                Partition ptn = null;
                ptn = this.db.getPartition(table, partSpec, false);
                if (ptn == null) {
                    if (replicationSpec.isMetadataOnly()) continue;
                    rootTasks.add(this.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec));
                    continue;
                }
                if (!replicationSpec.allowReplacementInto(ptn)) continue;
                if (!replicationSpec.isMetadataOnly()) {
                    rootTasks.add(this.addSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec));
                } else {
                    rootTasks.add(this.alterSinglePartition(fromURI, fs, tblDesc, table, wh, addPartitionDesc, replicationSpec, ptn));
                }
                if (lockType != WriteEntity.WriteType.DDL_NO_LOCK) continue;
                lockType = WriteEntity.WriteType.DDL_SHARED;
            }
            if (replicationSpec.isMetadataOnly() && partitionDescs.isEmpty()) {
                rootTasks.add(this.alterTableTask(tblDesc));
                if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                    lockType = WriteEntity.WriteType.DDL_SHARED;
                }
            }
        } else {
            this.LOG.debug("table non-partitioned");
            if (!replicationSpec.allowReplacementInto(table)) {
                return;
            }
            if (!replicationSpec.isMetadataOnly()) {
                this.loadTable(fromURI, table, true, new Path(fromURI));
            } else {
                rootTasks.add(this.alterTableTask(tblDesc));
            }
            if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                lockType = WriteEntity.WriteType.DDL_SHARED;
            }
        }
        this.outputs.add(new WriteEntity(table, lockType));
    }

    private boolean isPartitioned(CreateTableDesc tblDesc) {
        return tblDesc.getPartCols() != null && !tblDesc.getPartCols().isEmpty();
    }

    private Table tableIfExists(CreateTableDesc tblDesc) throws HiveException {
        try {
            return this.db.getTable(tblDesc.getDatabaseName(), tblDesc.getTableName());
        }
        catch (InvalidTableException e) {
            return null;
        }
    }
}

