/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddResourceProcessor
implements CommandProcessor {
    public static final Logger LOG = LoggerFactory.getLogger((String)AddResourceProcessor.class.getName());
    public static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);

    @Override
    public void init() {
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState.ResourceType t;
        SessionState ss = SessionState.get();
        command = new VariableSubstitution(new HiveVariableSource(){

            @Override
            public Map<String, String> getHiveVariable() {
                return SessionState.get().getHiveVariables();
            }
        }).substitute(ss.getConf(), command);
        String[] tokens = command.split("\\s+");
        if (tokens.length < 2 || (t = SessionState.find_resource_type(tokens[0])) == null) {
            console.printError("Usage: add [" + StringUtils.join((Object[])SessionState.ResourceType.values(), "|") + "] <value> [<value>]*");
            return new CommandProcessorResponse(1);
        }
        CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.ADD, Arrays.asList(tokens));
        if (authErrResp != null) {
            return authErrResp;
        }
        try {
            ss.add_resources(t, Arrays.asList(Arrays.copyOfRange(tokens, 1, tokens.length)));
        }
        catch (Exception e) {
            return CommandProcessorResponse.create(e);
        }
        return new CommandProcessorResponse(0);
    }
}

