/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColModuloLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColModuloLongColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColModuloDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColModuloDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarModuloDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloDoubleColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloDoubleScalarChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloLongColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColModuloLongScalarChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarModuloDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarModuloDoubleColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarModuloLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarModuloLongColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColModuloDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColModuloDoubleColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColModuloDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColModuloDoubleScalarChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColModuloLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColModuloLongScalarChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarModuloDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarModuloDoubleColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarModuloLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarModuloLongColumnChecked;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="%", value="a _FUNC_ b - Returns the remainder when dividing a by b")
@VectorizedExpressions(value={LongColModuloLongColumn.class, LongColModuloDoubleColumn.class, LongColModuloLongColumnChecked.class, LongColModuloDoubleColumnChecked.class, DoubleColModuloLongColumn.class, DoubleColModuloDoubleColumn.class, DoubleColModuloLongColumnChecked.class, DoubleColModuloDoubleColumnChecked.class, LongColModuloLongScalar.class, LongColModuloDoubleScalar.class, LongColModuloLongScalarChecked.class, LongColModuloDoubleScalarChecked.class, DoubleColModuloLongScalar.class, DoubleColModuloDoubleScalar.class, DoubleColModuloLongScalarChecked.class, DoubleColModuloDoubleScalarChecked.class, LongScalarModuloLongColumn.class, LongScalarModuloDoubleColumn.class, LongScalarModuloLongColumnChecked.class, LongScalarModuloDoubleColumnChecked.class, DoubleScalarModuloLongColumn.class, DoubleScalarModuloDoubleColumn.class, DoubleScalarModuloLongColumnChecked.class, DoubleScalarModuloDoubleColumnChecked.class, DecimalColModuloDecimalColumn.class, DecimalColModuloDecimalScalar.class, DecimalScalarModuloDecimalColumn.class})
public class GenericUDFOPMod
extends GenericUDFBaseNumeric {
    public GenericUDFOPMod() {
        this.opDisplayName = "%";
    }

    @Override
    protected ByteWritable evaluate(ByteWritable left, ByteWritable right) {
        if (right.get() == 0) {
            return null;
        }
        this.byteWritable.set((byte)(left.get() % right.get()));
        return this.byteWritable;
    }

    @Override
    protected ShortWritable evaluate(ShortWritable left, ShortWritable right) {
        if (right.get() == 0) {
            return null;
        }
        this.shortWritable.set((short)(left.get() % right.get()));
        return this.shortWritable;
    }

    @Override
    protected IntWritable evaluate(IntWritable left, IntWritable right) {
        if (right.get() == 0) {
            return null;
        }
        this.intWritable.set(left.get() % right.get());
        return this.intWritable;
    }

    @Override
    protected LongWritable evaluate(LongWritable left, LongWritable right) {
        if (right.get() == 0L) {
            return null;
        }
        this.longWritable.set(left.get() % right.get());
        return this.longWritable;
    }

    @Override
    protected FloatWritable evaluate(FloatWritable left, FloatWritable right) {
        if (right.get() == 0.0f) {
            return null;
        }
        this.floatWritable.set(left.get() % right.get());
        return this.floatWritable;
    }

    @Override
    protected DoubleWritable evaluate(DoubleWritable left, DoubleWritable right) {
        if (right.get() == 0.0) {
            return null;
        }
        this.doubleWritable.set(left.get() % right.get());
        return this.doubleWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimal left, HiveDecimal right) {
        if (right.compareTo(HiveDecimal.ZERO) == 0) {
            return null;
        }
        HiveDecimal dec = left.remainder(right);
        if (dec == null) {
            return null;
        }
        this.decimalWritable.set(dec);
        return this.decimalWritable;
    }

    @Override
    protected DecimalTypeInfo deriveResultDecimalTypeInfo(int prec1, int scale1, int prec2, int scale2) {
        int scale = Math.max(scale1, scale2);
        int prec = Math.min(38, Math.min(prec1 - scale1, prec2 - scale2) + scale);
        return TypeInfoFactory.getDecimalTypeInfo(prec, scale);
    }
}

