/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.hbase.AbstractHBaseKeyFactory;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseRowSerializer;
import org.apache.hadoop.hive.hbase.HBaseSerDeParameters;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;

public class DefaultHBaseKeyFactory
extends AbstractHBaseKeyFactory
implements HBaseKeyFactory {
    protected LazySimpleSerDe.SerDeParameters serdeParams;
    protected HBaseRowSerializer serializer;

    @Override
    public void init(HBaseSerDeParameters hbaseParam, Properties properties) throws SerDeException {
        super.init(hbaseParam, properties);
        this.serdeParams = hbaseParam.getSerdeParams();
        this.serializer = new HBaseRowSerializer(hbaseParam);
    }

    @Override
    public ObjectInspector createKeyObjectInspector(TypeInfo type) throws SerDeException {
        return LazyFactory.createLazyObjectInspector((TypeInfo)type, (byte[])this.serdeParams.getSeparators(), (int)1, (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
    }

    @Override
    public LazyObjectBase createKey(ObjectInspector inspector) throws SerDeException {
        return LazyFactory.createLazyObject((ObjectInspector)inspector, (boolean)this.keyMapping.binaryStorage.get(0));
    }

    @Override
    public byte[] serializeKey(Object object, StructField field) throws IOException {
        return this.serializer.serializeKeyField(object, field, this.keyMapping);
    }

    @VisibleForTesting
    static DefaultHBaseKeyFactory forTest(LazySimpleSerDe.SerDeParameters params, ColumnMappings mappings) {
        DefaultHBaseKeyFactory factory = new DefaultHBaseKeyFactory();
        factory.serdeParams = params;
        factory.keyMapping = mappings.getKeyMapping();
        return factory;
    }
}

