/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase.struct;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseSerDeHelper;
import org.apache.hadoop.hive.hbase.HBaseSerDeParameters;
import org.apache.hadoop.hive.hbase.struct.HBaseValueFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;

public class DefaultHBaseValueFactory
implements HBaseValueFactory {
    protected LazySimpleSerDe.SerDeParameters serdeParams;
    protected ColumnMappings columnMappings;
    protected HBaseSerDeParameters hbaseParams;
    protected Properties properties;
    protected Configuration conf;
    private int fieldID;

    public DefaultHBaseValueFactory(int fieldID) {
        this.fieldID = fieldID;
    }

    @Override
    public void init(HBaseSerDeParameters hbaseParams, Configuration conf, Properties properties) throws SerDeException {
        this.hbaseParams = hbaseParams;
        this.serdeParams = hbaseParams.getSerdeParams();
        this.columnMappings = hbaseParams.getColumnMappings();
        this.properties = properties;
        this.conf = conf;
    }

    @Override
    public ObjectInspector createValueObjectInspector(TypeInfo type) throws SerDeException {
        return LazyFactory.createLazyObjectInspector((TypeInfo)type, (byte[])this.serdeParams.getSeparators(), (int)1, (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
    }

    @Override
    public LazyObjectBase createValueObject(ObjectInspector inspector) throws SerDeException {
        return HBaseSerDeHelper.createLazyField(this.columnMappings.getColumnsMapping(), this.fieldID, inspector);
    }

    @Override
    public byte[] serializeValue(Object object, StructField field) throws IOException {
        return null;
    }
}

