/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseStatsUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;

public class HBaseStatsAggregator
implements StatsAggregator {
    private HTable htable;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());

    public boolean connect(Configuration hiveconf, Task sourceTask) {
        try {
            this.htable = new HTable(HBaseConfiguration.create((Configuration)hiveconf), "PARTITION_STAT_TBL");
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error during HBase connection. ", (Throwable)e);
            return false;
        }
    }

    public String aggregateStats(String rowID, String key) {
        if (!HBaseStatsUtils.isValidStatistic(key)) {
            this.LOG.warn((Object)("Warning. Invalid statistic: " + key + ", supported stats: " + HBaseStatsUtils.getSupportedStatistics()));
            return null;
        }
        byte[] family = HBaseStatsUtils.getFamilyName();
        byte[] column = HBaseStatsUtils.getColumnName(key);
        try {
            long retValue = 0L;
            Scan scan = new Scan();
            scan.addColumn(family, column);
            PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)rowID));
            scan.setFilter((Filter)filter);
            ResultScanner scanner = this.htable.getScanner(scan);
            for (Result result : scanner) {
                retValue += Long.parseLong(Bytes.toString((byte[])result.getValue(family, column)));
            }
            return Long.toString(retValue);
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error during publishing aggregation. ", (Throwable)e);
            return null;
        }
    }

    public boolean closeConnection() {
        return true;
    }

    public boolean cleanUp(String rowID) {
        try {
            Scan scan = new Scan();
            PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)rowID));
            scan.setFilter((Filter)filter);
            ResultScanner scanner = this.htable.getScanner(scan);
            ArrayList<Delete> toDelete = new ArrayList<Delete>();
            for (Result result : scanner) {
                Delete delete = new Delete(result.getRow());
                toDelete.add(delete);
            }
            this.htable.delete(toDelete);
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error during publishing aggregation. ", (Throwable)e);
            return false;
        }
    }

    public boolean connect(StatsCollectionContext scc) {
        return false;
    }

    public boolean closeConnection(StatsCollectionContext scc) {
        return false;
    }
}

