/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;

public class PartitionNameWhitelistPreEventListener
extends MetaStorePreEventListener {
    private static String regex;
    private static Pattern pattern;

    public PartitionNameWhitelistPreEventListener(Configuration config) {
        super(config);
        regex = config.get(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN.varname);
        pattern = Pattern.compile(regex);
    }

    @Override
    public void onEvent(PreEventContext event) throws MetaException, NoSuchObjectException, InvalidOperationException {
        switch (event.getEventType()) {
            case ADD_PARTITION: {
                PartitionNameWhitelistPreEventListener.checkWhitelist(((PreAddPartitionEvent)event).getPartition().getValues());
            }
        }
    }

    private static void checkWhitelist(List<String> partVals) throws MetaException {
        for (String partVal : partVals) {
            if (pattern.matcher(partVal).matches()) continue;
            throw new MetaException("Partition value '" + partVal + "' contains a character " + "not matched by whitelist pattern '" + regex + "'.  " + "(configure with " + HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN.varname + ")");
        }
    }
}

