/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hive.common.util.HiveVersionInfo;

public class MetaStoreSchemaInfo {
    private static String SQL_FILE_EXTENSION = ".sql";
    private static String UPGRADE_FILE_PREFIX = "upgrade-";
    private static String INIT_FILE_PREFIX = "hive-schema-";
    private static String VERSION_UPGRADE_LIST = "upgrade.order";
    private final String dbType;
    private final String[] hiveSchemaVersions;
    private final HiveConf hiveConf;
    private final String hiveHome;

    public MetaStoreSchemaInfo(String hiveHome, HiveConf hiveConf, String dbType) throws HiveMetaException {
        this.hiveHome = hiveHome;
        this.dbType = dbType;
        this.hiveConf = hiveConf;
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try {
            String currSchemaVersion;
            BufferedReader bfReader = new BufferedReader(new FileReader(upgradeListFile));
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new HiveMetaException("File " + upgradeListFile + "not found ", e);
        }
        catch (IOException e) {
            throw new HiveMetaException("Error reading " + upgradeListFile, e);
        }
        this.hiveSchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (MetaStoreSchemaInfo.getHiveSchemaVersion().equals(fromVersion)) {
            return upgradeScriptList;
        }
        int firstScript = this.hiveSchemaVersions.length;
        for (i = 0; i < this.hiveSchemaVersions.length; ++i) {
            if (!this.hiveSchemaVersions[i].startsWith(fromVersion)) continue;
            firstScript = i;
        }
        if (firstScript == this.hiveSchemaVersions.length) {
            throw new HiveMetaException("Unknown version specified for upgrade " + fromVersion + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.hiveSchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.hiveSchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = MetaStoreSchemaInfo.getHiveSchemaVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + toVersion + "." + this.dbType + SQL_FILE_EXTENSION;
        if (!new File(this.getMetaStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new HiveMetaException("Unknown version specified for initialization: " + toVersion);
        }
        return initScriptName;
    }

    public String getMetaStoreScriptDir() {
        return this.hiveHome + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + this.dbType;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return UPGRADE_FILE_PREFIX + fileVersion + "." + this.dbType + SQL_FILE_EXTENSION;
    }

    public static String getHiveSchemaVersion() {
        String versionFromJar = HiveVersionInfo.getShortVersion();
        String version = versionFromJar.substring(0, versionFromJar.indexOf("-mapr"));
        return version;
    }
}

