/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import javax.jdo.JDOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.hooks.JDOConnectionURLHook;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RetryingRawStore
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(RetryingRawStore.class);
    private final RawStore base;
    private int retryInterval = 0;
    private int retryLimit = 0;
    private JDOConnectionURLHook urlHook = null;
    private String urlHookClassName = "";
    private final int id;
    private final HiveConf hiveConf;
    private final Configuration conf;

    protected RetryingRawStore(HiveConf hiveConf, Configuration conf, Class<? extends RawStore> rawStoreClass, int id) throws MetaException {
        this.conf = conf;
        this.hiveConf = hiveConf;
        this.id = id;
        this.init();
        this.base = (RawStore)ReflectionUtils.newInstance(rawStoreClass, (Configuration)conf);
    }

    public static RawStore getProxy(HiveConf hiveConf, Configuration conf, String rawStoreClassName, int id) throws MetaException {
        Class<?> baseClass = MetaStoreUtils.getClass(rawStoreClassName);
        RetryingRawStore handler = new RetryingRawStore(hiveConf, conf, baseClass, id);
        return (RawStore)Proxy.newProxyInstance(RetryingRawStore.class.getClassLoader(), baseClass.getInterfaces(), (InvocationHandler)handler);
    }

    private void init() throws MetaException {
        this.retryInterval = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREINTERVAL);
        this.retryLimit = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREATTEMPTS);
        this.updateConnectionURL(this.getConf(), null);
    }

    private void initMS() {
        this.base.setConf(this.getConf());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        boolean gotNewConnectUrl = false;
        boolean reloadConf = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREFORCERELOADCONF);
        if (reloadConf) {
            this.updateConnectionURL(this.getConf(), null);
        }
        int retryCount = 0;
        Throwable caughtException = null;
        while (true) {
            try {
                if (reloadConf || gotNewConnectUrl) {
                    this.initMS();
                }
                ret = method.invoke((Object)this.base, args);
                break;
            }
            catch (JDOException e) {
                caughtException = e;
            }
            catch (UndeclaredThrowableException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof JDOException) {
                    caughtException = e;
                }
                throw e.getCause();
            }
            if (retryCount >= this.retryLimit) {
                throw caughtException;
            }
            assert (this.retryInterval >= 0);
            LOG.error((Object)String.format("JDO datastore error. Retrying metastore command after %d ms (attempt %d of %d)", this.retryInterval, ++retryCount, this.retryLimit));
            Thread.sleep(this.retryInterval);
            String lastUrl = RetryingRawStore.getConnectionURL(this.getConf());
            gotNewConnectUrl = this.updateConnectionURL(this.getConf(), lastUrl);
        }
        return ret;
    }

    private boolean updateConnectionURL(Configuration conf, String badUrl) throws MetaException {
        String connectUrl = null;
        String currentUrl = RetryingRawStore.getConnectionURL(conf);
        try {
            this.initConnectionUrlHook();
            if (this.urlHook != null) {
                if (badUrl != null) {
                    this.urlHook.notifyBadConnectionUrl(badUrl);
                }
                connectUrl = this.urlHook.getJdoConnectionUrl((Configuration)this.hiveConf);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while getting connection URL from the hook: " + e));
        }
        if (connectUrl != null && !connectUrl.equals(currentUrl)) {
            LOG.error((Object)this.addPrefix(String.format("Overriding %s with %s", HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl)));
            conf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl);
            return true;
        }
        return false;
    }

    private static String getConnectionURL(Configuration conf) {
        return conf.get(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), "");
    }

    private synchronized void initConnectionUrlHook() throws ClassNotFoundException {
        boolean urlHookChanged;
        String className = this.hiveConf.get(HiveConf.ConfVars.METASTORECONNECTURLHOOK.toString(), "").trim();
        if (className.equals("")) {
            this.urlHookClassName = "";
            this.urlHook = null;
            return;
        }
        boolean bl = urlHookChanged = !this.urlHookClassName.equals(className);
        if (this.urlHook == null || urlHookChanged) {
            this.urlHookClassName = className.trim();
            Class<?> urlHookClass = Class.forName(this.urlHookClassName, true, JavaUtils.getClassLoader());
            this.urlHook = (JDOConnectionURLHook)ReflectionUtils.newInstance(urlHookClass, null);
        }
    }

    private String addPrefix(String s) {
        return this.id + ": " + s;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

