/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class RegexSerDe
implements SerDe {
    public static final Log LOG = LogFactory.getLog((String)RegexSerDe.class.getName());
    int numColumns;
    String inputRegex;
    Pattern inputPattern;
    StructObjectInspector rowOI;
    ArrayList<String> row;
    Object[] outputFields;
    Text outputRowText;
    boolean alreadyLoggedNoMatch = false;
    boolean alreadyLoggedPartialMatch = false;
    long unmatchedRowsCount = 0L;
    long partialMatchedRowsCount = 0L;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        int c;
        this.inputRegex = tbl.getProperty("input.regex");
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        boolean inputRegexIgnoreCase = "true".equalsIgnoreCase(tbl.getProperty("input.regex.case.insensitive"));
        if (null != tbl.getProperty("output.format.string")) {
            LOG.warn((Object)"output.format.string has been deprecated");
        }
        if (this.inputRegex == null) {
            this.inputPattern = null;
            throw new SerDeException("This table does not have serde property \"input.regex\"!");
        }
        this.inputPattern = Pattern.compile(this.inputRegex, 32 + (inputRegexIgnoreCase ? 2 : 0));
        List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
        ArrayList<TypeInfo> columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        assert (columnNames.size() == columnTypes.size());
        this.numColumns = columnNames.size();
        for (int c2 = 0; c2 < this.numColumns; ++c2) {
            if (((TypeInfo)columnTypes.get(c2)).equals(TypeInfoFactory.stringTypeInfo)) continue;
            throw new SerDeException(this.getClass().getName() + " only accepts string columns, but column[" + c2 + "] named " + columnNames.get(c2) + " has type " + columnTypes.get(c2));
        }
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(columnNames.size());
        for (c = 0; c < this.numColumns; ++c) {
            columnOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, columnOIs);
        this.row = new ArrayList(this.numColumns);
        for (c = 0; c < this.numColumns; ++c) {
            this.row.add(null);
        }
        this.outputFields = new Object[this.numColumns];
        this.outputRowText = new Text();
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        Text rowText = (Text)blob;
        Matcher m = this.inputPattern.matcher(rowText.toString());
        if (m.groupCount() != this.numColumns) {
            throw new SerDeException("Number of matching groups doesn't match the number of columns");
        }
        if (!m.matches()) {
            ++this.unmatchedRowsCount;
            if (!this.alreadyLoggedNoMatch) {
                LOG.warn((Object)("" + this.unmatchedRowsCount + " unmatched rows are found: " + rowText));
                this.alreadyLoggedNoMatch = true;
            }
            return null;
        }
        for (int c = 0; c < this.numColumns; ++c) {
            try {
                this.row.set(c, m.group(c + 1));
                continue;
            }
            catch (RuntimeException e) {
                ++this.partialMatchedRowsCount;
                if (!this.alreadyLoggedPartialMatch) {
                    LOG.warn((Object)("" + this.partialMatchedRowsCount + " partially unmatched rows are found, " + " cannot find group " + c + ": " + rowText));
                    this.alreadyLoggedPartialMatch = true;
                }
                this.row.set(c, null);
            }
        }
        return this.row;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException("Regex SerDe doesn't support the serialize() method");
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }
}

